/*
 * Decompiled with CFR 0.152.
 */
package jcifs.util;

import java.io.IOException;
import java.util.Date;

public class Encdec {
    public static final long MILLISECONDS_BETWEEN_1970_AND_1601 = 11644473600000L;
    public static final long SEC_BETWEEEN_1904_AND_1970 = 2082844800L;
    public static final int TIME_1970_SEC_32BE = 1;
    public static final int TIME_1970_SEC_32LE = 2;
    public static final int TIME_1904_SEC_32BE = 3;
    public static final int TIME_1904_SEC_32LE = 4;
    public static final int TIME_1601_NANOS_64LE = 5;
    public static final int TIME_1601_NANOS_64BE = 6;
    public static final int TIME_1970_MILLIS_64BE = 7;
    public static final int TIME_1970_MILLIS_64LE = 8;

    public static int enc_uint16be(short s, byte[] byArray, int n2) {
        byArray[n2++] = (byte)(s >> 8 & 0xFF);
        byArray[n2] = (byte)(s & 0xFF);
        return 2;
    }

    public static int enc_uint32be(int n2, byte[] byArray, int n3) {
        byArray[n3++] = (byte)(n2 >> 24 & 0xFF);
        byArray[n3++] = (byte)(n2 >> 16 & 0xFF);
        byArray[n3++] = (byte)(n2 >> 8 & 0xFF);
        byArray[n3] = (byte)(n2 & 0xFF);
        return 4;
    }

    public static int enc_uint16le(short s, byte[] byArray, int n2) {
        byArray[n2++] = (byte)(s & 0xFF);
        byArray[n2] = (byte)(s >> 8 & 0xFF);
        return 2;
    }

    public static int enc_uint32le(int n2, byte[] byArray, int n3) {
        byArray[n3++] = (byte)(n2 & 0xFF);
        byArray[n3++] = (byte)(n2 >> 8 & 0xFF);
        byArray[n3++] = (byte)(n2 >> 16 & 0xFF);
        byArray[n3] = (byte)(n2 >> 24 & 0xFF);
        return 4;
    }

    public static short dec_uint16be(byte[] byArray, int n2) {
        return (short)((byArray[n2] & 0xFF) << 8 | byArray[n2 + 1] & 0xFF);
    }

    public static int dec_uint32be(byte[] byArray, int n2) {
        return (byArray[n2] & 0xFF) << 24 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 2] & 0xFF) << 8 | byArray[n2 + 3] & 0xFF;
    }

    public static short dec_uint16le(byte[] byArray, int n2) {
        return (short)(byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8);
    }

    public static int dec_uint32le(byte[] byArray, int n2) {
        return byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8 | (byArray[n2 + 2] & 0xFF) << 16 | (byArray[n2 + 3] & 0xFF) << 24;
    }

    public static int enc_uint64be(long l2, byte[] byArray, int n2) {
        Encdec.enc_uint32be((int)(l2 & 0xFFFFFFFFL), byArray, n2 + 4);
        Encdec.enc_uint32be((int)(l2 >> 32 & 0xFFFFFFFFL), byArray, n2);
        return 8;
    }

    public static int enc_uint64le(long l2, byte[] byArray, int n2) {
        Encdec.enc_uint32le((int)(l2 & 0xFFFFFFFFL), byArray, n2);
        Encdec.enc_uint32le((int)(l2 >> 32 & 0xFFFFFFFFL), byArray, n2 + 4);
        return 8;
    }

    public static long dec_uint64be(byte[] byArray, int n2) {
        long l2 = (long)Encdec.dec_uint32be(byArray, n2) & 0xFFFFFFFFL;
        l2 <<= 32;
        return l2 |= (long)Encdec.dec_uint32be(byArray, n2 + 4) & 0xFFFFFFFFL;
    }

    public static long dec_uint64le(byte[] byArray, int n2) {
        long l2 = (long)Encdec.dec_uint32le(byArray, n2 + 4) & 0xFFFFFFFFL;
        l2 <<= 32;
        return l2 |= (long)Encdec.dec_uint32le(byArray, n2) & 0xFFFFFFFFL;
    }

    public static int enc_floatle(float f2, byte[] byArray, int n2) {
        return Encdec.enc_uint32le(Float.floatToIntBits(f2), byArray, n2);
    }

    public static int enc_floatbe(float f2, byte[] byArray, int n2) {
        return Encdec.enc_uint32be(Float.floatToIntBits(f2), byArray, n2);
    }

    public static float dec_floatle(byte[] byArray, int n2) {
        return Float.intBitsToFloat(Encdec.dec_uint32le(byArray, n2));
    }

    public static float dec_floatbe(byte[] byArray, int n2) {
        return Float.intBitsToFloat(Encdec.dec_uint32be(byArray, n2));
    }

    public static int enc_doublele(double d2, byte[] byArray, int n2) {
        return Encdec.enc_uint64le(Double.doubleToLongBits(d2), byArray, n2);
    }

    public static int enc_doublebe(double d2, byte[] byArray, int n2) {
        return Encdec.enc_uint64be(Double.doubleToLongBits(d2), byArray, n2);
    }

    public static double dec_doublele(byte[] byArray, int n2) {
        return Double.longBitsToDouble(Encdec.dec_uint64le(byArray, n2));
    }

    public static double dec_doublebe(byte[] byArray, int n2) {
        return Double.longBitsToDouble(Encdec.dec_uint64be(byArray, n2));
    }

    public static int enc_time(Date date, byte[] byArray, int n2, int n3) {
        switch (n3) {
            case 1: {
                return Encdec.enc_uint32be((int)(date.getTime() / 1000L), byArray, n2);
            }
            case 2: {
                return Encdec.enc_uint32le((int)(date.getTime() / 1000L), byArray, n2);
            }
            case 3: {
                return Encdec.enc_uint32be((int)(date.getTime() / 1000L + 2082844800L & 0xFFFFFFFFFFFFFFFFL), byArray, n2);
            }
            case 4: {
                return Encdec.enc_uint32le((int)(date.getTime() / 1000L + 2082844800L & 0xFFFFFFFFFFFFFFFFL), byArray, n2);
            }
            case 6: {
                long l2 = (date.getTime() + 11644473600000L) * 10000L;
                return Encdec.enc_uint64be(l2, byArray, n2);
            }
            case 5: {
                long l3 = (date.getTime() + 11644473600000L) * 10000L;
                return Encdec.enc_uint64le(l3, byArray, n2);
            }
            case 7: {
                return Encdec.enc_uint64be(date.getTime(), byArray, n2);
            }
            case 8: {
                return Encdec.enc_uint64le(date.getTime(), byArray, n2);
            }
        }
        throw new IllegalArgumentException("Unsupported time encoding");
    }

    public static Date dec_time(byte[] byArray, int n2, int n3) {
        switch (n3) {
            case 1: {
                return new Date((long)Encdec.dec_uint32be(byArray, n2) * 1000L);
            }
            case 2: {
                return new Date((long)Encdec.dec_uint32le(byArray, n2) * 1000L);
            }
            case 3: {
                return new Date((((long)Encdec.dec_uint32be(byArray, n2) & 0xFFFFFFFFL) - 2082844800L) * 1000L);
            }
            case 4: {
                return new Date((((long)Encdec.dec_uint32le(byArray, n2) & 0xFFFFFFFFL) - 2082844800L) * 1000L);
            }
            case 6: {
                long l2 = Encdec.dec_uint64be(byArray, n2);
                return new Date(l2 / 10000L - 11644473600000L);
            }
            case 5: {
                long l3 = Encdec.dec_uint64le(byArray, n2);
                return new Date(l3 / 10000L - 11644473600000L);
            }
            case 7: {
                return new Date(Encdec.dec_uint64be(byArray, n2));
            }
            case 8: {
                return new Date(Encdec.dec_uint64le(byArray, n2));
            }
        }
        throw new IllegalArgumentException("Unsupported time encoding");
    }

    public static int enc_utf8(String string, byte[] byArray, int n2, int n3) throws IOException {
        int n4 = n2;
        int n5 = string.length();
        for (int i2 = 0; n2 < n3 && i2 < n5; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 >= '\u0001' && c2 <= '\u007f') {
                byArray[n2++] = (byte)c2;
                continue;
            }
            if (c2 > '\u07ff') {
                if (n3 - n2 < 3) break;
                byArray[n2++] = (byte)(0xE0 | c2 >> 12 & 0xF);
                byArray[n2++] = (byte)(0x80 | c2 >> 6 & 0x3F);
                byArray[n2++] = (byte)(0x80 | c2 >> 0 & 0x3F);
                continue;
            }
            if (n3 - n2 < 2) break;
            byArray[n2++] = (byte)(0xC0 | c2 >> 6 & 0x1F);
            byArray[n2++] = (byte)(0x80 | c2 >> 0 & 0x3F);
        }
        return n2 - n4;
    }

    public static String dec_utf8(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        char[] cArray = new char[n3 - n2];
        int n5 = 0;
        while (n2 < n3 && (n4 = byArray[n2++] & 0xFF) != 0) {
            if (n4 < 128) {
                cArray[n5] = (char)n4;
            } else if ((n4 & 0xE0) == 192) {
                if (n3 - n2 < 2) break;
                cArray[n5] = (char)((n4 & 0x1F) << 6);
                n4 = byArray[n2++] & 0xFF;
                int n6 = n5;
                cArray[n6] = (char)(cArray[n6] | n4 & 0x3F);
                if ((n4 & 0xC0) != 128 || cArray[n5] < '\u0080') {
                    throw new IOException("Invalid UTF-8 sequence");
                }
            } else if ((n4 & 0xF0) == 224) {
                if (n3 - n2 < 3) break;
                cArray[n5] = (char)((n4 & 0xF) << 12);
                if (((n4 = byArray[n2++] & 0xFF) & 0xC0) != 128) {
                    throw new IOException("Invalid UTF-8 sequence");
                }
                int n7 = n5;
                cArray[n7] = (char)(cArray[n7] | (n4 & 0x3F) << 6);
                n4 = byArray[n2++] & 0xFF;
                int n8 = n5;
                cArray[n8] = (char)(cArray[n8] | n4 & 0x3F);
                if ((n4 & 0xC0) != 128 || cArray[n5] < '\u0800') {
                    throw new IOException("Invalid UTF-8 sequence");
                }
            } else {
                throw new IOException("Unsupported UTF-8 sequence");
            }
            ++n5;
        }
        return new String(cArray, 0, n5);
    }

    public static String dec_ucs2le(byte[] byArray, int n2, int n3, char[] cArray) throws IOException {
        int n4 = 0;
        while (n2 + 1 < n3) {
            cArray[n4] = (char)Encdec.dec_uint16le(byArray, n2);
            if (cArray[n4] == '\u0000') break;
            ++n4;
            n2 += 2;
        }
        return new String(cArray, 0, n4);
    }
}

