/*
 * Decompiled with CFR 0.152.
 */
package jcifs.util.transport;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import jcifs.util.LogStream;
import jcifs.util.transport.Request;
import jcifs.util.transport.Response;
import jcifs.util.transport.TransportException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class Transport
implements Runnable {
    static int id = 0;
    static LogStream log = LogStream.getInstance();
    int state = 0;
    String name = "Transport" + id++;
    Thread thread;
    TransportException te;
    protected HashMap response_map = new HashMap(4);

    public static int readn(InputStream inputStream, byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        int n5 = -5;
        for (n4 = 0; n4 < n3 && (n5 = inputStream.read(byArray, n2 + n4, n3 - n4)) > 0; n4 += n5) {
        }
        return n4;
    }

    protected abstract void makeKey(Request var1) throws IOException;

    protected abstract Request peekKey() throws IOException;

    protected abstract void doSend(Request var1) throws IOException;

    protected abstract void doRecv(Response var1) throws IOException;

    protected abstract void doSkip() throws IOException;

    public synchronized void sendrecv(Request request, Response response, long l2) throws IOException {
        this.makeKey(request);
        response.isReceived = false;
        try {
            this.response_map.put(request, response);
            this.doSend(request);
            response.expiration = System.currentTimeMillis() + l2;
            while (!response.isReceived) {
                this.wait(l2);
                l2 = response.expiration - System.currentTimeMillis();
                if (l2 > 0L) continue;
                throw new TransportException(this.name + " timedout waiting for response to " + request);
            }
        }
        catch (IOException iOException) {
            if (LogStream.level > 2) {
                iOException.printStackTrace(log);
            }
            try {
                this.disconnect(true);
            }
            catch (IOException iOException2) {
                iOException2.printStackTrace(log);
            }
            throw iOException;
        }
        catch (InterruptedException interruptedException) {
            throw new TransportException(interruptedException);
        }
        finally {
            this.response_map.remove(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void if() {
        while (this.thread == Thread.currentThread()) {
            Object object;
            try {
                Request request = this.peekKey();
                if (request == null) {
                    throw new IOException("end of stream");
                }
                object = this;
                synchronized (object) {
                    Response response = (Response)this.response_map.get(request);
                    if (response == null) {
                        if (LogStream.level >= 4) {
                            log.println("Invalid key, skipping message");
                        }
                        this.doSkip();
                    } else {
                        this.doRecv(response);
                        response.isReceived = true;
                        this.notifyAll();
                    }
                }
            }
            catch (Exception exception) {
                boolean bl;
                object = exception.getMessage();
                boolean bl2 = object != null && ((String)object).equals("Read timed out");
                boolean bl3 = bl = !bl2;
                if (!bl2) {
                    if (LogStream.level >= 3) {
                        exception.printStackTrace(log);
                    }
                }
                try {
                    this.disconnect(bl);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace(log);
                }
            }
        }
    }

    protected abstract void doConnect() throws Exception;

    protected abstract void doDisconnect(boolean var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void connect(long l2) throws TransportException {
        block24: {
            block23: {
                block22: {
                    try {
                        try {
                            switch (this.state) {
                                case 0: {
                                    break;
                                }
                                case 3: {
                                    Object var6_2 = null;
                                    if (this.state == 0) return;
                                    if (this.state == 3) return;
                                    if (this.state == 4) return;
                                    break block22;
                                }
                                case 4: {
                                    this.state = 0;
                                    throw new TransportException("Connection in error", this.te);
                                }
                                default: {
                                    TransportException transportException = new TransportException("Invalid state: " + this.state);
                                    this.state = 0;
                                    throw transportException;
                                }
                            }
                            this.state = 1;
                            this.te = null;
                            this.thread = new Thread((Runnable)this, this.name);
                            this.thread.setDaemon(true);
                            Thread thread = this.thread;
                            synchronized (thread) {
                                this.thread.start();
                                this.thread.wait(l2);
                                switch (this.state) {
                                    case 1: {
                                        this.state = 0;
                                        this.thread = null;
                                        throw new TransportException("Connection timeout");
                                    }
                                    case 2: {
                                        if (this.te != null) {
                                            this.state = 4;
                                            this.thread = null;
                                            throw this.te;
                                        }
                                        this.state = 3;
                                        // MONITOREXIT @DISABLED, blocks:[0, 1, 4, 10, 12] lbl39 : MonitorExitStatement: MONITOREXIT : var3_7
                                        break block23;
                                    }
                                    default: {
                                        break;
                                    }
                                }
                            }
                            break block24;
                        }
                        catch (InterruptedException interruptedException) {
                            this.state = 0;
                            this.thread = null;
                            throw new TransportException(interruptedException);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var6_5 = null;
                        if (this.state == 0) throw throwable;
                        if (this.state == 3) throw throwable;
                        if (this.state == 4) throw throwable;
                        if (LogStream.level >= 1) {
                            log.println("Invalid state: " + this.state);
                        }
                        this.state = 0;
                        this.thread = null;
                        throw throwable;
                    }
                }
                if (LogStream.level >= 1) {
                    log.println("Invalid state: " + this.state);
                }
                this.state = 0;
                this.thread = null;
                return;
            }
            Object var6_3 = null;
            if (this.state == 0) return;
            if (this.state == 3) return;
            if (this.state == 4) return;
            if (LogStream.level >= 1) {
                log.println("Invalid state: " + this.state);
            }
            this.state = 0;
            this.thread = null;
            return;
        }
        Object var6_4 = null;
        if (this.state == 0) return;
        if (this.state == 3) return;
        if (this.state == 4) return;
        if (LogStream.level >= 1) {
            log.println("Invalid state: " + this.state);
        }
        this.state = 0;
        this.thread = null;
    }

    public synchronized void disconnect(boolean bl) throws IOException {
        switch (this.state) {
            case 0: {
                return;
            }
            case 2: {
                bl = true;
            }
            case 3: {
                if (this.response_map.size() != 0 && !bl) break;
                this.doDisconnect(bl);
            }
            case 4: {
                this.thread = null;
                this.state = 0;
                break;
            }
            default: {
                if (LogStream.level >= 1) {
                    log.println("Invalid state: " + this.state);
                }
                this.thread = null;
                this.state = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Thread thread;
        Thread thread2 = Thread.currentThread();
        Exception exception = null;
        try {
            try {
                this.doConnect();
            }
            catch (Exception exception2) {
                exception = exception2;
                Object var5_4 = null;
                Thread thread4 = thread2;
                synchronized (thread4) {
                    if (thread2 != this.thread) {
                        if (exception != null) {
                            exception.printStackTrace();
                        }
                        return;
                    }
                    if (exception != null) {
                        this.te = new TransportException(exception);
                    }
                    this.state = 2;
                    thread2.notify();
                    return;
                }
            }
            Object var5_3 = null;
            thread = thread2;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            Thread thread3 = thread2;
            synchronized (thread3) {
                if (thread2 != this.thread) {
                    if (exception != null) {
                        exception.printStackTrace();
                    }
                    return;
                }
                if (exception != null) {
                    this.te = new TransportException(exception);
                }
                this.state = 2;
                thread2.notify();
                throw throwable;
            }
        }
        synchronized (thread) {
            if (thread2 != this.thread) {
                if (exception != null) {
                    exception.printStackTrace();
                }
                return;
            }
            if (exception != null) {
                this.te = new TransportException(exception);
            }
            this.state = 2;
            thread2.notify();
        }
        this.if();
    }

    public String toString() {
        return this.name;
    }
}

