/*
 * Decompiled with CFR 0.152.
 */
package jstels.database.io;

import java.io.InputStream;
import jstels.database.io.CommonsVFSFileManager;
import jstels.database.io.DirectoryManager;
import jstels.database.io.FileManager;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.VFS;
import org.apache.commons.vfs.impl.DefaultFileSystemManager;
import org.apache.commons.vfs.provider.sftp.SftpFileSystemConfigBuilder;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CommonsVFSDirectoryManager
extends DirectoryManager {
    private String int;
    private FileObject for;
    DefaultFileSystemManager fileSystem = null;

    public CommonsVFSDirectoryManager(String string) throws Exception {
        this(string, null);
    }

    public CommonsVFSDirectoryManager(String string, String string2) throws Exception {
        this.tempPath = string2;
        if (string.trim().length() == 0) {
            throw new IllegalArgumentException("Empty path is incorrect");
        }
        this.int = string;
        if (!this.int.endsWith("\\") || this.int.endsWith("/")) {
            this.int = this.int + "/";
        }
        FileSystemOptions fileSystemOptions = new FileSystemOptions();
        SftpFileSystemConfigBuilder sftpFileSystemConfigBuilder = SftpFileSystemConfigBuilder.getInstance();
        sftpFileSystemConfigBuilder.setStrictHostKeyChecking(fileSystemOptions, "no");
        sftpFileSystemConfigBuilder.setTimeout(fileSystemOptions, new Integer(1000));
        this.fileSystem = (DefaultFileSystemManager)VFS.getManager();
        this.for = this.fileSystem.resolveFile(this.int, fileSystemOptions);
        this.for.close();
    }

    public FileManager getFileManager(String string) throws Exception {
        int n2 = FileManager.checkPath(string);
        if (n2 == 10) {
            CommonsVFSFileManager commonsVFSFileManager = new CommonsVFSFileManager(this, string);
            commonsVFSFileManager.setTempPath(this.tempPath);
            return commonsVFSFileManager;
        }
        return FileManager.buildFileManager(this, string, this.tempPath, n2);
    }

    public void createFile(String string) throws Exception {
        CommonsVFSFileManager commonsVFSFileManager = new CommonsVFSFileManager(this, string);
        commonsVFSFileManager.create();
        commonsVFSFileManager.close();
    }

    public void dropFile(String string) throws Exception {
        CommonsVFSFileManager commonsVFSFileManager = new CommonsVFSFileManager(this, string);
        commonsVFSFileManager.delete();
        commonsVFSFileManager.close();
    }

    public FileManager[] listFiles(String string, String string2) {
        return null;
    }

    public String getPath() {
        return this.int;
    }

    public boolean isReadOnly() {
        return false;
    }

    public boolean supportsAppending() {
        return false;
    }

    public boolean supportsRandomAccess() {
        return false;
    }

    public void flush() throws Exception {
    }

    public void close() {
        try {
            if (this.fileSystem != null) {
                this.fileSystem.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        try {
            int n2;
            CommonsVFSDirectoryManager commonsVFSDirectoryManager = new CommonsVFSDirectoryManager("sftp://serg:derfli@127.0.0.1:22/sftp");
            FileManager fileManager = commonsVFSDirectoryManager.getFileManager("test/prices.txt");
            InputStream inputStream = fileManager.getInputStream();
            while ((n2 = inputStream.read()) != -1) {
                char c2 = (char)n2;
                System.out.print("" + (char)n2);
            }
            fileManager.close();
            commonsVFSDirectoryManager.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

