/*
 * Decompiled with CFR 0.152.
 */
package jstels.database.io;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import jstels.database.io.CommonsVFSDirectoryManager;
import jstels.database.io.DirectoryManager;
import jstels.database.io.FileManager;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.provider.sftp.SftpFileSystem;
import org.apache.commons.vfs.provider.sftp.SftpFileSystemConfigBuilder;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CommonsVFSFileManager
extends FileManager {
    private String int;
    private FileObject for;
    private CommonsVFSDirectoryManager dir;

    public CommonsVFSFileManager(CommonsVFSDirectoryManager commonsVFSDirectoryManager, String string) throws Exception {
        this.dir = commonsVFSDirectoryManager;
        this.int = commonsVFSDirectoryManager.getPath() + string;
        FileSystemOptions fileSystemOptions = new FileSystemOptions();
        SftpFileSystemConfigBuilder sftpFileSystemConfigBuilder = SftpFileSystemConfigBuilder.getInstance();
        sftpFileSystemConfigBuilder.setStrictHostKeyChecking(fileSystemOptions, "no");
        sftpFileSystemConfigBuilder.setTimeout(fileSystemOptions, new Integer(1000));
        this.for = commonsVFSDirectoryManager.fileSystem.resolveFile(this.int, fileSystemOptions);
    }

    public CommonsVFSFileManager(String string) throws Exception {
    }

    public RandomAccessFile getRandomAccess(String string) throws Exception {
        return null;
    }

    public OutputStream getOutputStream(boolean bl) throws Exception {
        try {
            return this.for.getContent().getOutputStream(bl);
        }
        catch (Exception exception) {
            if (this.for.getFileSystem() instanceof SftpFileSystem) {
                ((SftpFileSystem)this.for.getFileSystem()).closeCommunicationLink();
                return this.for.getContent().getOutputStream(bl);
            }
            throw new Exception(exception);
        }
    }

    public InputStream getInputStream() throws Exception {
        try {
            return this.for.getContent().getInputStream();
        }
        catch (FileSystemException fileSystemException) {
            if (this.for.getFileSystem() instanceof SftpFileSystem) {
                ((SftpFileSystem)this.for.getFileSystem()).closeCommunicationLink();
                return this.for.getContent().getInputStream();
            }
            throw new Exception(fileSystemException);
        }
    }

    public String getPath() {
        try {
            return this.for.getURL().toString();
        }
        catch (FileSystemException fileSystemException) {
            return null;
        }
    }

    public String getDirPath() {
        return this.getDir().getPath();
    }

    public DirectoryManager getDir() {
        try {
            return new CommonsVFSDirectoryManager(this.for.getParent().getURL().toString(), this.tempPath);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getName() {
        return this.for.getName().getBaseName();
    }

    public boolean exists() {
        try {
            return this.for.exists();
        }
        catch (FileSystemException fileSystemException) {
            return false;
        }
    }

    public boolean isReadOnly() {
        try {
            return !this.for.isWriteable();
        }
        catch (FileSystemException fileSystemException) {
            return false;
        }
    }

    public boolean isDirectory() {
        try {
            return this.for.getType().getName().equals("folder");
        }
        catch (FileSystemException fileSystemException) {
            return false;
        }
    }

    public void create() throws Exception {
        try {
            this.for.createFile();
        }
        catch (FileSystemException fileSystemException) {
            if (this.for.getFileSystem() instanceof SftpFileSystem) {
                ((SftpFileSystem)this.for.getFileSystem()).closeCommunicationLink();
                this.for.createFile();
            }
            throw new Exception(fileSystemException);
        }
    }

    public void delete() throws Exception {
        try {
            this.for.delete();
        }
        catch (FileSystemException fileSystemException) {
            if (this.for.getFileSystem() instanceof SftpFileSystem) {
                ((SftpFileSystem)this.for.getFileSystem()).closeCommunicationLink();
                this.for.delete();
            }
            throw new Exception(fileSystemException);
        }
    }

    public void close() throws Exception {
        this.dir = null;
        if (this.for != null) {
            this.for.close();
        }
        this.for = null;
    }

    public static void main(String[] stringArray) {
    }
}

