/*
 * Decompiled with CFR 0.152.
 */
package jstels.database.io;

import java.io.File;
import jstels.database.io.ClasspathDirectoryManager;
import jstels.database.io.CommonsVFSDirectoryManager;
import jstels.database.io.FTPDirectoryManager;
import jstels.database.io.FileCacheDirectoryManager;
import jstels.database.io.FileManager;
import jstels.database.io.FileManagerEvent;
import jstels.database.io.HTTPDirectoryManager;
import jstels.database.io.LocalFileDirectoryManager;
import jstels.database.io.SMBDirectoryManager;
import jstels.database.io.ZipDirectoryManager;

public abstract class DirectoryManager {
    protected String tempPath = null;

    public static DirectoryManager buildDirectoryManager(String string) throws Exception {
        return DirectoryManager.buildDirectoryManager(string, null, null);
    }

    public static DirectoryManager buildDirectoryManager(String string, String string2) throws Exception {
        return DirectoryManager.buildDirectoryManager(string, string2, null);
    }

    public static DirectoryManager buildDirectoryManager(String string, String string2, String string3) throws Exception {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("'path' argument may not be empty or null");
        }
        DirectoryManager directoryManager = null;
        if (string.startsWith("directhttp://")) {
            directoryManager = new HTTPDirectoryManager(string.substring("direct".length()), string3);
        } else if (string.startsWith("directftp://")) {
            directoryManager = new FTPDirectoryManager(string.substring("direct".length()));
        } else if (string.startsWith("http://")) {
            directoryManager = new FileCacheDirectoryManager(new HTTPDirectoryManager(string, string3), string2);
        } else if (string.startsWith("ftp://")) {
            directoryManager = new FileCacheDirectoryManager(new FTPDirectoryManager(string), string2);
        } else if (string.startsWith("sftp://")) {
            directoryManager = new FileCacheDirectoryManager(new CommonsVFSDirectoryManager(string), string2);
        } else if (string.startsWith("cache://")) {
            directoryManager = new FileCacheDirectoryManager(DirectoryManager.buildDirectoryManager(string.substring("cache://".length()), string2), string2);
        } else if (string.startsWith("zip://") || string.startsWith("jar://")) {
            directoryManager = new ZipDirectoryManager(string, string2);
        } else if (string.startsWith("classpath://")) {
            directoryManager = new ClasspathDirectoryManager(string);
        } else if (string.startsWith("smb://")) {
            directoryManager = new SMBDirectoryManager(string);
        } else if (string.startsWith("file://")) {
            directoryManager = new LocalFileDirectoryManager(string.substring("file://".length()));
        } else {
            if (new File(string).isFile()) {
                throw new IllegalArgumentException("Path must not be a file: " + string);
            }
            if (new File(string).isDirectory()) {
                directoryManager = new LocalFileDirectoryManager(string);
            } else {
                throw new IllegalArgumentException("Invalid path or path not found: " + string);
            }
        }
        directoryManager.setTempPath(string2);
        return directoryManager;
    }

    public abstract String getPath();

    public abstract FileManager getFileManager(String var1) throws Exception;

    public boolean exists(String string) {
        try {
            return this.getFileManager(string).exists();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public abstract void dropFile(String var1) throws Exception;

    public abstract void createFile(String var1) throws Exception;

    public void fileManagerEventHappened(FileManagerEvent fileManagerEvent) {
    }

    public void upload(String string, FileManager fileManager) throws Exception {
    }

    public abstract FileManager[] listFiles(String var1, String var2);

    public abstract boolean isReadOnly();

    public abstract boolean supportsAppending();

    public abstract boolean supportsRandomAccess();

    public abstract void flush() throws Exception;

    public abstract void close();

    public void setTempPath(String string) {
        this.tempPath = string;
    }

    public String getTempPath() {
        return this.tempPath;
    }
}

