/*
 * Decompiled with CFR 0.152.
 */
package jstels.database.io;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import jstels.database.io.DirectoryManager;
import jstels.database.io.FileCache;
import jstels.database.io.FileManager;
import jstels.database.io.FileManagerEvent;
import jstels.database.io.FileManagerListener;
import jstels.database.io.FileObjectInfo;
import jstels.database.io.LocalFileManager;
import jstels.utils.FileUtils;
import jstels.utils.c;

public class FileCacheDirectoryManager
extends DirectoryManager
implements FileManagerListener {
    DirectoryManager dir;
    FileCache fileCache = new FileCache();
    String cacheFilesPath = null;

    public FileCacheDirectoryManager(DirectoryManager directoryManager, String string) {
        this.dir = directoryManager;
        this.cacheFilesPath = FileUtils.CreateRandomSubDir(string);
    }

    public boolean isReadOnly() {
        return this.dir.isReadOnly();
    }

    public void dropFile(String string) throws Exception {
        this.dir.dropFile(string);
        FileObjectInfo fileObjectInfo = (FileObjectInfo)this.fileCache.get(string);
        if (fileObjectInfo != null) {
            fileObjectInfo.getFileManager().delete();
            this.fileCache.remove(string);
        }
    }

    public boolean supportsAppending() {
        return true;
    }

    public boolean exists(String string) {
        try {
            return this.dir.getFileManager(string).exists();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public FileManager getFileManager(String string) throws Exception {
        OutputStream outputStream;
        InputStream inputStream;
        int n2 = FileManager.checkPath(string);
        if (n2 != 10) {
            return FileManager.buildFileManager(this, string, this.tempPath, n2);
        }
        LocalFileManager localFileManager = null;
        FileObjectInfo fileObjectInfo = (FileObjectInfo)this.fileCache.get(string);
        if (fileObjectInfo == null) {
            FileManager fileManager = this.dir.getFileManager(string);
            if (!fileManager.exists()) {
                throw new Exception("File to be cached '" + fileManager.getPath() + "' does not exist!");
            }
            String string2 = c.a(this.cacheFilesPath, string);
            File file = new File(string2);
            if (new File(string).getParentFile() != null) {
                file.getParentFile().mkdirs();
            }
            localFileManager = new LocalFileManager(file);
            localFileManager.setTempPath(this.tempPath);
            inputStream = fileManager.getInputStream();
            outputStream = ((FileManager)localFileManager).getOutputStream(false);
            if (inputStream == null) {
                throw new RuntimeException("File '" + this.getPath() + string + "' is not found");
            }
        } else {
            return fileObjectInfo.getFileManager();
        }
        FileUtils.copyStream(inputStream, outputStream);
        FileObjectInfo fileObjectInfo2 = new FileObjectInfo();
        localFileManager.addListener(this);
        fileObjectInfo2.setFileManager(localFileManager);
        this.fileCache.set(string, fileObjectInfo2);
        return localFileManager;
    }

    private void a(FileManager fileManager) throws Exception {
        FileManager fileManager2 = this.dir.getFileManager(fileManager.getName());
        FileUtils.copyStream(fileManager.getInputStream(), fileManager2.getOutputStream(false));
    }

    public void flush() throws Exception {
        FileObjectInfo[] fileObjectInfoArray = this.fileCache.getFileInfos();
        for (int i2 = 0; i2 < fileObjectInfoArray.length; ++i2) {
            FileObjectInfo fileObjectInfo = fileObjectInfoArray[i2];
            if (!fileObjectInfo.isUpdated()) continue;
            this.a(fileObjectInfo.getFileManager());
            fileObjectInfo.setUpdated(false);
        }
    }

    public void fileManagerEventHappened(FileManagerEvent fileManagerEvent) {
        if (fileManagerEvent.getEventCode() == 1) {
            String string = fileManagerEvent.getFileManager().getName();
            FileObjectInfo fileObjectInfo = (FileObjectInfo)this.fileCache.get(string);
            if (fileObjectInfo == null) {
                FileObjectInfo fileObjectInfo2 = new FileObjectInfo(true);
                fileObjectInfo2.setFileManager(fileManagerEvent.getFileManager());
                this.fileCache.set(string, fileObjectInfo);
            } else {
                fileObjectInfo.setUpdated(true);
            }
        }
    }

    public boolean supportsRandomAccess() {
        return true;
    }

    public String getPath() {
        return this.dir.getPath();
    }

    public void close() {
        try {
            if (this.fileCache != null) {
                this.flush();
                FileManager[] fileManagerArray = this.fileCache.getFileManagers();
                for (int i2 = 0; i2 < fileManagerArray.length; ++i2) {
                    fileManagerArray[i2].delete();
                    fileManagerArray[i2].clearListeners();
                }
                this.fileCache.clear();
                this.dir.close();
                FileUtils.clearAllDir(new File(this.cacheFilesPath));
                this.fileCache = null;
                this.dir = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public FileManager[] listFiles(String string, String string2) {
        return this.dir.listFiles(string, string2);
    }

    public void createFile(String string) throws Exception {
        this.dir.createFile(string);
    }

    public void upload(String string, FileManager fileManager) throws Exception {
        this.a(fileManager);
        if (!this.fileCache.containsKey(string)) {
            FileObjectInfo fileObjectInfo = new FileObjectInfo(false);
            fileObjectInfo.setFileManager(fileManager);
            this.fileCache.set(string, fileObjectInfo);
        } else {
            FileObjectInfo fileObjectInfo = (FileObjectInfo)this.fileCache.get(string);
            fileObjectInfo.setUpdated(false);
        }
    }
}

