/*
 * Decompiled with CFR 0.152.
 */
package jstels.database.io;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import jstels.database.io.DirectoryManager;
import jstels.database.io.FileManager;
import jstels.database.io.LocalFileManager;
import jstels.utils.FileUtils;
import jstels.utils.c;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FileCacheManager
extends FileManager {
    private FileManager case = null;
    private LocalFileManager byte = null;
    private boolean try = false;

    public FileCacheManager(FileManager fileManager, String string) throws Exception {
        this(fileManager, string, false);
    }

    public FileCacheManager(FileManager fileManager, String string, boolean bl) throws Exception {
        this.tempPath = string;
        this.case = fileManager;
        String string2 = c.a(string, fileManager.getName());
        this.byte = new LocalFileManager(string2);
        OutputStream outputStream = null;
        if (new File(fileManager.getName()).getParentFile() != null) {
            new File(string2).getParentFile().mkdirs();
        }
        if (bl) {
            this.byte.getFile().delete();
            this.byte.getFile().createNewFile();
            this.flush();
            return;
        }
        InputStream inputStream = this.case.getInputStream();
        outputStream = this.byte.getOutputStream(false);
        if (inputStream == null) {
            throw new Exception("File to be cached '" + this.case.getPath() + "' is not found");
        }
        FileUtils.copyStream(inputStream, outputStream);
    }

    public void delete() throws Exception {
        this.case.delete();
        this.byte.delete();
    }

    public boolean exists() throws Exception {
        return true;
    }

    public DirectoryManager getDir() {
        return this.byte.getDir();
    }

    public String getDirPath() {
        return this.byte.getDirPath();
    }

    public InputStream getInputStream() throws Exception {
        return this.byte.getInputStream();
    }

    public String getName() {
        return this.case.getName();
    }

    public OutputStream getOutputStream(boolean bl) throws Exception {
        if (this.case.exists() && this.case.isReadOnly()) {
            throw new Exception("File '" + this.case.getPath() + "' is read-only!");
        }
        return this.byte.getOutputStream(bl);
    }

    public LocalFileManager getLocalFileManager() {
        return this.byte;
    }

    public File getFile() {
        return this.byte.getFile();
    }

    public String getPath() {
        return this.byte.getPath();
    }

    public RandomAccessFile getRandomAccess(String string) throws Exception {
        if (this.case.exists() && this.case.isReadOnly()) {
            throw new Exception("File '" + this.case.getPath() + "' is read-only!");
        }
        return this.byte.getRandomAccess(string);
    }

    public boolean isReadOnly() {
        return this.case.isReadOnly();
    }

    public boolean isDirectory() {
        return this.case.isDirectory();
    }

    public void flush() throws Exception {
        InputStream inputStream = this.byte.getInputStream();
        OutputStream outputStream = this.case.getOutputStream(false);
        if (inputStream == null) {
            throw new Exception("File to be cached '" + this.case.getName() + "' is not found");
        }
        FileUtils.copyStream(inputStream, outputStream);
    }

    public void close() throws Exception {
        if (this.byte == null || this.case == null) {
            return;
        }
        this.byte.delete();
        this.byte.close();
        this.case.close();
        this.byte = null;
        this.case = null;
    }
}

