/*
 * Decompiled with CFR 0.152.
 */
package jstels.database.io;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Vector;
import jstels.database.io.ClasspathFileManager;
import jstels.database.io.DirectoryManager;
import jstels.database.io.FTPFileManager;
import jstels.database.io.FileCacheManager;
import jstels.database.io.FileManagerEvent;
import jstels.database.io.FileManagerListener;
import jstels.database.io.HTTPFileManager;
import jstels.database.io.LocalFileDirectoryManager;
import jstels.database.io.LocalFileManager;
import jstels.database.io.SMBFileManager;
import jstels.database.io.ZipFileManager;

public abstract class FileManager {
    static final int FILE = 0;
    static final int DIRECT_HTTP = 1;
    static final int DIRECT_FTP = 2;
    static final int HTTP = 3;
    static final int FTP = 4;
    static final int ZIP = 5;
    static final int SMB = 6;
    static final int CLASSPATH = 7;
    static final int CACHE = 8;
    static final int ABSOLUTE_FILE = 9;
    static final int RELATIVE = 10;
    protected String tempPath = null;
    protected DirectoryManager dir = null;
    Vector listeners = new Vector();

    public static FileManager buildFileManager(DirectoryManager directoryManager, String string) throws Exception {
        return FileManager.buildFileManager(directoryManager, string, null);
    }

    public static FileManager buildFileManager(DirectoryManager directoryManager, String string, String string2) throws Exception {
        int n2 = FileManager.checkPath(string);
        return FileManager.buildFileManager(directoryManager, string, string2, n2);
    }

    static FileManager buildFileManager(DirectoryManager directoryManager, String string, String string2, int n2) throws Exception {
        switch (n2) {
            case 3: {
                return new HTTPFileManager(string);
            }
            case 4: {
                return new FTPFileManager(string);
            }
            case 5: {
                return new ZipFileManager(string);
            }
            case 7: {
                return new ClasspathFileManager(string);
            }
            case 6: {
                return new SMBFileManager(string);
            }
            case 0: {
                return new LocalFileManager(string.substring("file://".length()));
            }
            case 8: {
                return new FileCacheManager(FileManager.buildFileManager(directoryManager, string.substring("cache://".length()), string2), string2);
            }
            case 9: {
                return new LocalFileManager(string);
            }
        }
        FileManager fileManager = null;
        fileManager = directoryManager == null ? new LocalFileDirectoryManager(".").getFileManager(string) : directoryManager.getFileManager(string);
        if (fileManager.isDirectory()) {
            throw new IllegalArgumentException("File '" + string + "' must not be a directory!");
        }
        return fileManager;
    }

    static int checkPath(String string) throws Exception {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("'path' argument may not be empty or null");
        }
        if (string.startsWith("http://")) {
            return 3;
        }
        if (string.startsWith("ftp://")) {
            return 4;
        }
        if (string.startsWith("zip://") || string.startsWith("jar://")) {
            return 5;
        }
        if (string.startsWith("classpath://")) {
            return 7;
        }
        if (string.startsWith("smb://")) {
            return 6;
        }
        if (string.startsWith("file://")) {
            return 0;
        }
        if (string.startsWith("cache://")) {
            return 8;
        }
        if (new File(string).isDirectory()) {
            throw new Exception("The file '" + string + "' must not be a directory");
        }
        if (new File(string).isAbsolute()) {
            return 9;
        }
        return 10;
    }

    public void addListener(FileManagerListener fileManagerListener) {
        this.listeners.add(fileManagerListener);
    }

    public void removeListener(FileManagerListener fileManagerListener) {
        this.listeners.remove(fileManagerListener);
    }

    public void fireEvent(int n2) {
        for (int i2 = 0; i2 < this.listeners.size(); ++i2) {
            FileManagerListener fileManagerListener = (FileManagerListener)this.listeners.get(i2);
            fileManagerListener.fileManagerEventHappened(new FileManagerEvent(this, n2));
        }
    }

    public void clearListeners() {
        this.listeners.clear();
    }

    public abstract InputStream getInputStream() throws Exception;

    public abstract OutputStream getOutputStream(boolean var1) throws Exception;

    public abstract RandomAccessFile getRandomAccess(String var1) throws Exception;

    public abstract String getPath();

    public abstract String getDirPath();

    public abstract DirectoryManager getDir();

    public File getFile() {
        return null;
    }

    public abstract String getName();

    public abstract boolean exists() throws Exception;

    public abstract boolean isReadOnly();

    public boolean isDirectory() {
        return false;
    }

    public void create() throws Exception {
    }

    public abstract void delete() throws Exception;

    public void flush() throws Exception {
    }

    public void close() throws Exception {
        this.dir = null;
    }

    public void setTempPath(String string) {
        this.tempPath = string;
    }

    public String getTempPath() {
        return this.tempPath;
    }
}

