/*
 * Decompiled with CFR 0.152.
 */
package jstels.database.io;

import java.io.File;
import jstels.database.io.DirectoryManager;
import jstels.database.io.FileManager;
import jstels.database.io.LocalFileManager;
import jstels.utils.b;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LocalFileDirectoryManager
extends DirectoryManager {
    private String byte;

    public LocalFileDirectoryManager(String string) {
        this(string, null);
    }

    public LocalFileDirectoryManager(String string, String string2) {
        this.tempPath = string2;
        if (string.trim().length() == 0) {
            throw new IllegalArgumentException("Empty path is incorrect");
        }
        File file = new File(string);
        if (!file.exists()) {
            throw new IllegalArgumentException("Specified path '" + string + "' is not found.");
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("Specified path '" + string + "' is not a directory.");
        }
        this.byte = new File(string).getPath();
        if (!this.byte.endsWith("\\") || this.byte.endsWith("/")) {
            this.byte = this.byte + File.separator;
        }
    }

    public FileManager getFileManager(String string) throws Exception {
        int n2 = FileManager.checkPath(string);
        if (n2 == 10) {
            LocalFileManager localFileManager = new LocalFileManager(this, string);
            localFileManager.setTempPath(this.tempPath);
            return localFileManager;
        }
        return FileManager.buildFileManager(this, string, this.tempPath, n2);
    }

    public void createFile(String string) throws Exception {
        new File(this.getPath() + string).createNewFile();
    }

    public void dropFile(String string) throws Exception {
        new File(this.getPath() + string).delete();
    }

    public FileManager[] listFiles(String string, String string2) {
        File[] fileArray = new File(this.byte).listFiles(new b(string, string2));
        FileManager[] fileManagerArray = new FileManager[fileArray.length];
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            fileManagerArray[i2] = new LocalFileManager(this, fileArray[i2].getName());
        }
        return fileManagerArray;
    }

    public String getPath() {
        return this.byte;
    }

    public boolean isReadOnly() {
        return false;
    }

    public boolean supportsAppending() {
        return true;
    }

    public boolean supportsRandomAccess() {
        return true;
    }

    public void flush() throws Exception {
    }

    public void close() {
    }
}

