/*
 * Decompiled with CFR 0.152.
 */
package jstels.database.io;

import java.io.InputStream;
import jcifs.smb.SmbFile;
import jstels.database.io.DirectoryManager;
import jstels.database.io.FileManager;
import jstels.database.io.SMBFileManager;
import jstels.database.io.SmbExtensionFileFilter;

public class SMBDirectoryManager
extends DirectoryManager {
    private String a;

    public SMBDirectoryManager(String string) throws Exception {
        if (string.trim().length() == 0) {
            throw new IllegalArgumentException("Empty path is incorrect");
        }
        this.a = !string.startsWith("smb://") ? "smb://" + string : string;
        SmbFile smbFile = new SmbFile(this.a);
        if (!smbFile.exists()) {
            throw new IllegalArgumentException("Specified path '" + string + "' is not found.");
        }
        if (!smbFile.isDirectory()) {
            throw new IllegalArgumentException("Specified path '" + string + "' is not a directory.");
        }
        if (this.a.trim().length() > 0 && !this.a.endsWith("/") && !this.a.endsWith("\\")) {
            this.a = this.a + "/";
        }
    }

    public FileManager getFileManager(String string) throws Exception {
        int n2 = FileManager.checkPath(string);
        if (n2 == 10) {
            SMBFileManager sMBFileManager = new SMBFileManager(this.getPath(), string);
            sMBFileManager.setTempPath(this.tempPath);
            return sMBFileManager;
        }
        return FileManager.buildFileManager(this, string, this.tempPath, n2);
    }

    public void createFile(String string) throws Exception {
        new SmbFile(this.getPath() + string).createNewFile();
    }

    public void dropFile(String string) throws Exception {
        new SmbFile(this.getPath() + string).delete();
    }

    public FileManager[] listFiles(String string, String string2) {
        SmbFile[] smbFileArray = null;
        try {
            smbFileArray = new SmbFile(this.a).listFiles(new SmbExtensionFileFilter(string, string2));
        }
        catch (Exception exception) {
            throw new UnknownError("Error in SMBDirectoryManager.listFiles() while getting a list of files for the URL '" + this.a + "'");
        }
        FileManager[] fileManagerArray = new FileManager[smbFileArray.length];
        for (int i2 = 0; i2 < smbFileArray.length; ++i2) {
            try {
                fileManagerArray[i2] = new SMBFileManager(this.getPath(), smbFileArray[i2].getName());
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return fileManagerArray;
    }

    public String getPath() {
        return this.a;
    }

    public boolean isReadOnly() {
        return false;
    }

    public boolean supportsAppending() {
        return true;
    }

    public boolean supportsRandomAccess() {
        return false;
    }

    public void flush() throws Exception {
    }

    public void close() {
    }

    public static void main(String[] stringArray) {
        try {
            int n2;
            SMBDirectoryManager sMBDirectoryManager = new SMBDirectoryManager("smb://serg10/temp");
            SMBFileManager sMBFileManager = (SMBFileManager)sMBDirectoryManager.getFileManager("test2.dbf");
            InputStream inputStream = sMBFileManager.getInputStream();
            byte[] byArray = new byte[8192];
            while ((n2 = inputStream.read(byArray)) > 0) {
                System.out.write(byArray, 0, n2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

