/*
 * Decompiled with CFR 0.152.
 */
package jstels.database.io;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFileInputStream;
import jcifs.smb.SmbFileOutputStream;
import jstels.database.io.DirectoryManager;
import jstels.database.io.FileManager;
import jstels.database.io.SMBDirectoryManager;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SMBFileManager
extends FileManager {
    private SmbFile if;
    private String a;
    private String do;

    public SMBFileManager(String string, String string2) throws Exception {
        this.a = string + string2;
        this.do = string2;
        this.if = new SmbFile(this.a);
    }

    public SMBFileManager(String string) throws Exception {
        this.a = string;
        if (!string.startsWith("smb://")) {
            this.a = "smb://" + string;
        }
        this.if = new SmbFile(this.a);
        this.do = this.if.getName();
    }

    public RandomAccessFile getRandomAccess(String string) throws Exception {
        return null;
    }

    public OutputStream getOutputStream(boolean bl) throws Exception {
        this.fireEvent(1);
        return new SmbFileOutputStream(this.if, bl);
    }

    public InputStream getInputStream() throws Exception {
        return new SmbFileInputStream(this.if);
    }

    public String getPath() {
        return this.a;
    }

    public String getDirPath() {
        return this.if.getParent() == null ? "." : this.if.getParent();
    }

    public DirectoryManager getDir() {
        try {
            return new SMBDirectoryManager(this.getDirPath());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public String getName() {
        return this.do;
    }

    public boolean exists() throws Exception {
        return this.if.exists();
    }

    public boolean isReadOnly() {
        try {
            return !this.if.canWrite();
        }
        catch (SmbException smbException) {
            throw new RuntimeException(smbException);
        }
    }

    public boolean isDirectory() {
        try {
            return this.if.isDirectory();
        }
        catch (SmbException smbException) {
            throw new RuntimeException(smbException);
        }
    }

    public void delete() throws Exception {
        this.if.delete();
    }

    public void close() {
        this.if = null;
    }
}

