/*
 * Decompiled with CFR 0.152.
 */
package jstels.database.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import jstels.database.io.DirectoryManager;
import jstels.database.io.FileManager;
import jstels.database.io.LocalFileManager;
import jstels.database.io.ZipFileManager;
import jstels.utils.FileUtils;
import jstels.utils.c;
import jstels.utils.d;

public class ZipDirectoryManager
extends DirectoryManager {
    String entryPath = null;
    String zipFilePath = null;
    ZipFile zf = null;
    ZipEntry zipEntry = null;
    String cacheFilePath = null;

    ZipDirectoryManager(String string) throws Exception {
        this(string, null);
    }

    ZipDirectoryManager(String string, String string2) throws Exception {
        int n2;
        this.tempPath = string2;
        String string3 = null;
        string3 = string.startsWith("zip://") || string.startsWith("jar://") ? string.substring("zip://".length()) : string;
        if (string3.startsWith("ftp://")) {
            string3 = this.cacheFilePath = this.a(string3, string2);
        }
        if ((n2 = string3.indexOf(".zip")) == -1 && (n2 = string3.indexOf(".jar")) == -1) {
            throw new Exception("Path '" + string + "' doesn't contain a zip file with the extension '.zip' or '.jar'");
        }
        this.zipFilePath = string3.substring(0, n2 + 4);
        this.entryPath = string3.substring(n2 + 4, string3.length()).trim();
        if (!new File(this.zipFilePath).exists()) {
            throw new Exception("Zip file '" + this.zipFilePath + "' not found");
        }
        this.zf = new ZipFile(this.zipFilePath);
        if (this.entryPath.trim().length() > 0) {
            if (!this.entryPath.endsWith("/")) {
                this.entryPath = this.entryPath + "/";
            }
            if (this.entryPath.startsWith("/")) {
                this.entryPath = this.entryPath.substring(1, this.entryPath.length());
            }
        }
        if (this.entryPath.length() != 0) {
            this.zipEntry = this.zf.getEntry(this.entryPath);
            if (this.zipEntry == null) {
                throw new Exception("Zip entry '" + this.entryPath + "' not found in the zip file '" + this.zipFilePath + "'");
            }
            if (!this.zipEntry.isDirectory()) {
                throw new Exception("Zip entry '" + this.entryPath + "' is a not directory in the zip file '" + this.zipFilePath + "'");
            }
        }
    }

    private String a(String string, String string2) throws Exception {
        FileManager fileManager = FileManager.buildFileManager(null, string);
        String string3 = c.a(string2, new File(string).getName());
        LocalFileManager localFileManager = new LocalFileManager(string3);
        InputStream inputStream = fileManager.getInputStream();
        OutputStream outputStream = ((FileManager)localFileManager).getOutputStream(false);
        if (inputStream == null) {
            throw new Exception("File '" + string + "' is not found");
        }
        FileUtils.copyStream(inputStream, outputStream);
        return string3;
    }

    public FileManager getFileManager(String string) throws Exception {
        int n2 = FileManager.checkPath(string);
        if (n2 == 10) {
            ZipFileManager zipFileManager = new ZipFileManager(this, this.zf, this.entryPath, string);
            zipFileManager.setTempPath(this.tempPath);
            return zipFileManager;
        }
        return FileManager.buildFileManager(this, string, this.tempPath, n2);
    }

    public void createFile(String string) throws Exception {
    }

    public void dropFile(String string) throws Exception {
    }

    public String getPath() {
        return "zip://" + this.zf.getName() + "/" + this.entryPath;
    }

    public boolean isReadOnly() {
        return true;
    }

    public boolean supportsAppending() {
        return false;
    }

    public boolean supportsRandomAccess() {
        return false;
    }

    public FileManager[] listFiles(String string, String string2) {
        FileManager[] fileManagerArray;
        Vector<FileManager[]> vector = new Vector<FileManager[]>();
        Enumeration<? extends ZipEntry> enumeration = this.zf.entries();
        while (enumeration.hasMoreElements()) {
            fileManagerArray = enumeration.nextElement();
            if (fileManagerArray.isDirectory()) continue;
            File file = new File(fileManagerArray.getName());
            File file2 = this.entryPath.equals("") ? null : new File(this.entryPath);
            File file3 = file.getParentFile();
            if ((file2 != null || file3 != null) && (file2 == null || file3 == null || !file2.equals(file3))) continue;
            String string3 = "." + d.do(file.getName());
            if (string != null && !string3.equalsIgnoreCase(string) || string2 != null && string2.trim().length() != 0 && !d.a(d.if(file.getName().toLowerCase()), string2.toLowerCase(), '%', '_')) continue;
            vector.add(fileManagerArray);
        }
        fileManagerArray = new FileManager[vector.size()];
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            fileManagerArray[i2] = new ZipFileManager(this, this.zf, (ZipEntry)vector.get(i2));
        }
        return fileManagerArray;
    }

    public void flush() throws Exception {
    }

    public void close() {
        this.entryPath = null;
        this.zipFilePath = null;
        this.zipEntry = null;
        try {
            if (this.zf != null) {
                this.zf.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.zf = null;
        if (this.cacheFilePath != null) {
            new File(this.cacheFilePath).delete();
        }
        this.cacheFilePath = null;
    }

    public static void main(String[] stringArray) throws Throwable {
        int n2;
        ZipDirectoryManager zipDirectoryManager = new ZipDirectoryManager("arch.zip");
        System.out.println("zipFilePath=" + zipDirectoryManager.zipFilePath);
        System.out.println("entryPath=" + zipDirectoryManager.entryPath);
        zipDirectoryManager = new ZipDirectoryManager("arch.zip/");
        System.out.println("zipFilePath=" + zipDirectoryManager.zipFilePath);
        System.out.println("entryPath=" + zipDirectoryManager.entryPath);
        zipDirectoryManager = new ZipDirectoryManager("arch.zip/a");
        System.out.println("zipFilePath=" + zipDirectoryManager.zipFilePath);
        System.out.println("entryPath=" + zipDirectoryManager.entryPath);
        zipDirectoryManager = new ZipDirectoryManager("arch.zip/a/");
        System.out.println("zipFilePath=" + zipDirectoryManager.zipFilePath);
        System.out.println("entryPath=" + zipDirectoryManager.entryPath);
        try {
            zipDirectoryManager = new ZipDirectoryManager("c:/temp/arch");
        }
        catch (Exception exception) {
            System.out.println("Error: " + exception.getMessage());
        }
        try {
            zipDirectoryManager = new ZipDirectoryManager("c:/temp/arch.zip");
        }
        catch (Exception exception) {
            System.out.println("Error: " + exception.getMessage());
        }
        try {
            zipDirectoryManager = new ZipDirectoryManager("arch.zip/none");
        }
        catch (Exception exception) {
            System.out.println("Error: " + exception.getMessage());
        }
        zipDirectoryManager = new ZipDirectoryManager("arch.zip");
        FileManager[] fileManagerArray = zipDirectoryManager.listFiles(null, null);
        System.out.println("Files in the dir " + zipDirectoryManager.getPath());
        for (n2 = 0; n2 < fileManagerArray.length; ++n2) {
            System.out.println(fileManagerArray[n2].getName());
        }
        zipDirectoryManager = new ZipDirectoryManager("arch.zip/a");
        fileManagerArray = zipDirectoryManager.listFiles(".txt", null);
        System.out.println("Files in the dir " + zipDirectoryManager.getPath());
        for (n2 = 0; n2 < fileManagerArray.length; ++n2) {
            System.out.println(fileManagerArray[n2].getName());
        }
        zipDirectoryManager = new ZipDirectoryManager("arch.zip/a/b");
        fileManagerArray = zipDirectoryManager.listFiles(null, "crea%");
        System.out.println("Files in the dir " + zipDirectoryManager.getPath());
        for (n2 = 0; n2 < fileManagerArray.length; ++n2) {
            System.out.println(fileManagerArray[n2].getName());
        }
    }
}

