/*
 * Decompiled with CFR 0.152.
 */
package jstels.database.io;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import jstels.database.io.DirectoryManager;
import jstels.database.io.FileManager;
import jstels.database.io.ZipDirectoryManager;

public class ZipFileManager
extends FileManager {
    ZipFile zf = null;
    ZipEntry zipEntry = null;

    ZipFileManager(String string) throws Exception {
        String string2 = null;
        string2 = string.startsWith("zip://") || string.startsWith("jar://") ? string.substring("zip://".length()) : string;
        int n2 = string2.indexOf(".zip");
        if (n2 == -1 && (n2 = string2.indexOf(".jar")) == -1) {
            throw new IllegalArgumentException("Path '" + string + "' doesn't contain a zip file with the extension '.zip' or '.jar'");
        }
        String string3 = string2.substring(0, n2 + 4);
        String string4 = string2.substring(n2 + 4, string2.length()).trim();
        if (!new File(string3).exists()) {
            throw new IllegalArgumentException("Zip file '" + string3 + "' not found");
        }
        if (string4.length() == 0) {
            throw new IllegalArgumentException("Path in zip file '" + string3 + "' must not be a null");
        }
        if (string4.length() > 0 && string4.startsWith("/")) {
            string4 = string4.substring(1, string4.length());
        }
        this.zf = new ZipFile(string3);
        this.a(string4);
        File file = new File(string);
        String string5 = string.substring(0, string.indexOf(file.getName()));
        this.dir = new ZipDirectoryManager(string5, this.tempPath);
    }

    private void a(String string) throws Exception {
        this.zipEntry = this.zf.getEntry(string);
        if (this.zipEntry == null) {
            File file = new File(string);
            String string2 = file.getName();
            String string3 = null;
            if (file.getParent() != null) {
                string3 = string.substring(0, string.indexOf(string2));
            }
            this.zipEntry = this.zf.getEntry(string3 == null ? file.getName().toUpperCase() : string3 + file.getName().toUpperCase());
            if (this.zipEntry == null) {
                this.zipEntry = this.zf.getEntry(string3 == null ? file.getName().toLowerCase() : string3 + file.getName().toLowerCase());
                if (this.zipEntry == null) {
                    throw new Exception("Zip entry '" + string + "' is not found in the zip file '" + this.zf.getName() + "'");
                }
            }
        }
        if (this.zipEntry.isDirectory()) {
            throw new Exception("Zip entry '" + string + "' can not be a directory in the zip file '" + this.zf.getName() + "'");
        }
    }

    ZipFileManager(ZipDirectoryManager zipDirectoryManager, ZipFile zipFile, ZipEntry zipEntry) {
        this.dir = zipDirectoryManager;
        this.zf = zipFile;
        this.zipEntry = zipEntry;
    }

    ZipFileManager(ZipDirectoryManager zipDirectoryManager, ZipFile zipFile, String string, String string2) throws Exception {
        this.dir = zipDirectoryManager;
        this.zf = zipFile;
        this.a(string + string2);
    }

    public RandomAccessFile getRandomAccess(String string) throws Exception {
        throw new UnsupportedOperationException("Method getRandomAccess() not yet implemented.");
    }

    public boolean exists() {
        return this.zipEntry != null;
    }

    public String getName() {
        return new File(this.zipEntry.getName()).getName();
    }

    public boolean isReadOnly() {
        return true;
    }

    public String getPath() {
        return "zip://" + this.zf.getName() + "/" + this.zipEntry.getName();
    }

    public String getDirPath() {
        return this.dir.getPath();
    }

    public DirectoryManager getDir() {
        return this.dir;
    }

    public OutputStream getOutputStream(boolean bl) throws Exception {
        throw new UnsupportedOperationException("Write operations for zip protocol are not supported!");
    }

    public InputStream getInputStream() throws Exception {
        return this.zf.getInputStream(this.zipEntry);
    }

    public void delete() throws Exception {
    }

    public static void main(String[] stringArray) {
        try {
            ZipFileManager zipFileManager = new ZipFileManager("zip://c:/java/test/files/archive.zip/Folder1/Folder2/FOOD.DBF");
            System.out.println("path = " + zipFileManager.getPath());
            System.out.println("dir path = " + zipFileManager.getDirPath());
            System.out.println("file name = " + zipFileManager.getName());
            zipFileManager = new ZipFileManager("zip://c:/java/test/files/archive.zip/FOOD.DBF");
            System.out.println("\npath = " + zipFileManager.getPath());
            System.out.println("dir path = " + zipFileManager.getDirPath());
            System.out.println("file name = " + zipFileManager.getName());
            ZipDirectoryManager zipDirectoryManager = new ZipDirectoryManager("zip://c:/java/test/files/archive.zip");
            zipFileManager = (ZipFileManager)zipDirectoryManager.getFileManager("food.dbf");
            System.out.println("\npath = " + zipFileManager.getPath());
            System.out.println("dir path = " + zipFileManager.getDirPath());
            System.out.println("file name = " + zipFileManager.getName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

