/*
 * Decompiled with CFR 0.152.
 */
package jstels.jdbc.dbf.h2;

import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import jstels.jdbc.common.h2.CommonDataSource2;
import jstels.jdbc.common.h2.CommonDriver2;
import jstels.jdbc.dbf.DBFDriver2;

public class DBFDataSource2
extends CommonDataSource2 {
    public DBFDataSource2() {
        super(new DBFDriver2());
    }

    public Connection getConnection() throws SQLException {
        if (this.getPath() == null) {
            throw new SQLException("You must set a path to DBF directory! Use setPath() method.");
        }
        this.driver.writeLog("Data Source " + this.getProperties() + ", java.sql.Driver=[" + this.driver.toString() + "] -> getConnection()");
        return this.driver.connect(this.driver.getURLPrefix() + this.getPath(), this.props);
    }

    public Reference getReference() throws NamingException {
        Reference reference = new Reference(this.getClass().getName(), "jstels.jdbc.dbf.h2.DBFObjectFactory2", null);
        reference.add(new StringRefAddr("path", this.getPath()));
        reference.add(new StringRefAddr("charset", this.getCharset()));
        reference.add(new StringRefAddr("emptyStringAsNull", String.valueOf(this.isEmptyStringIsNull())));
        reference.add(new StringRefAddr("extension", this.getFileExtension()));
        reference.add(new StringRefAddr("format", this.getFormat()));
        reference.add(new StringRefAddr("ignoreCase", String.valueOf(this.isIgnoreCase())));
        reference.add(new StringRefAddr("logPath", this.getLogPath()));
        reference.add(new StringRefAddr("useWebParam", this.getWebParameterName()));
        reference.add(new StringRefAddr("trimBlanks", String.valueOf(this.isTrimBlanks())));
        reference.add(new StringRefAddr("caching", String.valueOf(this.isCaching())));
        reference.add(new StringRefAddr("tempPath", this.getTempPath()));
        return reference;
    }

    public void setCharset(String string) {
        if (string != null) {
            this.props.setProperty("charset", string);
        }
    }

    public String getCharset() {
        String string = this.props.getProperty("charset");
        return string == null ? "8859_1" : string;
    }

    public void setEmptyStringIsNull(boolean bl) {
        this.props.setProperty("emptyStringAsNull", String.valueOf(bl));
    }

    public boolean isEmptyStringIsNull() {
        String string = this.props.getProperty("emptyStringAsNull");
        return string == null ? true : Boolean.valueOf(string);
    }

    public void setFormat(String string) {
        if (string != null) {
            this.props.setProperty("format", string);
        }
    }

    public String getFormat() {
        String string = this.props.getProperty("format");
        return string == null ? String.valueOf("DBASEIII") : string;
    }

    public void setFileExtension(String string) {
        if (string != null) {
            this.props.setProperty("extension", string);
        }
    }

    public String getFileExtension() {
        String string = this.props.getProperty("extension");
        return string == null ? ".dbf" : string;
    }

    public void setLogPath(String string) {
        if (string != null) {
            this.props.setProperty("logPath", string);
        }
    }

    public String getLogPath() {
        String string = this.props.getProperty("logPath");
        return string == null ? null : string;
    }

    public void setTrimBlanks(boolean bl) {
        this.props.setProperty("trimBlanks", String.valueOf(bl));
    }

    public boolean isTrimBlanks() {
        String string = this.props.getProperty("trimBlanks");
        return string == null ? true : Boolean.valueOf(string);
    }

    public void setWebParameterName(String string) {
        if (string != null) {
            this.props.setProperty("useWebParam", string);
        }
    }

    public String getWebParameterName() {
        String string = this.props.getProperty("useWebParam");
        return string == null ? CommonDriver2.a : string;
    }
}

