/*
 * Decompiled with CFR 0.152.
 */
package jstels.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

public class TestUtils {
    public static void printTableOut(Statement statement, String string, PrintStream printStream) throws SQLException {
        ResultSet resultSet = statement.executeQuery("SELECT * FROM " + string);
        TestUtils.printColumnsOut(resultSet, printStream);
        TestUtils.printResultSetOut(resultSet, printStream);
        resultSet.close();
    }

    public static void printDetailedColumnsOut(ResultSet resultSet, PrintStream printStream) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        for (int i2 = 1; i2 <= resultSetMetaData.getColumnCount(); ++i2) {
            printStream.print(resultSetMetaData.getColumnName(i2));
            switch (resultSetMetaData.getColumnType(i2)) {
                case 12: {
                    printStream.print("[Str(" + resultSetMetaData.getPrecision(i2) + "," + resultSetMetaData.getScale(i2) + ")]");
                    break;
                }
                case 4: {
                    printStream.print("[Int(" + resultSetMetaData.getPrecision(i2) + "," + resultSetMetaData.getScale(i2) + ")]");
                    break;
                }
                case 6: 
                case 7: {
                    printStream.print("[Flt(" + resultSetMetaData.getPrecision(i2) + "," + resultSetMetaData.getScale(i2) + ")]");
                    break;
                }
                case -5: {
                    printStream.print("[Long(" + resultSetMetaData.getPrecision(i2) + "," + resultSetMetaData.getScale(i2) + ")]");
                    break;
                }
                case 8: {
                    printStream.print("[Double(" + resultSetMetaData.getPrecision(i2) + "," + resultSetMetaData.getScale(i2) + ")]");
                    break;
                }
                case 2: 
                case 3: {
                    printStream.print("[BigDecimal(" + resultSetMetaData.getPrecision(i2) + "," + resultSetMetaData.getScale(i2) + ")]");
                    break;
                }
                case 93: {
                    printStream.print("[Dat]");
                    break;
                }
                case 16: {
                    printStream.print("[Bool]");
                    break;
                }
                case -1: {
                    printStream.print("[Longstr(" + resultSetMetaData.getPrecision(i2) + "," + resultSetMetaData.getScale(i2) + ")]");
                    break;
                }
                case 2000: {
                    printStream.print("[Object(" + resultSetMetaData.getPrecision(i2) + "," + resultSetMetaData.getScale(i2) + ")]");
                    break;
                }
                default: {
                    printStream.print("[Unk]");
                }
            }
            printStream.print("\t");
        }
        printStream.println("\n------------------------------");
    }

    public static void printColumnsOut(ResultSet resultSet, PrintStream printStream) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        for (int i2 = 1; i2 <= resultSetMetaData.getColumnCount(); ++i2) {
            printStream.print(resultSetMetaData.getColumnName(i2));
            switch (resultSetMetaData.getColumnType(i2)) {
                case 12: {
                    printStream.print("[Str]");
                    break;
                }
                case 4: 
                case 5: {
                    printStream.print("[Int]");
                    break;
                }
                case 6: 
                case 7: {
                    printStream.print("[Flt]");
                    break;
                }
                case -5: {
                    printStream.print("[Long]");
                    break;
                }
                case 8: {
                    printStream.print("[Double]");
                    break;
                }
                case 2: 
                case 3: {
                    printStream.print("[BigDecimal]");
                    break;
                }
                case 93: {
                    printStream.print("[Dat]");
                    break;
                }
                case 16: {
                    printStream.print("[Bool]");
                    break;
                }
                case -1: {
                    printStream.print("[Longstr]");
                    break;
                }
                case 2000: {
                    printStream.print("[Object]");
                    break;
                }
                default: {
                    printStream.print("[Unk]");
                }
            }
            printStream.print("\t");
        }
        printStream.println("\n------------------------------");
    }

    public static void printResultSetOut(ResultSet resultSet, PrintStream printStream) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        while (resultSet.next()) {
            block13: for (int i2 = 1; i2 <= resultSetMetaData.getColumnCount(); ++i2) {
                switch (resultSetMetaData.getColumnType(i2)) {
                    case 12: {
                        printStream.print(resultSet.getString(i2) + "\t");
                        continue block13;
                    }
                    case 4: 
                    case 5: {
                        printStream.print(resultSet.getInt(i2) + "\t");
                        continue block13;
                    }
                    case 6: 
                    case 7: {
                        printStream.print(resultSet.getFloat(i2) + "\t");
                        continue block13;
                    }
                    case -5: {
                        printStream.print(resultSet.getLong(i2) + "\t");
                        continue block13;
                    }
                    case 8: {
                        printStream.print(resultSet.getDouble(i2) + "\t");
                        continue block13;
                    }
                    case 2: 
                    case 3: {
                        printStream.print(resultSet.getBigDecimal(i2) + "\t");
                        continue block13;
                    }
                    case 93: {
                        printStream.print(resultSet.getTimestamp(i2) + "\t");
                        continue block13;
                    }
                    case 16: {
                        printStream.print(resultSet.getBoolean(i2) + "\t");
                        continue block13;
                    }
                    case -1: {
                        printStream.print(resultSet.getObject(i2) + "\t");
                        continue block13;
                    }
                    case 2000: {
                        Object object = resultSet.getObject(i2);
                        String string = "NULL";
                        if (object != null) {
                            string = "" + object.getClass();
                        }
                        printStream.print("obj=" + string + "\t");
                        continue block13;
                    }
                    default: {
                        printStream.print(resultSet.getString(i2) + "\t");
                    }
                }
            }
            printStream.println("");
        }
    }

    public static long calculateFolderSize(String string) {
        File file = new File(string);
        File[] fileArray = file.listFiles();
        long l2 = 0L;
        long l3 = 0L;
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            if (fileArray[i2].getName().equalsIgnoreCase("log.txt") || fileArray[i2].getName().equalsIgnoreCase("logDataSource.txt")) {
                l2 = fileArray[i2].length();
                continue;
            }
            l3 += fileArray[i2].length();
        }
        return l3;
    }

    public static void copyStream(InputStream inputStream, File file) throws IOException {
        TestUtils.copyStream(inputStream, new FileOutputStream(file), 8192);
    }

    public static void copyStream(InputStream inputStream, PrintStream printStream) throws IOException {
        TestUtils.copyStream(inputStream, printStream, 8192);
    }

    public static void copyStream(InputStream inputStream, OutputStream outputStream, int n2) throws IOException {
        int n3;
        byte[] byArray = new byte[n2];
        while ((n3 = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n3);
        }
        inputStream.close();
        outputStream.flush();
        outputStream.close();
    }
}

