/*
 * Decompiled with CFR 0.152.
 */
package org.h2.bnf;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.h2.bnf.BnfVisitor;
import org.h2.bnf.Rule;
import org.h2.bnf.RuleElement;
import org.h2.bnf.RuleFixed;
import org.h2.bnf.RuleHead;
import org.h2.bnf.RuleList;
import org.h2.bnf.RuleOptional;
import org.h2.bnf.RuleRepeat;
import org.h2.bnf.Sentence;
import org.h2.server.web.DbContextRule;
import org.h2.tools.Csv;
import org.h2.util.New;
import org.h2.util.StringUtils;
import org.h2.util.Utils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Bnf {
    private final HashMap a = New.hashMap();
    private String if;
    private String do;
    private String[] try;
    private char case;
    private int int;
    private Rule byte;
    private ArrayList new;
    private String for;

    public static Bnf getInstance(Reader reader) throws SQLException, IOException {
        Bnf bnf = new Bnf();
        if (reader == null) {
            byte[] byArray = Utils.getResource("/org/h2/res/help.csv");
            reader = new InputStreamReader(new ByteArrayInputStream(byArray));
        }
        bnf.a(reader);
        return bnf;
    }

    private void a(String string, int n2) {
        RuleFixed ruleFixed = new RuleFixed(n2);
        this.a(string, "Fixed", ruleFixed);
    }

    private RuleHead a(String string, String string2, Rule rule) {
        RuleHead ruleHead = new RuleHead(string2, string, rule);
        String string3 = StringUtils.toLowerEnglish(string.trim().replace(' ', '_'));
        if (this.a.get(string3) != null) {
            throw new AssertionError((Object)("already exists: " + string));
        }
        this.a.put(string3, ruleHead);
        return ruleHead;
    }

    private void a(Reader reader) throws SQLException, IOException {
        Rule rule = null;
        this.new = New.arrayList();
        ResultSet resultSet = Csv.getInstance().read(reader, null);
        int n2 = 0;
        while (resultSet.next()) {
            String string = resultSet.getString("SECTION").trim();
            if (!string.startsWith("System")) {
                String string2 = resultSet.getString("TOPIC");
                this.if = resultSet.getString("SYNTAX").trim();
                this.for = string;
                this.try = this.new();
                this.int = 0;
                Rule rule2 = this.do();
                if (string.startsWith("Command")) {
                    rule2 = new RuleList(rule2, new RuleElement(";\n\n", this.for), false);
                }
                RuleHead ruleHead = this.a(string2, string, rule2);
                if (string.startsWith("Function")) {
                    rule = rule == null ? rule2 : new RuleList(rule2, rule, true);
                } else if (string.startsWith("Commands")) {
                    this.new.add(ruleHead);
                }
            }
            ++n2;
        }
        this.a("@func@", "Function", rule);
        this.a("@ymd@", 0);
        this.a("@hms@", 1);
        this.a("@nanos@", 2);
        this.a("anything_except_single_quote", 3);
        this.a("anything_except_double_quote", 4);
        this.a("anything_until_end_of_line", 5);
        this.a("anything_until_end_comment", 6);
        this.a("anything_except_two_dollar_signs", 8);
        this.a("anything", 7);
        this.a("@hex_start@", 10);
        this.a("@concat@", 11);
        this.a("@az_@", 12);
        this.a("@af@", 13);
        this.a("@digit@", 14);
        this.a("@open_bracket@", 15);
        this.a("@close_bracket@", 16);
    }

    public void visit(BnfVisitor bnfVisitor, String string) {
        this.if = string;
        this.try = this.new();
        this.int = 0;
        Rule rule = this.do();
        rule.setLinks(this.a);
        rule.accept(bnfVisitor);
    }

    public static String getRuleMapKey(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (char c2 : string.toCharArray()) {
            if (Character.isUpperCase(c2)) {
                stringBuilder.append('_').append(Character.toLowerCase(c2));
                continue;
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public RuleHead getRuleHead(String string) {
        return (RuleHead)this.a.get(string);
    }

    private Rule do() {
        this.for();
        return this.int();
    }

    private Rule int() {
        Rule rule = this.if();
        if (this.case == '|') {
            this.for();
            rule = new RuleList(rule, this.int(), true);
        }
        this.byte = rule;
        return rule;
    }

    private Rule if() {
        Rule rule = this.a();
        if (this.case != '|' && this.case != ']' && this.case != '}' && this.case != '\u0000') {
            rule = new RuleList(rule, this.if(), false);
        }
        this.byte = rule;
        return rule;
    }

    private Rule a() {
        Rule rule;
        if (this.case >= 'A' && this.case <= 'Z' || this.case >= 'a' && this.case <= 'z') {
            rule = new RuleElement(this.do, this.for);
        } else if (this.case == '[') {
            this.for();
            Rule rule2 = this.int();
            rule = new RuleOptional(rule2);
            if (this.case != ']') {
                throw new AssertionError((Object)("expected ], got " + this.do + " syntax:" + this.if));
            }
        } else if (this.case == '{') {
            this.for();
            rule = this.int();
            if (this.case != '}') {
                throw new AssertionError((Object)("expected }, got " + this.do + " syntax:" + this.if));
            }
        } else if ("@commaDots@".equals(this.do)) {
            rule = new RuleList(new RuleElement(",", this.for), this.byte, false);
            rule = new RuleRepeat(rule, true);
        } else {
            rule = "@dots@".equals(this.do) ? new RuleRepeat(this.byte, false) : new RuleElement(this.do, this.for);
        }
        this.byte = rule;
        this.for();
        return rule;
    }

    private void for() {
        if (this.int < this.try.length) {
            this.do = this.try[this.int++];
            this.case = this.do.charAt(0);
        } else {
            this.do = "";
            this.case = '\u0000';
        }
    }

    private String[] new() {
        ArrayList arrayList = New.arrayList();
        this.if = StringUtils.replaceAll(this.if, "yyyy-MM-dd", "@ymd@");
        this.if = StringUtils.replaceAll(this.if, "hh:mm:ss", "@hms@");
        this.if = StringUtils.replaceAll(this.if, "nnnnnnnnn", "@nanos@");
        this.if = StringUtils.replaceAll(this.if, "function", "@func@");
        this.if = StringUtils.replaceAll(this.if, "0x", "@hexStart@");
        this.if = StringUtils.replaceAll(this.if, ",...", "@commaDots@");
        this.if = StringUtils.replaceAll(this.if, "...", "@dots@");
        this.if = StringUtils.replaceAll(this.if, "||", "@concat@");
        this.if = StringUtils.replaceAll(this.if, "a-z|_", "@az_@");
        this.if = StringUtils.replaceAll(this.if, "A-Z|_", "@az_@");
        this.if = StringUtils.replaceAll(this.if, "a-f", "@af@");
        this.if = StringUtils.replaceAll(this.if, "A-F", "@af@");
        this.if = StringUtils.replaceAll(this.if, "0-9", "@digit@");
        this.if = StringUtils.replaceAll(this.if, "'['", "@openBracket@");
        this.if = StringUtils.replaceAll(this.if, "']'", "@closeBracket@");
        StringTokenizer stringTokenizer = this.getTokenizer(this.if);
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if ((string = StringUtils.cache(string)).length() == 1 && " \r\n".indexOf(string.charAt(0)) >= 0) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public HashMap getNextTokenList(String string) {
        Sentence sentence = new Sentence();
        sentence.setQuery(string);
        for (RuleHead ruleHead : this.new) {
            if (!ruleHead.getSection().startsWith("Commands")) continue;
            sentence.start();
            ruleHead.getRule().addNextTokenList(sentence);
        }
        return sentence.getNext();
    }

    public void linkStatements() {
        for (RuleHead ruleHead : this.a.values()) {
            ruleHead.getRule().setLinks(this.a);
        }
    }

    public void updateTopic(String string, DbContextRule dbContextRule) {
        RuleHead ruleHead = (RuleHead)this.a.get(string = StringUtils.toLowerEnglish(string));
        if (ruleHead == null) {
            ruleHead = new RuleHead("db", string, dbContextRule);
            this.a.put(string, ruleHead);
            this.new.add(ruleHead);
        } else {
            ruleHead.setRule(dbContextRule);
        }
    }

    public ArrayList getStatements() {
        return this.new;
    }

    public StringTokenizer getTokenizer(String string) {
        return new StringTokenizer(string, " [](){}|.,\r\n<>:-+*/=<\">!'$", true);
    }
}

