/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command;

import java.util.ArrayList;
import org.h2.command.Command;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.Parameter;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;
import org.h2.util.StatementBuilder;
import org.h2.value.Value;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class Prepared {
    protected Session session;
    protected String sqlStatement;
    protected boolean create = true;
    protected ArrayList parameters;
    protected boolean prepareAlways;
    private long int;
    private Command for;
    private int try;
    private int byte;
    private int new;

    public Prepared(Session session) {
        this.session = session;
        this.int = session.getDatabase().getModificationMetaId();
    }

    public abstract boolean isTransactional();

    public abstract ResultInterface queryMeta();

    public abstract int getType();

    public boolean isReadOnly() {
        return false;
    }

    public boolean needRecompile() {
        Database database = this.session.getDatabase();
        if (database == null) {
            throw DbException.get(90067, "database closed");
        }
        return this.prepareAlways || this.int < database.getModificationMetaId() || database.getSettings().recompileAlways;
    }

    long getModificationMetaId() {
        return this.int;
    }

    void setModificationMetaId(long l2) {
        this.int = l2;
    }

    public void setParameterList(ArrayList arrayList) {
        this.parameters = arrayList;
    }

    public ArrayList getParameters() {
        return this.parameters;
    }

    protected void checkParameters() {
        if (this.parameters != null) {
            int n2 = this.parameters.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Parameter parameter = (Parameter)this.parameters.get(i2);
                parameter.checkSet();
            }
        }
    }

    public void setCommand(Command command) {
        this.for = command;
    }

    public boolean isQuery() {
        return false;
    }

    public void prepare() {
    }

    public int update() {
        throw DbException.get(90001);
    }

    public ResultInterface query(int n2) {
        throw DbException.get(90002);
    }

    public void setSQL(String string) {
        this.sqlStatement = string;
    }

    public String getSQL() {
        return this.sqlStatement;
    }

    protected int getCurrentObjectId() {
        return this.try;
    }

    protected int getObjectId() {
        int n2 = this.try;
        if (n2 == 0) {
            n2 = this.session.getDatabase().allocateObjectId();
        } else {
            this.try = 0;
        }
        return n2;
    }

    public String getPlanSQL() {
        return null;
    }

    public void checkCanceled() {
        Command command;
        this.session.checkCanceled();
        Command command2 = command = this.for != null ? this.for : this.session.getCurrentCommand();
        if (command != null) {
            command.checkCanceled();
        }
    }

    public void setObjectId(int n2) {
        this.try = n2;
        this.create = false;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    void trace(long l2, int n2) {
        if (this.session.getTrace().isInfoEnabled()) {
            String string;
            long l3 = System.currentTimeMillis() - l2;
            if (this.parameters.size() > 0) {
                StatementBuilder statementBuilder = new StatementBuilder(" {");
                int n3 = 0;
                for (Parameter parameter : this.parameters) {
                    statementBuilder.appendExceptFirst(", ");
                    Value value = ((Expression)parameter).getValue(this.session);
                    statementBuilder.append(++n3).append(": ").append(value.getTraceSQL());
                }
                string = statementBuilder.append('}').toString();
            } else {
                string = "";
            }
            this.session.getTrace().infoSQL(this.sqlStatement, string, n2, l3);
        }
    }

    public void setPrepareAlways(boolean bl) {
        this.prepareAlways = bl;
    }

    protected void setCurrentRowNumber(int n2) {
        if ((++this.new & 0x7F) == 0) {
            this.checkCanceled();
        }
        this.byte = n2;
    }

    public int getCurrentRowNumber() {
        return this.byte;
    }

    public String toString() {
        return this.sqlStatement;
    }

    protected String getSQL(Value[] valueArray) {
        StatementBuilder statementBuilder = new StatementBuilder();
        for (Value value : valueArray) {
            statementBuilder.appendExceptFirst(", ");
            if (value == null) continue;
            statementBuilder.append(value.getSQL());
        }
        return statementBuilder.toString();
    }

    protected String getSQL(Expression[] expressionArray) {
        StatementBuilder statementBuilder = new StatementBuilder();
        for (Expression expression : expressionArray) {
            statementBuilder.appendExceptFirst(", ");
            if (expression == null) continue;
            statementBuilder.append(expression.getSQL());
        }
        return statementBuilder.toString();
    }

    protected DbException setRow(DbException dbException, int n2, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.sqlStatement != null) {
            stringBuilder.append(this.sqlStatement);
        }
        stringBuilder.append(" -- ");
        if (n2 > 0) {
            stringBuilder.append("row #").append(n2 + 1).append(' ');
        }
        stringBuilder.append('(').append(string).append(')');
        return dbException.addSQL(stringBuilder.toString());
    }

    public boolean isCacheable() {
        return false;
    }
}

