/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.util.ArrayList;
import java.util.HashSet;
import org.h2.command.ddl.SchemaCommand;
import org.h2.constraint.Constraint;
import org.h2.constraint.ConstraintCheck;
import org.h2.constraint.ConstraintReferential;
import org.h2.constraint.ConstraintUnique;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.New;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AlterTableAddConstraint
extends SchemaCommand {
    private int ca;
    private String b5;
    private String cd;
    private IndexColumn[] b4;
    private int b9;
    private int cc;
    private Schema b1;
    private String b6;
    private IndexColumn[] cb;
    private Expression b0;
    private Index b8;
    private Index cf;
    private String b7;
    private boolean b3;
    private boolean ce;
    private boolean b2;

    public AlterTableAddConstraint(Session session, Schema schema, boolean bl) {
        super(session, schema);
        this.b2 = bl;
    }

    private String a(Table table) {
        if (this.b5 == null) {
            this.b5 = this.getSchema().getUniqueConstraintName(this.session, table);
        }
        return this.b5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update() {
        try {
            int n2 = this.tryUpdate();
            return n2;
        }
        finally {
            this.getSchema().freeUniqueName(this.b5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int tryUpdate() {
        Constraint constraint;
        if (!this.transactional) {
            this.session.commit(true);
        }
        Database database = this.session.getDatabase();
        Table table = this.getSchema().getTableOrView(this.session, this.cd);
        if (this.getSchema().findConstraint(this.session, this.b5) != null) {
            if (this.b2) {
                return 0;
            }
            throw DbException.get(90045, this.b5);
        }
        this.session.getUser().checkRight(table, 15);
        table.lock(this.session, true, true);
        switch (this.ca) {
            case 6: {
                int n2;
                IndexColumn.mapColumns(this.b4, table);
                this.b8 = table.findPrimaryKey();
                ArrayList arrayList = table.getConstraints();
                for (n2 = 0; arrayList != null && n2 < arrayList.size(); ++n2) {
                    Constraint constraint2 = (Constraint)arrayList.get(n2);
                    if (!"PRIMARY KEY".equals(constraint2.getConstraintType())) continue;
                    throw DbException.get(90017);
                }
                if (this.b8 != null) {
                    IndexColumn[] indexColumnArray = this.b8.getIndexColumns();
                    if (indexColumnArray.length != this.b4.length) {
                        throw DbException.get(90017);
                    }
                    for (int i2 = 0; i2 < indexColumnArray.length; ++i2) {
                        if (indexColumnArray[i2].column == this.b4[i2].column) continue;
                        throw DbException.get(90017);
                    }
                }
                if (this.b8 == null) {
                    IndexType indexType = IndexType.createPrimaryKey(table.isPersistIndexes(), this.ce);
                    String string = table.getSchema().getUniqueIndexName(this.session, table, "PRIMARY_KEY_");
                    int n3 = this.getObjectId();
                    try {
                        this.b8 = table.addIndex(this.session, string, n3, this.b4, indexType, true, null);
                    }
                    finally {
                        this.getSchema().freeUniqueName(string);
                    }
                }
                this.b8.getIndexType().setBelongsToConstraint(true);
                n2 = this.getObjectId();
                String string = this.a(table);
                ConstraintUnique constraintUnique = new ConstraintUnique(this.getSchema(), n2, string, table, true);
                constraintUnique.setColumns(this.b4);
                constraintUnique.setIndex(this.b8, true);
                constraint = constraintUnique;
                break;
            }
            case 4: {
                IndexColumn.mapColumns(this.b4, table);
                boolean bl = false;
                if (this.b8 != null && this.if(this.b8, table, this.b4)) {
                    bl = true;
                    this.b8.getIndexType().setBelongsToConstraint(true);
                } else {
                    this.b8 = this.a(table, this.b4);
                    if (this.b8 == null) {
                        this.b8 = this.a(table, this.b4, true);
                        bl = true;
                    }
                }
                int n4 = this.getObjectId();
                String string = this.a(table);
                ConstraintUnique constraintUnique = new ConstraintUnique(this.getSchema(), n4, string, table, false);
                constraintUnique.setColumns(this.b4);
                constraintUnique.setIndex(this.b8, bl);
                constraint = constraintUnique;
                break;
            }
            case 3: {
                int n5 = this.getObjectId();
                String string = this.a(table);
                ConstraintCheck constraintCheck = new ConstraintCheck(this.getSchema(), n5, string, table);
                TableFilter tableFilter = new TableFilter(this.session, table, null, false, null);
                this.b0.mapColumns(tableFilter, 0);
                this.b0 = this.b0.optimize(this.session);
                constraintCheck.setExpression(this.b0);
                constraintCheck.setTableFilter(tableFilter);
                constraint = constraintCheck;
                if (!this.b3) break;
                constraintCheck.checkExistingData(this.session);
                break;
            }
            case 5: {
                Table table2 = this.b1.getTableOrView(this.session, this.b6);
                this.session.getUser().checkRight(table2, 15);
                if (!table2.canReference()) {
                    throw DbException.get(50100, "Reference " + table2.getSQL());
                }
                boolean bl = false;
                IndexColumn.mapColumns(this.b4, table);
                if (this.b8 != null && this.a(this.b8, table, this.b4)) {
                    bl = true;
                    this.b8.getIndexType().setBelongsToConstraint(true);
                } else {
                    this.b8 = this.if(table, this.b4);
                    if (this.b8 == null) {
                        this.b8 = this.a(table, this.b4, false);
                        bl = true;
                    }
                }
                if (this.cb == null) {
                    Index index = table2.getPrimaryKey();
                    this.cb = index.getIndexColumns();
                } else {
                    IndexColumn.mapColumns(this.cb, table2);
                }
                if (this.cb.length != this.b4.length) {
                    throw DbException.get(21002);
                }
                boolean bl2 = false;
                if (this.cf != null && this.cf.getTable() == table2) {
                    bl2 = true;
                    this.cf.getIndexType().setBelongsToConstraint(true);
                } else {
                    this.cf = null;
                }
                if (this.cf == null) {
                    this.cf = this.a(table2, this.cb);
                    if (this.cf == null) {
                        this.cf = this.a(table2, this.cb, true);
                        bl2 = true;
                    }
                }
                int n6 = this.getObjectId();
                String string = this.a(table);
                ConstraintReferential constraintReferential = new ConstraintReferential(this.getSchema(), n6, string, table);
                constraintReferential.setColumns(this.b4);
                constraintReferential.setIndex(this.b8, bl);
                constraintReferential.setRefTable(table2);
                constraintReferential.setRefColumns(this.cb);
                constraintReferential.setRefIndex(this.cf, bl2);
                if (this.b3) {
                    constraintReferential.checkExistingData(this.session);
                }
                constraint = constraintReferential;
                table2.addConstraint(constraint);
                constraintReferential.setDeleteAction(this.b9);
                constraintReferential.setUpdateAction(this.cc);
                break;
            }
            default: {
                throw DbException.throwInternalError("type=" + this.ca);
            }
        }
        constraint.setComment(this.b7);
        if (table.isTemporary() && !table.isGlobalTemporary()) {
            this.session.addLocalTempTableConstraint(constraint);
        } else {
            database.addSchemaObject(this.session, constraint);
        }
        table.addConstraint(constraint);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Index a(Table table, IndexColumn[] indexColumnArray, boolean bl) {
        int n2 = this.getObjectId();
        IndexType indexType = bl ? IndexType.createUnique(table.isPersistIndexes(), false) : IndexType.createNonUnique(table.isPersistIndexes());
        indexType.setBelongsToConstraint(true);
        String string = this.b5 == null ? "CONSTRAINT" : this.b5;
        String string2 = table.getSchema().getUniqueIndexName(this.session, table, string + "_INDEX_");
        try {
            Index index = table.addIndex(this.session, string2, n2, indexColumnArray, indexType, true, null);
            return index;
        }
        finally {
            this.getSchema().freeUniqueName(string2);
        }
    }

    public void setDeleteAction(int n2) {
        this.b9 = n2;
    }

    public void setUpdateAction(int n2) {
        this.cc = n2;
    }

    private Index a(Table table, IndexColumn[] indexColumnArray) {
        for (Index index : table.getIndexes()) {
            if (!this.if(index, table, indexColumnArray)) continue;
            return index;
        }
        return null;
    }

    private Index if(Table table, IndexColumn[] indexColumnArray) {
        for (Index index : table.getIndexes()) {
            if (!this.a(index, table, indexColumnArray)) continue;
            return index;
        }
        return null;
    }

    private boolean if(Index index, Table table, IndexColumn[] indexColumnArray) {
        if (index.getTable() != table || !index.getIndexType().isUnique()) {
            return false;
        }
        Column[] columnArray = index.getColumns();
        if (columnArray.length > indexColumnArray.length) {
            return false;
        }
        HashSet hashSet = New.hashSet();
        for (IndexColumn object : indexColumnArray) {
            hashSet.add(object.column);
        }
        for (Column column : columnArray) {
            if (hashSet.contains(column)) continue;
            return false;
        }
        return true;
    }

    private boolean a(Index index, Table table, IndexColumn[] indexColumnArray) {
        if (index.getTable() != table || index.getCreateSQL() == null) {
            return false;
        }
        Column[] columnArray = index.getColumns();
        if (columnArray.length < indexColumnArray.length) {
            return false;
        }
        for (IndexColumn indexColumn : indexColumnArray) {
            int n2 = index.getColumnIndex(indexColumn.column);
            if (n2 >= 0 && n2 < indexColumnArray.length) continue;
            return false;
        }
        return true;
    }

    public void setConstraintName(String string) {
        this.b5 = string;
    }

    public void setType(int n2) {
        this.ca = n2;
    }

    public int getType() {
        return this.ca;
    }

    public void setCheckExpression(Expression expression) {
        this.b0 = expression;
    }

    public void setTableName(String string) {
        this.cd = string;
    }

    public void setIndexColumns(IndexColumn[] indexColumnArray) {
        this.b4 = indexColumnArray;
    }

    public IndexColumn[] getIndexColumns() {
        return this.b4;
    }

    public void setRefTableName(Schema schema, String string) {
        this.b1 = schema;
        this.b6 = string;
    }

    public void setRefIndexColumns(IndexColumn[] indexColumnArray) {
        this.cb = indexColumnArray;
    }

    public void setIndex(Index index) {
        this.b8 = index;
    }

    public void setRefIndex(Index index) {
        this.cf = index;
    }

    public void setComment(String string) {
        this.b7 = string;
    }

    public void setCheckExisting(boolean bl) {
        this.b3 = bl;
    }

    public void setPrimaryKeyHash(boolean bl) {
        this.ce = bl;
    }
}

