/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.util.ArrayList;
import java.util.List;
import org.h2.command.Parser;
import org.h2.command.Prepared;
import org.h2.command.ddl.CreateTableData;
import org.h2.command.ddl.SchemaCommand;
import org.h2.constraint.Constraint;
import org.h2.constraint.ConstraintReferential;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.schema.Sequence;
import org.h2.schema.TriggerObject;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.table.TableView;
import org.h2.util.New;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AlterTableAlterColumn
extends SchemaCommand {
    private Table bg;
    private Column bd;
    private Column bf;
    private int be;
    private Expression bi;
    private Expression bc;
    private String bh;

    public AlterTableAlterColumn(Session session, Schema schema) {
        super(session, schema);
    }

    public void setTable(Table table) {
        this.bg = table;
    }

    public void setOldColumn(Column column) {
        this.bd = column;
    }

    public void setAddBefore(String string) {
        this.bh = string;
    }

    public int update() {
        this.session.commit(true);
        Database database = this.session.getDatabase();
        this.session.getUser().checkRight(this.bg, 15);
        this.bg.checkSupportAlter();
        this.bg.lock(this.session, true, true);
        Sequence sequence = this.bd == null ? null : this.bd.getSequence();
        switch (this.be) {
            case 8: {
                if (!this.bd.isNullable()) break;
                this.e();
                this.bd.setNullable(false);
                database.update(this.session, this.bg);
                break;
            }
            case 9: {
                if (this.bd.isNullable()) break;
                this.c();
                this.bd.setNullable(true);
                database.update(this.session, this.bg);
                break;
            }
            case 10: {
                this.bd.setSequence(null);
                this.bd.setDefaultExpression(this.session, this.bi);
                this.a(sequence);
                database.update(this.session, this.bg);
                break;
            }
            case 11: {
                this.bd.setSequence(null);
                this.bd.setDefaultExpression(this.session, null);
                this.bd.setConvertNullToDefault(false);
                if (this.bd.isNullable() && !this.bf.isNullable()) {
                    this.e();
                } else if (!this.bd.isNullable() && this.bf.isNullable()) {
                    this.c();
                }
                this.a(this.bf);
                this.b();
                break;
            }
            case 7: {
                this.a(this.bf);
                this.b();
                break;
            }
            case 12: {
                if (this.bg.getColumns().length == 1) {
                    throw DbException.get(90084, this.bd.getSQL());
                }
                this.bg.checkColumnIsNotReferenced(this.bd);
                this.d();
                this.b();
                break;
            }
            case 13: {
                int n2 = this.bc.optimize(this.session).getValue(this.session).getInt();
                this.bd.setSelectivity(n2);
                database.update(this.session, this.bg);
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.be);
            }
        }
        return 0;
    }

    private void a(Column column) {
        if (column.isAutoIncrement()) {
            if (column.isPrimaryKey()) {
                column.setOriginalSQL("IDENTITY");
            } else {
                int n2 = this.getObjectId();
                column.convertAutoIncrementToSequence(this.session, this.getSchema(), n2, this.bg.isTemporary());
            }
        }
    }

    private void a(Sequence sequence) {
        if (sequence != null) {
            this.bg.removeSequence(this.session, sequence);
            sequence.setBelongsToTable(false);
            Database database = this.session.getDatabase();
            database.removeSchemaObject(this.session, sequence);
        }
    }

    private void b() {
        List list;
        if (this.bg.isTemporary()) {
            throw DbException.getUnsupportedException("TEMP TABLE");
        }
        Database database = this.session.getDatabase();
        String string = database.getTempTableName(this.session);
        Column[] columnArray = this.bg.getColumns();
        ArrayList arrayList = New.arrayList();
        Table table = this.a(columnArray, database, string, arrayList);
        try {
            list = this.a(this.bg, table);
        }
        catch (DbException dbException) {
            this.if("DROP TABLE " + table.getName(), true);
            throw DbException.get(90109, dbException, this.getSQL(), dbException.getMessage());
        }
        String string2 = this.bg.getName();
        this.if("DROP TABLE " + this.bg.getSQL() + " CASCADE", true);
        database.renameSchemaObject(this.session, table, string2);
        for (Object object : table.getChildren()) {
            String string3;
            if (object instanceof Sequence || (string3 = object.getName()) == null || object.getCreateSQL() == null || !string3.startsWith(string + "_")) continue;
            string3 = string3.substring(string.length() + 1);
            SchemaObject schemaObject = (SchemaObject)object;
            if (schemaObject instanceof Constraint) {
                if (schemaObject.getSchema().findConstraint(this.session, string3) != null) {
                    string3 = schemaObject.getSchema().getUniqueConstraintName(this.session, table);
                }
            } else if (schemaObject instanceof Index && schemaObject.getSchema().findIndex(this.session, string3) != null) {
                string3 = schemaObject.getSchema().getUniqueIndexName(this.session, table, string3);
            }
            database.renameSchemaObject(this.session, schemaObject, string3);
        }
        for (Object object : list) {
            this.if((String)object, true);
        }
    }

    private Table a(Column[] columnArray, Database database, String string, ArrayList arrayList) {
        Object object;
        Object object2;
        Object object32;
        for (Column object42 : columnArray) {
            arrayList.add(object42.getClone());
        }
        if (this.be == 12) {
            int n2 = this.bd.getColumnId();
            arrayList.remove(n2);
        } else if (this.be == 7) {
            int n3 = this.bh == null ? columnArray.length : this.bg.getColumn(this.bh).getColumnId();
            arrayList.add(n3, this.bf);
        } else if (this.be == 11) {
            int n4 = this.bd.getColumnId();
            arrayList.remove(n4);
            arrayList.add(n4, this.bf);
        }
        int n5 = database.allocateObjectId();
        CreateTableData createTableData = new CreateTableData();
        createTableData.tableName = string;
        createTableData.id = n5;
        createTableData.columns = arrayList;
        createTableData.temporary = this.bg.isTemporary();
        createTableData.persistData = this.bg.isPersistData();
        createTableData.persistIndexes = this.bg.isPersistIndexes();
        createTableData.create = true;
        createTableData.session = this.session;
        Table table = this.getSchema().createTable(createTableData);
        table.setComment(this.bg.getComment());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(table.getCreateSQL());
        StringBuilder stringBuilder2 = new StringBuilder();
        for (Object object32 : arrayList) {
            if (stringBuilder2.length() > 0) {
                stringBuilder2.append(", ");
            }
            if (this.be == 7 && object32 == this.bf) {
                object2 = ((Column)object32).getDefaultExpression();
                stringBuilder2.append(object2 == null ? "NULL" : ((Expression)object2).getSQL());
                continue;
            }
            stringBuilder2.append(((Column)object32).getSQL());
        }
        stringBuilder.append(" AS SELECT ");
        if (stringBuilder2.length() == 0) {
            stringBuilder.append('*');
        } else {
            stringBuilder.append((CharSequence)stringBuilder2);
        }
        stringBuilder.append(" FROM ").append(this.bg.getSQL());
        String string2 = stringBuilder.toString();
        object32 = table.getName();
        object2 = table.getSchema();
        table.removeChildrenAndResources(this.session);
        this.if(string2, true);
        table = ((Schema)object2).getTableOrView(this.session, (String)object32);
        ArrayList arrayList2 = New.arrayList();
        for (Object object4 : this.bg.getChildren()) {
            ConstraintReferential constraintReferential;
            if (object4 instanceof Sequence || object4 instanceof Index && (object = (Index)object4).getIndexType().getBelongsToConstraint() || (object = object4.getCreateSQL()) == null || object4 instanceof TableView) continue;
            if (object4.getType() == 0) {
                DbException.throwInternalError();
            }
            String string3 = Parser.quoteIdentifier(string + "_" + object4.getName());
            String string4 = null;
            if (object4 instanceof ConstraintReferential && (constraintReferential = (ConstraintReferential)object4).getTable() != this.bg) {
                string4 = constraintReferential.getCreateSQLForCopy(constraintReferential.getTable(), table, string3, false);
            }
            if (string4 == null) {
                string4 = object4.getCreateSQLForCopy(table, string3);
            }
            if (string4 == null) continue;
            if (object4 instanceof TriggerObject) {
                arrayList2.add(string4);
                continue;
            }
            this.if(string4, true);
        }
        this.bg.setModified();
        for (Object object4 : arrayList) {
            object = ((Column)object4).getSequence();
            if (object == null) continue;
            this.bg.removeSequence(this.session, (Sequence)object);
            ((Column)object4).setSequence(null);
        }
        for (Object object4 : arrayList2) {
            this.if((String)object4, true);
        }
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List a(SchemaObject schemaObject, SchemaObject schemaObject2) {
        ArrayList arrayList = new ArrayList();
        String string = schemaObject.getName();
        String string2 = schemaObject2.getName();
        Database database = schemaObject.getDatabase();
        database.renameSchemaObject(this.session, schemaObject, database.getTempTableName(this.session));
        try {
            database.renameSchemaObject(this.session, schemaObject2, string);
            this.a((DbObject)schemaObject, arrayList);
        }
        finally {
            try {
                database.renameSchemaObject(this.session, schemaObject2, string2);
            }
            finally {
                database.renameSchemaObject(this.session, schemaObject, string);
            }
        }
        return arrayList;
    }

    private void a(DbObject dbObject, List list) {
        for (DbObject dbObject2 : dbObject.getChildren()) {
            if (!(dbObject2 instanceof TableView)) continue;
            String string = ((TableView)dbObject2).getQuery();
            this.session.prepare(string);
            list.add(dbObject2.getDropSQL());
            list.add(dbObject2.getCreateSQL());
            this.a(dbObject2, list);
        }
    }

    private void if(String string, boolean bl) {
        Prepared prepared = this.session.prepare(string);
        prepared.update();
        if (bl) {
            this.session.commit(true);
        }
    }

    private void d() {
        Database database = this.session.getDatabase();
        ArrayList arrayList = this.bg.getIndexes();
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            Column[] columnArray;
            Index index = (Index)arrayList.get(i2);
            if (index.getCreateSQL() == null) continue;
            boolean bl = false;
            for (Column column : columnArray = index.getColumns()) {
                if (column != this.bd) continue;
                if (columnArray.length == 1) {
                    bl = true;
                    continue;
                }
                throw DbException.get(90075, index.getSQL());
            }
            if (!bl) continue;
            database.removeSchemaObject(this.session, index);
            arrayList = this.bg.getIndexes();
            i2 = -1;
        }
    }

    private void c() {
        for (Index index : this.bg.getIndexes()) {
            IndexType indexType;
            if (index.getColumnIndex(this.bd) < 0 || !(indexType = index.getIndexType()).isPrimaryKey() && !indexType.isHash()) continue;
            throw DbException.get(90075, index.getSQL());
        }
    }

    private void e() {
        String string = "SELECT COUNT(*) FROM " + this.bg.getSQL() + " WHERE " + this.bd.getSQL() + " IS NULL";
        Prepared prepared = this.session.prepare(string);
        ResultInterface resultInterface = prepared.query(0);
        resultInterface.next();
        if (resultInterface.currentRow()[0].getInt() > 0) {
            throw DbException.get(90081, this.bd.getSQL());
        }
    }

    public void setType(int n2) {
        this.be = n2;
    }

    public void setSelectivity(Expression expression) {
        this.bc = expression;
    }

    public void setDefaultExpression(Expression expression) {
        this.bi = expression;
    }

    public void setNewColumn(Column column) {
        this.bf = column;
    }

    public int getType() {
        return this.be;
    }
}

