/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.ddl.SchemaCommand;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.table.Table;

public class AlterTableRename
extends SchemaCommand {
    private Table ci;
    private String cj;

    public AlterTableRename(Session session, Schema schema) {
        super(session, schema);
    }

    public void setOldTable(Table table) {
        this.ci = table;
    }

    public void setNewTableName(String string) {
        this.cj = string;
    }

    public int update() {
        this.session.commit(true);
        Database database = this.session.getDatabase();
        if (this.getSchema().findTableOrView(this.session, this.cj) != null || this.cj.equals(this.ci.getName())) {
            throw DbException.get(42101, this.cj);
        }
        this.session.getUser().checkRight(this.ci, 15);
        if (this.ci.isTemporary()) {
            throw DbException.getUnsupportedException("TEMP TABLE");
        }
        database.renameSchemaObject(this.session, this.ci, this.cj);
        return 0;
    }

    public int getType() {
        return 15;
    }
}

