/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.ddl.DefineCommand;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.engine.User;
import org.h2.expression.Expression;
import org.h2.message.DbException;
import org.h2.security.SHA256;
import org.h2.util.StringUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AlterUser
extends DefineCommand {
    private int dE;
    private User dB;
    private String dA;
    private Expression dC;
    private Expression dD;
    private Expression dF;
    private boolean dz;

    public AlterUser(Session session) {
        super(session);
    }

    public void setType(int n2) {
        this.dE = n2;
    }

    public void setNewName(String string) {
        this.dA = string;
    }

    public void setUser(User user) {
        this.dB = user;
    }

    public void setAdmin(boolean bl) {
        this.dz = bl;
    }

    public void setSalt(Expression expression) {
        this.dD = expression;
    }

    public void setHash(Expression expression) {
        this.dF = expression;
    }

    public void setPassword(Expression expression) {
        this.dC = expression;
    }

    private char[] for(Expression expression) {
        return expression.optimize(this.session).getValue(this.session).getString().toCharArray();
    }

    private byte[] do(Expression expression) {
        return StringUtils.convertStringToBytes(expression.optimize(this.session).getValue(this.session).getString());
    }

    public int update() {
        this.session.commit(true);
        Database database = this.session.getDatabase();
        switch (this.dE) {
            case 19: {
                if (this.dB != this.session.getUser()) {
                    this.session.getUser().checkAdmin();
                }
                if (this.dF != null && this.dD != null) {
                    this.dB.setSaltAndHash(this.do(this.dD), this.do(this.dF));
                    break;
                }
                String string = this.dA == null ? this.dB.getName() : this.dA;
                SHA256 sHA256 = new SHA256();
                char[] cArray = this.for(this.dC);
                byte[] byArray = sHA256.getKeyPasswordHash(string, cArray);
                this.dB.setUserPasswordHash(byArray);
                break;
            }
            case 18: {
                this.session.getUser().checkAdmin();
                if (database.findUser(this.dA) != null || this.dA.equals(this.dB.getName())) {
                    throw DbException.get(90033, this.dA);
                }
                database.renameDatabaseObject(this.session, this.dB, this.dA);
                break;
            }
            case 17: {
                this.session.getUser().checkAdmin();
                if (!this.dz) {
                    this.dB.checkOwnsNoSchemas();
                }
                this.dB.setAdmin(this.dz);
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.dE);
            }
        }
        database.update(this.session, this.dB);
        return 0;
    }

    public int getType() {
        return this.dE;
    }
}

