/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.Prepared;
import org.h2.command.ddl.DefineCommand;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.result.ResultInterface;
import org.h2.table.Column;
import org.h2.table.RegularTable;
import org.h2.table.Table;
import org.h2.util.StatementBuilder;

public class Analyze
extends DefineCommand {
    private int dM;

    public Analyze(Session session) {
        super(session);
        this.dM = session.getDatabase().getSettings().analyzeSample;
    }

    public int update() {
        this.session.commit(true);
        this.session.getUser().checkAdmin();
        Database database = this.session.getDatabase();
        for (Table table : database.getAllTablesAndViews(false)) {
            Analyze.analyzeTable(this.session, table, this.dM, true);
        }
        return 0;
    }

    public static void analyzeTable(Session session, Table table, int n2, boolean bl) {
        Column[] columnArray;
        if (!(table instanceof RegularTable) || table.isHidden() || session == null) {
            return;
        }
        if (!bl) {
            if (session.getDatabase().isSysTableLocked()) {
                return;
            }
            if (table.hasSelectTrigger()) {
                return;
            }
        }
        if (table.isTemporary() && !table.isGlobalTemporary() && session.findLocalTempTable(table.getName()) == null) {
            return;
        }
        if (table.isLockedExclusively() && !table.isLockedExclusivelyBy(session)) {
            return;
        }
        if (!session.getUser().hasRight(table, 1)) {
            return;
        }
        if (session.getCancel() != 0L) {
            return;
        }
        Database database = session.getDatabase();
        StatementBuilder statementBuilder = new StatementBuilder("SELECT ");
        for (Column i2 : columnArray = table.getColumns()) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append("SELECTIVITY(").append(i2.getSQL()).append(')');
        }
        statementBuilder.append(" FROM ").append(table.getSQL());
        if (n2 > 0) {
            statementBuilder.append(" LIMIT 1 SAMPLE_SIZE ").append(n2);
        }
        String string = statementBuilder.toString();
        Prepared prepared = session.prepare(string);
        ResultInterface resultInterface = prepared.query(0);
        resultInterface.next();
        for (int session2 = 0; session2 < columnArray.length; ++session2) {
            int n3 = resultInterface.currentRow()[session2].getInt();
            columnArray[session2].setSelectivity(n3);
        }
        if (bl) {
            database.update(session, table);
        } else {
            Session session2 = database.getSystemSession();
            database.update(session2, table);
            session2.commit(true);
        }
    }

    public void setTop(int n2) {
        this.dM = n2;
    }

    public int getType() {
        return 21;
    }
}

