/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.ddl.SchemaCommand;
import org.h2.engine.Database;
import org.h2.engine.FunctionAlias;
import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.util.StringUtils;

public class CreateFunctionAlias
extends SchemaCommand {
    private String cP;
    private String cO;
    private boolean cS;
    private boolean cT;
    private boolean cR;
    private String cQ;

    public CreateFunctionAlias(Session session, Schema schema) {
        super(session, schema);
    }

    public int update() {
        this.session.commit(true);
        this.session.getUser().checkAdmin();
        Database database = this.session.getDatabase();
        if (this.getSchema().findFunction(this.cP) != null) {
            if (!this.cT) {
                throw DbException.get(90076, this.cP);
            }
        } else {
            int n2 = this.getObjectId();
            FunctionAlias functionAlias = this.cO != null ? FunctionAlias.newInstance(this.getSchema(), n2, this.cP, this.cO, this.cR) : FunctionAlias.newInstanceFromSource(this.getSchema(), n2, this.cP, this.cQ, this.cR);
            functionAlias.setDeterministic(this.cS);
            database.addSchemaObject(this.session, functionAlias);
        }
        return 0;
    }

    public void setAliasName(String string) {
        this.cP = string;
    }

    public void setJavaClassMethod(String string) {
        this.cO = StringUtils.replaceAll(string, " ", "");
    }

    public void setIfNotExists(boolean bl) {
        this.cT = bl;
    }

    public void setForce(boolean bl) {
        this.cR = bl;
    }

    public void setDeterministic(boolean bl) {
        this.cS = bl;
    }

    public void setSource(String string) {
        this.cQ = string;
    }

    public int getType() {
        return 24;
    }
}

