/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.ddl.SchemaCommand;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.table.IndexColumn;
import org.h2.table.Table;

public class CreateIndex
extends SchemaCommand {
    private String bF;
    private String bJ;
    private IndexColumn[] bH;
    private boolean bE;
    private boolean bI;
    private boolean bG;
    private boolean bL;
    private String bK;

    public CreateIndex(Session session, Schema schema) {
        super(session, schema);
    }

    public void setIfNotExists(boolean bl) {
        this.bL = bl;
    }

    public void setTableName(String string) {
        this.bF = string;
    }

    public void setIndexName(String string) {
        this.bJ = string;
    }

    public void setIndexColumns(IndexColumn[] indexColumnArray) {
        this.bH = indexColumnArray;
    }

    public int update() {
        IndexType indexType;
        this.session.commit(true);
        Database database = this.session.getDatabase();
        boolean bl = database.isPersistent();
        Table table = this.getSchema().getTableOrView(this.session, this.bF);
        this.session.getUser().checkRight(table, 15);
        table.lock(this.session, true, true);
        if (!table.isPersistIndexes()) {
            bl = false;
        }
        int n2 = this.getObjectId();
        if (this.bJ == null) {
            this.bJ = this.bE ? table.getSchema().getUniqueIndexName(this.session, table, "PRIMARY_KEY_") : table.getSchema().getUniqueIndexName(this.session, table, "INDEX_");
        }
        if (this.getSchema().findIndex(this.session, this.bJ) != null) {
            if (this.bL) {
                return 0;
            }
            throw DbException.get(42111, this.bJ);
        }
        if (this.bE) {
            if (table.findPrimaryKey() != null) {
                throw DbException.get(90017);
            }
            indexType = IndexType.createPrimaryKey(bl, this.bG);
        } else {
            indexType = this.bI ? IndexType.createUnique(bl, this.bG) : IndexType.createNonUnique(bl, this.bG);
        }
        IndexColumn.mapColumns(this.bH, table);
        table.addIndex(this.session, this.bJ, n2, this.bH, indexType, this.create, this.bK);
        return 0;
    }

    public void setPrimaryKey(boolean bl) {
        this.bE = bl;
    }

    public void setUnique(boolean bl) {
        this.bI = bl;
    }

    public void setHash(boolean bl) {
        this.bG = bl;
    }

    public void setComment(String string) {
        this.bK = string;
    }

    public int getType() {
        return 25;
    }
}

