/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.util.ArrayList;
import java.util.Iterator;
import org.h2.command.ddl.AlterTableAddConstraint;
import org.h2.command.ddl.CreateIndex;
import org.h2.command.ddl.CreateTableData;
import org.h2.command.ddl.DefineCommand;
import org.h2.command.ddl.SchemaCommand;
import org.h2.command.dml.Insert;
import org.h2.command.dml.Query;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.schema.Sequence;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.util.New;
import org.h2.value.DataType;

public class CreateTable
extends SchemaCommand {
    private CreateTableData bo = new CreateTableData();
    private ArrayList br = New.arrayList();
    private IndexColumn[] bj;
    private boolean bl;
    private boolean bn;
    private boolean bk;
    private Query bm;
    private String bp;
    private boolean bq;

    public CreateTable(Session session, Schema schema) {
        super(session, schema);
        this.bo.persistIndexes = true;
        this.bo.persistData = true;
    }

    public void setQuery(Query query) {
        this.bm = query;
    }

    public void setTemporary(boolean bl) {
        this.bo.temporary = bl;
    }

    public void setTableName(String string) {
        this.bo.tableName = string;
    }

    public void addColumn(Column column) {
        this.bo.columns.add(column);
    }

    public void addConstraintCommand(DefineCommand defineCommand) {
        if (defineCommand instanceof CreateIndex) {
            this.br.add(defineCommand);
        } else {
            AlterTableAddConstraint alterTableAddConstraint = (AlterTableAddConstraint)defineCommand;
            boolean bl = alterTableAddConstraint.getType() == 6 ? this.a(alterTableAddConstraint.getIndexColumns()) : false;
            if (!bl) {
                this.br.add(defineCommand);
            }
        }
    }

    public void setIfNotExists(boolean bl) {
        this.bl = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update() {
        block26: {
            Object object2;
            Database database;
            if (!this.transactional) {
                this.session.commit(true);
            }
            if (!(database = this.session.getDatabase()).isPersistent()) {
                this.bo.persistIndexes = false;
            }
            if (this.getSchema().findTableOrView(this.session, this.bo.tableName) != null) {
                if (this.bl) {
                    return 0;
                }
                throw DbException.get(42101, this.bo.tableName);
            }
            if (this.bm != null) {
                this.bm.prepare();
                if (this.bo.columns.size() == 0) {
                    this.f();
                } else if (this.bo.columns.size() != this.bm.getColumnCount()) {
                    throw DbException.get(21002);
                }
            }
            if (this.bj != null) {
                for (Object object2 : this.bo.columns) {
                    for (IndexColumn indexColumn : this.bj) {
                        if (!((Column)object2).getName().equals(indexColumn.columnName)) continue;
                        ((Column)object2).setNullable(false);
                    }
                }
            }
            this.bo.id = this.getObjectId();
            this.bo.create = this.create;
            this.bo.session = this.session;
            Table table = this.getSchema().createTable(this.bo);
            object2 = New.arrayList();
            for (Column column : this.bo.columns) {
                Sequence sequence;
                if (column.isAutoIncrement()) {
                    int n2 = this.getObjectId();
                    column.convertAutoIncrementToSequence(this.session, this.getSchema(), n2, this.bo.temporary);
                }
                if ((sequence = column.getSequence()) == null) continue;
                ((ArrayList)object2).add(sequence);
            }
            table.setComment(this.bp);
            if (this.bo.temporary && !this.bo.globalTemporary) {
                if (this.bn) {
                    table.setOnCommitDrop(true);
                }
                if (this.bk) {
                    table.setOnCommitTruncate(true);
                }
                this.session.addLocalTempTable(table);
            } else {
                database.addSchemaObject(this.session, table);
            }
            try {
                for (Column column : this.bo.columns) {
                    column.prepareExpression(this.session);
                }
                Iterator iterator = ((ArrayList)object2).iterator();
                while (iterator.hasNext()) {
                    Sequence sequence = (Sequence)iterator.next();
                    table.addSequence(sequence);
                }
                for (DefineCommand defineCommand : this.br) {
                    defineCommand.setTransactional(this.transactional);
                    defineCommand.update();
                }
                if (this.bm == null) break block26;
                boolean bl = this.session.isUndoLogEnabled();
                try {
                    this.session.setUndoLogEnabled(false);
                    Insert insert = null;
                    insert = new Insert(this.session);
                    insert.setSortedInsertMode(this.bq);
                    insert.setQuery(this.bm);
                    insert.setTable(table);
                    insert.setInsertFromSelect(true);
                    insert.prepare();
                    insert.update();
                }
                finally {
                    this.session.setUndoLogEnabled(bl);
                }
            }
            catch (DbException dbException) {
                database.checkPowerOff();
                database.removeSchemaObject(this.session, table);
                if (!this.transactional) {
                    this.session.commit(true);
                }
                throw dbException;
            }
        }
        return 0;
    }

    private void f() {
        int n2 = this.bm.getColumnCount();
        ArrayList arrayList = this.bm.getExpressions();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3;
            Expression expression = (Expression)arrayList.get(i2);
            int n4 = expression.getType();
            String string = expression.getAlias();
            long l2 = expression.getPrecision();
            int n5 = expression.getDisplaySize();
            DataType dataType = DataType.getDataType(n4);
            if (l2 > 0L && (dataType.defaultPrecision == 0L || dataType.defaultPrecision > l2 && dataType.defaultPrecision < 127L)) {
                l2 = dataType.defaultPrecision;
            }
            if ((n3 = expression.getScale()) > 0 && (dataType.defaultScale == 0 || dataType.defaultScale > n3)) {
                n3 = dataType.defaultScale;
            }
            Column column = new Column(string, n4, l2, n3, n5);
            this.addColumn(column);
        }
    }

    private boolean a(IndexColumn[] indexColumnArray) {
        if (this.bj != null) {
            int n2 = indexColumnArray.length;
            if (n2 != this.bj.length) {
                throw DbException.get(90017);
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                if (indexColumnArray[i2].columnName.equals(this.bj[i2].columnName)) continue;
                throw DbException.get(90017);
            }
            return true;
        }
        this.bj = indexColumnArray;
        return false;
    }

    public void setPersistIndexes(boolean bl) {
        this.bo.persistIndexes = bl;
    }

    public void setGlobalTemporary(boolean bl) {
        this.bo.globalTemporary = bl;
    }

    public void setOnCommitDrop() {
        this.bn = true;
    }

    public void setOnCommitTruncate() {
        this.bk = true;
    }

    public void setComment(String string) {
        this.bp = string;
    }

    public void setPersistData(boolean bl) {
        this.bo.persistData = bl;
        if (!bl) {
            this.bo.persistIndexes = false;
        }
    }

    public void setSortedInsertMode(boolean bl) {
        this.bq = bl;
    }

    public void setTableEngine(String string) {
        this.bo.tableEngine = string;
    }

    public void setHidden(boolean bl) {
        this.bo.isHidden = bl;
    }

    public int getType() {
        return 30;
    }
}

