/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.ddl.DefineCommand;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.engine.UserDataType;
import org.h2.message.DbException;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.value.DataType;

public class CreateUserDataType
extends DefineCommand {
    private String de;
    private Column df;
    private boolean dg;

    public CreateUserDataType(Session session) {
        super(session);
    }

    public void setTypeName(String string) {
        this.de = string;
    }

    public void setColumn(Column column) {
        this.df = column;
    }

    public void setIfNotExists(boolean bl) {
        this.dg = bl;
    }

    public int update() {
        this.session.getUser().checkAdmin();
        this.session.commit(true);
        Database database = this.session.getDatabase();
        this.session.getUser().checkAdmin();
        if (database.findUserDataType(this.de) != null) {
            if (this.dg) {
                return 0;
            }
            throw DbException.get(90119, this.de);
        }
        DataType dataType = DataType.getTypeByName(this.de);
        if (dataType != null) {
            if (!dataType.hidden) {
                throw DbException.get(90119, this.de);
            }
            Table table = this.session.getDatabase().getFirstUserTable();
            if (table != null) {
                throw DbException.get(90119, this.de + " (" + table.getSQL() + ")");
            }
        }
        int n2 = this.getObjectId();
        UserDataType userDataType = new UserDataType(database, n2, this.de);
        userDataType.setColumn(this.df);
        database.addDatabaseObject(this.session, userDataType);
        return 0;
    }

    public int getType() {
        return 33;
    }
}

