/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.util.ArrayList;
import java.util.List;
import org.h2.command.Prepared;
import org.h2.command.ddl.SchemaCommand;
import org.h2.command.dml.Query;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.message.TraceObject;
import org.h2.schema.Schema;
import org.h2.table.Table;
import org.h2.table.TableView;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CreateView
extends SchemaCommand {
    private Query cv;
    private String cw;
    private boolean cq;
    private String cx;
    private String[] cu;
    private String ct;
    private boolean cr;
    private boolean cs;
    private boolean cp;

    public CreateView(Session session, Schema schema) {
        super(session, schema);
    }

    public void setViewName(String string) {
        this.cw = string;
    }

    public void setRecursive(boolean bl) {
        this.cr = bl;
    }

    public void setSelect(Query query) {
        this.cv = query;
    }

    public void setIfNotExists(boolean bl) {
        this.cq = bl;
    }

    public void setSelectSQL(String string) {
        this.cx = string;
    }

    public void setColumnNames(String[] stringArray) {
        this.cu = stringArray;
    }

    public void setComment(String string) {
        this.ct = string;
    }

    public void setOrReplace(boolean bl) {
        this.cs = bl;
    }

    public void setForce(boolean bl) {
        this.cp = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update() {
        TableView tableView;
        Object object;
        String string;
        this.session.commit(true);
        Database database = this.session.getDatabase();
        Table table = this.getSchema().findTableOrView(this.session, this.cw);
        ArrayList arrayList = new ArrayList();
        if (table != null) {
            if (this.cq) {
                return 0;
            }
            if (this.cs && table.getTableType().equals("VIEW")) {
                database.renameSchemaObject(this.session, table, database.getTempTableName(this.session));
                this.if(table, arrayList);
            } else {
                throw DbException.get(90038, this.cw);
            }
        }
        int n2 = this.getObjectId();
        if (this.cv == null) {
            string = this.cx;
        } else {
            object = this.cv.getParameters();
            if (object != null && ((ArrayList)object).size() > 0) {
                throw DbException.get(50100, "parameters in views");
            }
            string = TraceObject.toString(this.cv.getPlanSQL(), this.cv.getParameters());
        }
        object = database.getSystemSession();
        try {
            Schema schema = this.session.getDatabase().getSchema(this.session.getCurrentSchemaName());
            ((Session)object).setCurrentSchema(schema);
            tableView = new TableView(this.getSchema(), n2, this.cw, string, null, this.cu, (Session)object, this.cr);
        }
        finally {
            ((Session)object).setCurrentSchema(database.getSchema("PUBLIC"));
        }
        tableView.setComment(this.ct);
        try {
            tableView.recompileQuery(this.session);
        }
        catch (DbException dbException) {
            // empty catch block
        }
        database.addSchemaObject(this.session, tableView);
        if (table != null) {
            this.a(database, table, arrayList, tableView);
        }
        return 0;
    }

    private void a(Database database, Table table, List list, TableView tableView) {
        String string = null;
        try {
            for (DependentView dependentView : list) {
                string = dependentView.viewName;
                if (this.cp) {
                    this.do(dependentView.createForceSql, true);
                    continue;
                }
                this.do(dependentView.createSql, true);
            }
            database.removeSchemaObject(this.session, table);
        }
        catch (DbException dbException) {
            database.removeSchemaObject(this.session, tableView);
            database.renameSchemaObject(this.session, table, this.cw);
            for (DependentView dependentView : list) {
                this.do(dependentView.createForceSql, true);
            }
            throw DbException.get(90107, dbException, table.getName(), string);
        }
    }

    private void if(DbObject dbObject, List list) {
        for (DbObject dbObject2 : dbObject.getChildren()) {
            if (!(dbObject2 instanceof TableView)) continue;
            list.add(new DependentView((TableView)dbObject2));
            this.if(dbObject2, list);
        }
    }

    private void do(String string, boolean bl) {
        Prepared prepared = this.session.prepare(string);
        prepared.update();
        if (bl) {
            this.session.commit(true);
        }
    }

    public int getType() {
        return 34;
    }

    private static class DependentView {
        String viewName;
        String createSql;
        String createForceSql;

        DependentView(TableView tableView) {
            this.viewName = tableView.getName();
            this.createSql = tableView.getCreateSQL(true, false);
            this.createForceSql = tableView.getCreateSQL(true, true);
        }
    }
}

