/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.util.ArrayList;
import org.h2.command.ddl.SchemaCommand;
import org.h2.constraint.Constraint;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.index.Index;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.table.Table;

public class DropIndex
extends SchemaCommand {
    private String bN;
    private boolean bM;

    public DropIndex(Session session, Schema schema) {
        super(session, schema);
    }

    public void setIfExists(boolean bl) {
        this.bM = bl;
    }

    public void setIndexName(String string) {
        this.bN = string;
    }

    public int update() {
        this.session.commit(true);
        Database database = this.session.getDatabase();
        Index index = this.getSchema().findIndex(this.session, this.bN);
        if (index == null) {
            if (!this.bM) {
                throw DbException.get(42112, this.bN);
            }
        } else {
            Table table = index.getTable();
            this.session.getUser().checkRight(index.getTable(), 15);
            Constraint constraint = null;
            ArrayList arrayList = table.getConstraints();
            for (int i2 = 0; arrayList != null && i2 < arrayList.size(); ++i2) {
                Constraint constraint2 = (Constraint)arrayList.get(i2);
                if (!constraint2.usesIndex(index)) continue;
                if ("PRIMARY KEY".equals(constraint2.getConstraintType())) {
                    constraint = constraint2;
                    continue;
                }
                throw DbException.get(90085, this.bN);
            }
            index.getTable().setModified();
            if (constraint != null) {
                database.removeSchemaObject(this.session, constraint);
            } else {
                database.removeSchemaObject(this.session, index);
            }
        }
        return 0;
    }

    public int getType() {
        return 40;
    }
}

