/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.ddl.DefineCommand;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.schema.Schema;

public class DropSchema
extends DefineCommand {
    private String dH;
    private boolean dG;

    public DropSchema(Session session) {
        super(session);
    }

    public void setSchemaName(String string) {
        this.dH = string;
    }

    public int update() {
        this.session.getUser().checkAdmin();
        this.session.commit(true);
        Database database = this.session.getDatabase();
        Schema schema = database.findSchema(this.dH);
        if (schema == null) {
            if (!this.dG) {
                throw DbException.get(90079, this.dH);
            }
        } else {
            if (!schema.canDrop()) {
                throw DbException.get(90090, this.dH);
            }
            database.removeDatabaseObject(this.session, schema);
        }
        return 0;
    }

    public void setIfExists(boolean bl) {
        this.dG = bl;
    }

    public int getType() {
        return 42;
    }
}

