/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.ddl.SchemaCommand;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.schema.Sequence;

public class DropSequence
extends SchemaCommand {
    private String ch;
    private boolean cg;

    public DropSequence(Session session, Schema schema) {
        super(session, schema);
    }

    public void setIfExists(boolean bl) {
        this.cg = bl;
    }

    public void setSequenceName(String string) {
        this.ch = string;
    }

    public int update() {
        this.session.getUser().checkAdmin();
        this.session.commit(true);
        Database database = this.session.getDatabase();
        Sequence sequence = this.getSchema().findSequence(this.ch);
        if (sequence == null) {
            if (!this.cg) {
                throw DbException.get(90036, this.ch);
            }
        } else {
            if (sequence.getBelongsToTable()) {
                throw DbException.get(90082, this.ch);
            }
            database.removeSchemaObject(this.session, sequence);
        }
        return 0;
    }

    public int getType() {
        return 43;
    }
}

