/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.ddl.SchemaCommand;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.schema.TriggerObject;
import org.h2.table.Table;

public class DropTrigger
extends SchemaCommand {
    private String cN;
    private boolean cM;

    public DropTrigger(Session session, Schema schema) {
        super(session, schema);
    }

    public void setIfExists(boolean bl) {
        this.cM = bl;
    }

    public void setTriggerName(String string) {
        this.cN = string;
    }

    public int update() {
        this.session.commit(true);
        Database database = this.session.getDatabase();
        TriggerObject triggerObject = this.getSchema().findTrigger(this.cN);
        if (triggerObject == null) {
            if (!this.cM) {
                throw DbException.get(90042, this.cN);
            }
        } else {
            Table table = triggerObject.getTable();
            this.session.getUser().checkRight(table, 15);
            database.removeSchemaObject(this.session, triggerObject);
        }
        return 0;
    }

    public int getType() {
        return 45;
    }
}

