/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.ddl.SchemaCommand;
import org.h2.engine.DbObject;
import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.table.Table;
import org.h2.table.TableView;

public class DropView
extends SchemaCommand {
    private String bz;
    private boolean bx;
    private int by;

    public DropView(Session session, Schema schema) {
        super(session, schema);
        this.by = session.getDatabase().getSettings().dropRestrict ? 0 : 1;
    }

    public void setIfExists(boolean bl) {
        this.bx = bl;
    }

    public void setDropAction(int n2) {
        this.by = n2;
    }

    public void setViewName(String string) {
        this.bz = string;
    }

    public int update() {
        this.session.commit(true);
        Table table = this.getSchema().findTableOrView(this.session, this.bz);
        if (table == null) {
            if (!this.bx) {
                throw DbException.get(90037, this.bz);
            }
        } else {
            if (!"VIEW".equals(table.getTableType())) {
                throw DbException.get(90037, this.bz);
            }
            this.session.getUser().checkRight(table, 15);
            if (this.by == 0) {
                for (DbObject dbObject : table.getChildren()) {
                    if (!(dbObject instanceof TableView)) continue;
                    throw DbException.get(90107, this.bz, dbObject.getName());
                }
            }
            table.lock(this.session, true, true);
            this.session.getDatabase().removeSchemaObject(this.session, table);
        }
        return 0;
    }

    public int getType() {
        return 48;
    }
}

