/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.util.ArrayList;
import org.h2.command.Command;
import org.h2.command.Prepared;
import org.h2.command.dml.Query;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.Parameter;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;
import org.h2.result.Row;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.util.New;
import org.h2.util.StatementBuilder;
import org.h2.value.Value;
import org.h2.value.ValueLong;

public class Merge
extends Prepared {
    private Table ad;
    private Column[] ab;
    private Column[] ac;
    private ArrayList af = New.arrayList();
    private Query ae;
    private Prepared ag;

    public Merge(Session session) {
        super(session);
    }

    public void setCommand(Command command) {
        super.setCommand(command);
        if (this.ae != null) {
            this.ae.setCommand(command);
        }
    }

    public void setTable(Table table) {
        this.ad = table;
    }

    public void setColumns(Column[] columnArray) {
        this.ab = columnArray;
    }

    public void setKeys(Column[] columnArray) {
        this.ac = columnArray;
    }

    public void setQuery(Query query) {
        this.ae = query;
    }

    public void addRow(Expression[] expressionArray) {
        this.af.add(expressionArray);
    }

    public int update() {
        int n2;
        this.session.getUser().checkRight(this.ad, 4);
        this.session.getUser().checkRight(this.ad, 8);
        this.setCurrentRowNumber(0);
        this.session.setLastIdentity(ValueLong.get(0L));
        if (this.af.size() > 0) {
            n2 = 0;
            int n3 = this.af.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                this.setCurrentRowNumber(i2 + 1);
                Expression[] expressionArray = (Expression[])this.af.get(i2);
                Row row = this.ad.getTemplateRow();
                int n4 = this.ab.length;
                for (int i3 = 0; i3 < n4; ++i3) {
                    Column column = this.ab[i3];
                    int n5 = column.getColumnId();
                    Expression expression = expressionArray[i3];
                    if (expression == null) continue;
                    try {
                        Value value = column.convert(expression.getValue(this.session));
                        row.setValue(n5, value);
                        continue;
                    }
                    catch (DbException dbException) {
                        throw this.setRow(dbException, n2, this.getSQL(expressionArray));
                    }
                }
                this.a(row);
                ++n2;
            }
        } else {
            ResultInterface resultInterface = this.ae.query(0);
            n2 = 0;
            this.ad.fire(this.session, 3, true);
            this.ad.lock(this.session, true, false);
            while (resultInterface.next()) {
                Value[] valueArray = resultInterface.currentRow();
                Row row = this.ad.getTemplateRow();
                this.setCurrentRowNumber(++n2);
                for (int i4 = 0; i4 < this.ab.length; ++i4) {
                    Column column = this.ab[i4];
                    int n6 = column.getColumnId();
                    try {
                        Value value = column.convert(valueArray[i4]);
                        row.setValue(n6, value);
                        continue;
                    }
                    catch (DbException dbException) {
                        throw this.setRow(dbException, n2, this.getSQL(valueArray));
                    }
                }
                this.a(row);
            }
            resultInterface.close();
            this.ad.fire(this.session, 3, false);
        }
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void a(Row row) {
        Parameter parameter;
        Value value;
        Column column;
        int n2;
        ArrayList arrayList = this.ag.getParameters();
        for (n2 = 0; n2 < this.ab.length; ++n2) {
            column = this.ab[n2];
            value = row.getValue(column.getColumnId());
            parameter = (Parameter)arrayList.get(n2);
            parameter.setValue(value);
        }
        for (n2 = 0; n2 < this.ac.length; ++n2) {
            column = this.ac[n2];
            value = row.getValue(column.getColumnId());
            if (value == null) {
                throw DbException.get(90081, column.getSQL());
            }
            parameter = (Parameter)arrayList.get(this.ab.length + n2);
            parameter.setValue(value);
        }
        n2 = this.ag.update();
        if (n2 == 0) {
            try {
                this.ad.validateConvertUpdateSequence(this.session, row);
                boolean bl = this.ad.fireBeforeRow(this.session, null, row);
                if (bl) return;
                this.ad.lock(this.session, true, false);
                this.ad.addRow(this.session, row);
                this.session.log(this.ad, (short)0, row);
                this.ad.fireAfterRow(this.session, null, row, false);
                return;
            }
            catch (DbException dbException) {
                if (dbException.getErrorCode() != 23001) throw dbException;
                throw DbException.get(90131, this.ad.getName());
            }
        } else {
            if (n2 == 1) return;
            throw DbException.get(23001, this.ad.getSQL());
        }
    }

    public String getPlanSQL() {
        StatementBuilder statementBuilder = new StatementBuilder("MERGE INTO ");
        statementBuilder.append(this.ad.getSQL()).append('(');
        for (Column expressionArray : this.ab) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(expressionArray.getSQL());
        }
        statementBuilder.append(')');
        if (this.ac != null) {
            statementBuilder.append(" KEY(");
            statementBuilder.resetCount();
            for (Column column : this.ac) {
                statementBuilder.appendExceptFirst(", ");
                statementBuilder.append(column.getSQL());
            }
            statementBuilder.append(')');
        }
        statementBuilder.append('\n');
        if (this.af.size() > 0) {
            statementBuilder.append("VALUES ");
            int n2 = 0;
            for (Expression[] expressionArray : this.af) {
                if (n2++ > 0) {
                    statementBuilder.append(", ");
                }
                statementBuilder.append('(');
                statementBuilder.resetCount();
                for (Expression expression : expressionArray) {
                    statementBuilder.appendExceptFirst(", ");
                    if (expression == null) {
                        statementBuilder.append("DEFAULT");
                        continue;
                    }
                    statementBuilder.append(expression.getSQL());
                }
                statementBuilder.append(')');
            }
        } else {
            statementBuilder.append(this.ae.getPlanSQL());
        }
        return statementBuilder.toString();
    }

    public void prepare() {
        Object object;
        if (this.ab == null) {
            this.ab = this.af.size() > 0 && ((Expression[])this.af.get(0)).length == 0 ? new Column[0] : this.ad.getColumns();
        }
        if (this.af.size() > 0) {
            for (Expression[] object22 : this.af) {
                if (object22.length != this.ab.length) {
                    throw DbException.get(21002);
                }
                for (int i2 = 0; i2 < object22.length; ++i2) {
                    Expression expression = object22[i2];
                    if (expression == null) continue;
                    object22[i2] = expression.optimize(this.session);
                }
            }
        } else {
            this.ae.prepare();
            if (this.ae.getColumnCount() != this.ab.length) {
                throw DbException.get(21002);
            }
        }
        if (this.ac == null) {
            object = this.ad.getPrimaryKey();
            if (object == null) {
                throw DbException.get(90057, "PRIMARY KEY");
            }
            this.ac = object.getColumns();
        }
        object = new StatementBuilder("UPDATE ");
        ((StatementBuilder)object).append(this.ad.getSQL()).append(" SET ");
        for (Column column : this.ab) {
            ((StatementBuilder)object).appendExceptFirst(", ");
            ((StatementBuilder)object).append(column.getSQL()).append("=?");
        }
        ((StatementBuilder)object).append(" WHERE ");
        ((StatementBuilder)object).resetCount();
        for (Column column : this.ac) {
            ((StatementBuilder)object).appendExceptFirst(" AND ");
            ((StatementBuilder)object).append(column.getSQL()).append("=?");
        }
        String string = ((StatementBuilder)object).toString();
        this.ag = this.session.prepare(string);
    }

    public boolean isTransactional() {
        return true;
    }

    public ResultInterface queryMeta() {
        return null;
    }

    public int getType() {
        return 62;
    }
}

