/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import org.h2.command.Prepared;
import org.h2.constant.SysProperties;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.message.DbException;
import org.h2.security.SHA256;
import org.h2.store.DataHandler;
import org.h2.store.FileStore;
import org.h2.store.FileStoreInputStream;
import org.h2.store.FileStoreOutputStream;
import org.h2.store.LobStorage;
import org.h2.tools.CompressTool;
import org.h2.util.IOUtils;
import org.h2.util.SmallLRUCache;
import org.h2.util.TempFileDeleter;

public abstract class ScriptBase
extends Prepared
implements DataHandler {
    private static final String d2 = "script.sql";
    protected OutputStream out;
    protected InputStream in;
    private Expression dY;
    private String dX;
    private String dZ;
    private byte[] d1;
    private FileStore d0;
    private String dW;

    public ScriptBase(Session session) {
        super(session);
    }

    public void setCipher(String string) {
        this.dZ = string;
    }

    private boolean m() {
        return this.dZ != null;
    }

    public void setPassword(char[] cArray) {
        SHA256 sHA256 = new SHA256();
        this.d1 = sHA256.getKeyPasswordHash("script", cArray);
    }

    public void setFileNameExpr(Expression expression) {
        this.dY = expression;
    }

    protected String getFileName() {
        if (this.dY != null && this.dX == null) {
            this.dX = this.dY.optimize(this.session).getValue(this.session).getString();
            if (this.dX == null || this.dX.trim().length() == 0) {
                this.dX = d2;
            }
            this.dX = SysProperties.getScriptDirectory() + this.dX;
        }
        return this.dX;
    }

    public boolean isTransactional() {
        return false;
    }

    void deleteStore() {
        String string = this.getFileName();
        if (string != null) {
            IOUtils.delete(string);
        }
    }

    private void l() {
        Database database = this.session.getDatabase();
        String string = this.getFileName();
        this.d0 = FileStore.open(database, string, "rw", this.dZ, this.d1);
        this.d0.setCheckedWriting(false);
        this.d0.init();
    }

    void openOutput() {
        String string = this.getFileName();
        if (string == null) {
            return;
        }
        if (this.m()) {
            this.l();
            this.out = new FileStoreOutputStream(this.d0, this, this.dW);
            this.out = new BufferedOutputStream(this.out, 131072);
        } else {
            OutputStream outputStream = IOUtils.openFileOutputStream(string, false);
            this.out = new BufferedOutputStream(outputStream, 4096);
            this.out = CompressTool.wrapOutputStream(this.out, this.dW, d2);
        }
    }

    void openInput() {
        String string = this.getFileName();
        if (string == null) {
            return;
        }
        if (this.m()) {
            this.l();
            this.in = new FileStoreInputStream(this.d0, this, this.dW != null, false);
        } else {
            InputStream inputStream;
            try {
                inputStream = IOUtils.openFileInputStream(string);
            }
            catch (IOException iOException) {
                throw DbException.convertIOException(iOException, string);
            }
            this.in = new BufferedInputStream(inputStream, 4096);
            this.in = CompressTool.wrapInputStream(this.in, this.dW, d2);
            if (this.in == null) {
                throw DbException.get(90124, "script.sql in " + string);
            }
        }
    }

    void closeIO() {
        IOUtils.closeSilently(this.out);
        this.out = null;
        IOUtils.closeSilently(this.in);
        this.in = null;
        if (this.d0 != null) {
            this.d0.closeSilently();
            this.d0 = null;
        }
    }

    public boolean needRecompile() {
        return false;
    }

    public String getDatabasePath() {
        return null;
    }

    public FileStore openFile(String string, String string2, boolean bl) {
        return null;
    }

    public void checkPowerOff() {
        this.session.getDatabase().checkPowerOff();
    }

    public void checkWritingAllowed() {
        this.session.getDatabase().checkWritingAllowed();
    }

    public void freeUpDiskSpace() {
        this.session.getDatabase().freeUpDiskSpace();
    }

    public int getMaxLengthInplaceLob() {
        return this.session.getDatabase().getMaxLengthInplaceLob();
    }

    public TempFileDeleter getTempFileDeleter() {
        return this.session.getDatabase().getTempFileDeleter();
    }

    public String getLobCompressionAlgorithm(int n2) {
        return this.session.getDatabase().getLobCompressionAlgorithm(n2);
    }

    public void setCompressionAlgorithm(String string) {
        this.dW = string;
    }

    public Object getLobSyncObject() {
        return this;
    }

    public SmallLRUCache getLobFileListCache() {
        return null;
    }

    public LobStorage getLobStorage() {
        return null;
    }

    public Connection getLobConnection() {
        return null;
    }
}

