/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.util.ArrayList;
import java.util.HashSet;
import org.h2.command.dml.Query;
import org.h2.constant.SysProperties;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.Parameter;
import org.h2.expression.ValueExpression;
import org.h2.message.DbException;
import org.h2.result.LocalResult;
import org.h2.result.ResultInterface;
import org.h2.result.ResultTarget;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.util.New;
import org.h2.util.StringUtils;
import org.h2.value.Value;
import org.h2.value.ValueInt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SelectUnion
extends Query {
    public static final int UNION = 0;
    public static final int UNION_ALL = 1;
    public static final int EXCEPT = 2;
    public static final int INTERSECT = 3;
    private int S;
    private Query R;
    private Query aa;
    private ArrayList W;
    private Expression[] Q;
    private ArrayList Z;
    private SortOrder V;
    private boolean T;
    private boolean Y;
    private boolean U;
    private boolean X;

    public SelectUnion(Session session, Query query) {
        super(session);
        this.R = query;
    }

    public void setUnionType(int n2) {
        this.S = n2;
    }

    public int getUnionType() {
        return this.S;
    }

    public void setRight(Query query) {
        this.aa = query;
    }

    public Query getLeft() {
        return this.R;
    }

    public Query getRight() {
        return this.aa;
    }

    public void setSQL(String string) {
        this.sqlStatement = string;
    }

    public void setOrder(ArrayList arrayList) {
        this.Z = arrayList;
    }

    private Value[] if(Value[] valueArray, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            Expression expression = (Expression)this.W.get(i2);
            valueArray[i2] = valueArray[i2].convertTo(expression.getType());
        }
        return valueArray;
    }

    public ResultInterface queryMeta() {
        int n2 = this.R.getColumnCount();
        LocalResult localResult = new LocalResult(this.session, this.Q, n2);
        localResult.done();
        return localResult;
    }

    public LocalResult getEmptyResult() {
        int n2 = this.R.getColumnCount();
        return new LocalResult(this.session, this.Q, n2);
    }

    protected LocalResult queryWithoutCache(int n2, ResultTarget resultTarget) {
        if (n2 != 0) {
            if (this.limitExpr != null) {
                n2 = Math.min(this.limitExpr.getValue(this.session).getInt(), n2);
            }
            this.limitExpr = ValueExpression.get(ValueInt.get(n2));
        }
        if (this.session.getDatabase().getSettings().optimizeInsertFromSelect && this.S == 1 && resultTarget != null && this.V == null && !this.T && n2 == 0 && this.offsetExpr == null && this.limitExpr == null) {
            this.R.query(0, resultTarget);
            this.aa.query(0, resultTarget);
            return null;
        }
        int n3 = this.R.getColumnCount();
        LocalResult localResult = new LocalResult(this.session, this.Q, n3);
        if (this.V != null) {
            localResult.setSortOrder(this.V);
        }
        if (this.T) {
            this.R.setDistinct(true);
            this.aa.setDistinct(true);
            localResult.setDistinct();
        }
        switch (this.S) {
            case 0: 
            case 2: {
                this.R.setDistinct(true);
                this.aa.setDistinct(true);
                localResult.setDistinct();
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                this.R.setDistinct(true);
                this.aa.setDistinct(true);
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.S);
            }
        }
        ResultInterface resultInterface = this.R.query(0);
        ResultInterface resultInterface2 = this.aa.query(0);
        resultInterface.reset();
        resultInterface2.reset();
        switch (this.S) {
            case 0: 
            case 1: {
                while (resultInterface.next()) {
                    localResult.addRow(this.if(resultInterface.currentRow(), n3));
                }
                while (resultInterface2.next()) {
                    localResult.addRow(this.if(resultInterface2.currentRow(), n3));
                }
                break;
            }
            case 2: {
                while (resultInterface.next()) {
                    localResult.addRow(this.if(resultInterface.currentRow(), n3));
                }
                while (resultInterface2.next()) {
                    localResult.removeDistinct(this.if(resultInterface2.currentRow(), n3));
                }
                break;
            }
            case 3: {
                LocalResult localResult2 = new LocalResult(this.session, this.Q, n3);
                localResult2.setDistinct();
                while (resultInterface.next()) {
                    localResult2.addRow(this.if(resultInterface.currentRow(), n3));
                }
                while (resultInterface2.next()) {
                    Value[] valueArray = this.if(resultInterface2.currentRow(), n3);
                    if (!localResult2.containsDistinct(valueArray)) continue;
                    localResult.addRow(valueArray);
                }
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.S);
            }
        }
        if (this.offsetExpr != null) {
            localResult.setOffset(this.offsetExpr.getValue(this.session).getInt());
        }
        if (this.limitExpr != null) {
            localResult.setLimit(this.limitExpr.getValue(this.session).getInt());
        }
        localResult.done();
        if (resultTarget != null) {
            while (localResult.next()) {
                resultTarget.addRow(localResult.currentRow());
            }
            localResult.close();
            return null;
        }
        return localResult;
    }

    public void init() {
        if (SysProperties.CHECK && this.U) {
            DbException.throwInternalError();
        }
        this.U = true;
        this.R.init();
        this.aa.init();
        int n2 = this.R.getColumnCount();
        if (n2 != this.aa.getColumnCount()) {
            throw DbException.get(21002);
        }
        ArrayList arrayList = this.R.getExpressions();
        this.W = New.arrayList();
        for (int i2 = 0; i2 < n2; ++i2) {
            Expression expression = (Expression)arrayList.get(i2);
            this.W.add(expression);
        }
    }

    public void prepare() {
        if (this.Y) {
            return;
        }
        if (SysProperties.CHECK && !this.U) {
            DbException.throwInternalError("not initialized");
        }
        this.Y = true;
        this.R.prepare();
        this.aa.prepare();
        int n2 = this.R.getColumnCount();
        this.W = New.arrayList();
        ArrayList arrayList = this.R.getExpressions();
        ArrayList arrayList2 = this.aa.getExpressions();
        for (int i2 = 0; i2 < n2; ++i2) {
            Expression expression = (Expression)arrayList.get(i2);
            Expression expression2 = (Expression)arrayList2.get(i2);
            int n3 = Value.getHigherOrder(expression.getType(), expression2.getType());
            long l2 = Math.max(expression.getPrecision(), expression2.getPrecision());
            int n4 = Math.max(expression.getScale(), expression2.getScale());
            int n5 = Math.max(expression.getDisplaySize(), expression2.getDisplaySize());
            Column column = new Column(expression.getAlias(), n3, l2, n4, n5);
            ExpressionColumn expressionColumn = new ExpressionColumn(this.session.getDatabase(), column);
            this.W.add(expressionColumn);
        }
        if (this.Z != null) {
            this.initOrder(this.W, null, this.Z, this.getColumnCount(), true);
            this.V = this.prepareOrder(this.Z, this.W.size());
            this.Z = null;
        }
        this.Q = new Expression[this.W.size()];
        this.W.toArray(this.Q);
    }

    public double getCost() {
        return this.R.getCost() + this.aa.getCost();
    }

    public HashSet getTables() {
        HashSet hashSet = this.R.getTables();
        hashSet.addAll(this.aa.getTables());
        return hashSet;
    }

    public void setDistinct(boolean bl) {
        this.T = bl;
    }

    public ArrayList getExpressions() {
        return this.W;
    }

    public void setForUpdate(boolean bl) {
        this.R.setForUpdate(bl);
        this.aa.setForUpdate(bl);
        this.X = bl;
    }

    public int getColumnCount() {
        return this.R.getColumnCount();
    }

    public void mapColumns(ColumnResolver columnResolver, int n2) {
        this.R.mapColumns(columnResolver, n2);
        this.aa.mapColumns(columnResolver, n2);
    }

    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.R.setEvaluatable(tableFilter, bl);
        this.aa.setEvaluatable(tableFilter, bl);
    }

    public void addGlobalCondition(Parameter parameter, int n2, int n3) {
        this.addParameter(parameter);
        switch (this.S) {
            case 0: 
            case 1: 
            case 3: {
                this.R.addGlobalCondition(parameter, n2, n3);
                this.aa.addGlobalCondition(parameter, n2, n3);
                break;
            }
            case 2: {
                this.R.addGlobalCondition(parameter, n2, n3);
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.S);
            }
        }
    }

    public String getPlanSQL() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(').append(this.R.getPlanSQL()).append(')');
        switch (this.S) {
            case 1: {
                stringBuilder.append(" UNION ALL ");
                break;
            }
            case 0: {
                stringBuilder.append(" UNION ");
                break;
            }
            case 3: {
                stringBuilder.append(" INTERSECT ");
                break;
            }
            case 2: {
                stringBuilder.append(" EXCEPT ");
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.S);
            }
        }
        stringBuilder.append('(').append(this.aa.getPlanSQL()).append(')');
        Expression[] expressionArray = this.W.toArray(new Expression[this.W.size()]);
        if (this.V != null) {
            stringBuilder.append(" ORDER BY ").append(this.V.getSQL(expressionArray, expressionArray.length));
        }
        if (this.limitExpr != null) {
            stringBuilder.append(" LIMIT ").append(StringUtils.unEnclose(this.limitExpr.getSQL()));
            if (this.offsetExpr != null) {
                stringBuilder.append(" OFFSET ").append(StringUtils.unEnclose(this.offsetExpr.getSQL()));
            }
        }
        if (this.X) {
            stringBuilder.append(" FOR UPDATE");
        }
        return stringBuilder.toString();
    }

    public ResultInterface query(int n2, ResultTarget resultTarget) {
        return this.queryWithoutCache(n2, resultTarget);
    }

    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.R.isEverything(expressionVisitor) && this.aa.isEverything(expressionVisitor);
    }

    public boolean isReadOnly() {
        return this.R.isReadOnly() && this.aa.isReadOnly();
    }

    public void updateAggregate(Session session) {
        this.R.updateAggregate(session);
        this.aa.updateAggregate(session);
    }

    public void fireBeforeSelectTriggers() {
        this.R.fireBeforeSelectTriggers();
        this.aa.fireBeforeSelectTriggers();
    }

    public int getType() {
        return 66;
    }
}

