/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import org.h2.command.Prepared;
import org.h2.command.dml.SetTypes;
import org.h2.engine.Database;
import org.h2.engine.Mode;
import org.h2.engine.Session;
import org.h2.engine.Setting;
import org.h2.expression.Expression;
import org.h2.expression.ValueExpression;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;
import org.h2.schema.Schema;
import org.h2.table.Table;
import org.h2.tools.CompressTool;
import org.h2.util.StringUtils;
import org.h2.value.CompareMode;
import org.h2.value.ValueInt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Set
extends Prepared {
    private int al;
    private Expression an;
    private String ak;
    private String[] am;

    public Set(Session session, int n2) {
        super(session);
        this.al = n2;
    }

    public void setString(String string) {
        this.ak = string;
    }

    public boolean isTransactional() {
        switch (this.al) {
            case 5: 
            case 9: 
            case 10: 
            case 13: 
            case 20: 
            case 26: 
            case 28: 
            case 35: 
            case 36: {
                return true;
            }
        }
        return false;
    }

    public int update() {
        Database database = this.session.getDatabase();
        String string = SetTypes.getTypeName(this.al);
        block0 : switch (this.al) {
            case 24: {
                this.session.getUser().checkAdmin();
                int n2 = this.byte();
                if (n2 < 0 || n2 > 2) {
                    throw DbException.getInvalidValueException("ALLOW_LITERALS", this.byte());
                }
                database.setAllowLiterals(n2);
                this.a(string, null, n2);
                break;
            }
            case 8: {
                this.session.getUser().checkAdmin();
                database.setCacheSize(this.byte());
                this.a(string, null, this.byte());
                break;
            }
            case 13: {
                if ("TRUE".equals(this.ak)) break;
                String string2 = StringUtils.quoteStringSQL(this.ak);
                if (!string2.equals(database.getCluster()) && !string2.equals("''")) {
                    this.session.getUser().checkAdmin();
                }
                database.setCluster(string2);
                this.a(database.getSystemSession(), string, string2, 0);
                database.getSystemSession().commit(true);
                break;
            }
            case 12: {
                CompareMode compareMode;
                this.session.getUser().checkAdmin();
                Table table = database.getFirstUserTable();
                if (table != null) {
                    throw DbException.get(90089, table.getSQL());
                }
                StringBuilder stringBuilder = new StringBuilder(this.ak);
                if (this.ak.equals("OFF")) {
                    compareMode = CompareMode.getInstance(null, 0);
                } else {
                    int n3 = this.byte();
                    stringBuilder.append(" STRENGTH ");
                    if (n3 == 3) {
                        stringBuilder.append("IDENTICAL");
                    } else if (n3 == 0) {
                        stringBuilder.append("PRIMARY");
                    } else if (n3 == 1) {
                        stringBuilder.append("SECONDARY");
                    } else if (n3 == 2) {
                        stringBuilder.append("TERTIARY");
                    }
                    compareMode = CompareMode.getInstance(this.ak, n3);
                }
                this.a(string, stringBuilder.toString(), 0);
                database.setCompareMode(compareMode);
                break;
            }
            case 23: {
                this.session.getUser().checkAdmin();
                int n4 = CompressTool.getInstance().getCompressAlgorithm(this.ak);
                database.setLobCompressionAlgorithm(n4 == 0 ? null : this.ak);
                this.a(string, this.ak, 0);
                break;
            }
            case 34: {
                this.session.getUser().checkAdmin();
                if (!database.isStarting()) break;
                int n5 = this.byte();
                this.a(string, null, n5);
                break;
            }
            case 15: {
                this.session.getUser().checkAdmin();
                database.setEventListenerClass(this.ak);
                break;
            }
            case 18: {
                this.session.getUser().checkAdmin();
                database.setCloseDelay(this.byte());
                this.a(string, null, this.byte());
                break;
            }
            case 6: {
                this.session.getUser().checkAdmin();
                this.a(string, null, this.byte());
                break;
            }
            case 7: {
                this.session.getUser().checkAdmin();
                database.setDefaultTableType(this.byte());
                this.a(string, null, this.byte());
                break;
            }
            case 33: {
                this.session.getUser().checkAdmin();
                int n6 = this.byte();
                switch (n6) {
                    case 0: {
                        database.setExclusiveSession(null, false);
                        break block0;
                    }
                    case 1: {
                        database.setExclusiveSession(this.session, false);
                        break block0;
                    }
                    case 2: {
                        database.setExclusiveSession(this.session, true);
                        break block0;
                    }
                }
                throw DbException.getInvalidValueException("EXCLUSIVE", n6);
            }
            case 1: {
                this.session.getUser().checkAdmin();
                database.setIgnoreCase(this.byte() == 1);
                this.a(string, null, this.byte());
                break;
            }
            case 17: {
                this.session.getUser().checkAdmin();
                database.setLockMode(this.byte());
                this.a(string, null, this.byte());
                break;
            }
            case 5: {
                this.session.setLockTimeout(this.byte());
                break;
            }
            case 19: {
                int n7 = this.byte();
                if (!database.isPersistent() || n7 == database.getLogMode()) break;
                this.session.getUser().checkAdmin();
                database.setLogMode(n7);
                break;
            }
            case 22: {
                if (this.byte() < 0) {
                    throw DbException.getInvalidValueException("MAX_LENGTH_INPLACE_LOB", this.byte());
                }
                this.session.getUser().checkAdmin();
                database.setMaxLengthInplaceLob(this.byte());
                this.a(string, null, this.byte());
                break;
            }
            case 2: {
                this.session.getUser().checkAdmin();
                database.setMaxLogSize((long)this.byte() * 1024L * 1024L);
                this.a(string, null, this.byte());
                break;
            }
            case 16: {
                this.session.getUser().checkAdmin();
                database.setMaxMemoryRows(this.byte());
                this.a(string, null, this.byte());
                break;
            }
            case 21: {
                if (this.byte() < 0) {
                    throw DbException.getInvalidValueException("MAX_MEMORY_UNDO", this.byte());
                }
                this.session.getUser().checkAdmin();
                database.setMaxMemoryUndo(this.byte());
                this.a(string, null, this.byte());
                break;
            }
            case 32: {
                this.session.getUser().checkAdmin();
                int n8 = this.byte();
                database.setMaxOperationMemory(n8);
                break;
            }
            case 3: {
                this.session.getUser().checkAdmin();
                Mode mode = Mode.getInstance(this.ak);
                if (mode == null) {
                    throw DbException.get(90088, this.ak);
                }
                database.setMode(mode);
                break;
            }
            case 25: {
                this.session.getUser().checkAdmin();
                database.setMultiThreaded(this.byte() == 1);
                break;
            }
            case 31: {
                if (database.isMultiVersion() == (this.byte() == 1)) break;
                throw DbException.get(90133, "MVCC");
            }
            case 27: {
                this.session.getUser().checkAdmin();
                database.setOptimizeReuseResults(this.byte() != 0);
                break;
            }
            case 36: {
                int n9 = this.byte();
                this.session.setQueryTimeout(n9);
                break;
            }
            case 37: {
                int n10 = this.byte();
                this.session.setRedoLogBinary(n10 == 1);
                break;
            }
            case 30: {
                this.session.getUser().checkAdmin();
                int n11 = this.byte();
                if (n11 < 0 || n11 > 1) {
                    throw DbException.getInvalidValueException("REFERENTIAL_INTEGRITY", this.byte());
                }
                database.setReferentialIntegrity(n11 == 1);
                break;
            }
            case 26: {
                Schema schema = database.getSchema(this.ak);
                this.session.setCurrentSchema(schema);
                break;
            }
            case 28: {
                this.session.setSchemaSearchPath(this.am);
                break;
            }
            case 10: {
                this.session.getUser().checkAdmin();
                if (this.getCurrentObjectId() != 0) break;
                database.getTraceSystem().setLevelFile(this.byte());
                break;
            }
            case 9: {
                this.session.getUser().checkAdmin();
                if (this.getCurrentObjectId() != 0) break;
                database.getTraceSystem().setLevelSystemOut(this.byte());
                break;
            }
            case 11: {
                this.session.getUser().checkAdmin();
                int n12 = this.byte() * 1024 * 1024;
                database.getTraceSystem().setMaxFileSize(n12);
                this.a(string, null, this.byte());
                break;
            }
            case 20: {
                if (this.byte() < 0) {
                    throw DbException.getInvalidValueException("THROTTLE", this.byte());
                }
                this.session.setThrottle(this.byte());
                break;
            }
            case 29: {
                int n13 = this.byte();
                if (n13 < 0 || n13 > 1) {
                    throw DbException.getInvalidValueException("UNDO_LOG", this.byte());
                }
                this.session.setUndoLogEnabled(n13 == 1);
                break;
            }
            case 35: {
                Expression expression = this.an.optimize(this.session);
                this.session.setVariable(this.ak, expression.getValue(this.session));
                break;
            }
            case 14: {
                this.session.getUser().checkAdmin();
                database.setWriteDelay(this.byte());
                this.a(string, null, this.byte());
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.al);
            }
        }
        database.getNextModificationDataId();
        database.getNextModificationMetaId();
        return 0;
    }

    private int byte() {
        this.an = this.an.optimize(this.session);
        return this.an.getValue(this.session).getInt();
    }

    public void setInt(int n2) {
        this.an = ValueExpression.get(ValueInt.get(n2));
    }

    public void setExpression(Expression expression) {
        this.an = expression;
    }

    private void a(String string, String string2, int n2) {
        this.a(this.session, string, string2, n2);
    }

    private void a(Session session, String string, String string2, int n2) {
        Database database = session.getDatabase();
        if (database.isReadOnly()) {
            return;
        }
        Setting setting = database.findSetting(string);
        boolean bl = false;
        if (setting == null) {
            bl = true;
            int n3 = this.getObjectId();
            setting = new Setting(database, n3, string);
        }
        if (string2 != null) {
            if (!bl && setting.getStringValue().equals(string2)) {
                return;
            }
            setting.setStringValue(string2);
        } else {
            if (!bl && setting.getIntValue() == n2) {
                return;
            }
            setting.setIntValue(n2);
        }
        if (bl) {
            database.addDatabaseObject(session, setting);
        } else {
            database.update(session, setting);
        }
    }

    public boolean needRecompile() {
        return false;
    }

    public ResultInterface queryMeta() {
        return null;
    }

    public void setStringArray(String[] stringArray) {
        this.am = stringArray;
    }

    public int getType() {
        return 67;
    }
}

