/*
 * Decompiled with CFR 0.152.
 */
package org.h2.constraint;

import java.util.ArrayList;
import org.h2.command.Parser;
import org.h2.command.Prepared;
import org.h2.constraint.Constraint;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.Parameter;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.value.Value;
import org.h2.value.ValueNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ConstraintReferential
extends Constraint {
    public static final int RESTRICT = 0;
    public static final int CASCADE = 1;
    public static final int SET_DEFAULT = 2;
    public static final int SET_NULL = 3;
    private IndexColumn[] F;
    private IndexColumn[] C;
    private int J;
    private int M;
    private Table E;
    private Index I;
    private Index N;
    private boolean H;
    private boolean G;
    private String L;
    private String K;
    private boolean D;

    public ConstraintReferential(Schema schema, int n2, String string, Table table) {
        super(schema, n2, string, table);
    }

    public String getConstraintType() {
        return "REFERENTIAL";
    }

    private void a(StatementBuilder statementBuilder, int n2) {
        switch (n2) {
            case 1: {
                statementBuilder.append("CASCADE");
                break;
            }
            case 2: {
                statementBuilder.append("SET DEFAULT");
                break;
            }
            case 3: {
                statementBuilder.append("SET NULL");
                break;
            }
            default: {
                DbException.throwInternalError("action=" + n2);
            }
        }
    }

    public String getCreateSQLForCopy(Table table, String string) {
        return this.getCreateSQLForCopy(table, this.E, string, true);
    }

    /*
     * WARNING - void declaration
     */
    public String getCreateSQLForCopy(Table table, Table table2, String string, boolean bl) {
        void var9_12;
        StatementBuilder statementBuilder = new StatementBuilder("ALTER TABLE ");
        String string2 = table.getSQL();
        statementBuilder.append(string2).append(" ADD CONSTRAINT ");
        if (table.isHidden()) {
            statementBuilder.append("IF NOT EXISTS ");
        }
        statementBuilder.append(string);
        if (this.comment != null) {
            statementBuilder.append(" COMMENT ").append(StringUtils.quoteStringSQL(this.comment));
        }
        IndexColumn[] indexColumnArray = this.F;
        IndexColumn[] indexColumnArray2 = this.C;
        statementBuilder.append(" FOREIGN KEY(");
        for (IndexColumn indexColumn : indexColumnArray) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(indexColumn.getSQL());
        }
        statementBuilder.append(')');
        if (bl && this.H && table == this.table) {
            statementBuilder.append(" INDEX ").append(this.I.getSQL());
        }
        statementBuilder.append(" REFERENCES ");
        if (this.table == this.E) {
            String string3 = table.getSQL();
        } else {
            String string4 = table2.getSQL();
        }
        statementBuilder.append((String)var9_12).append('(');
        statementBuilder.resetCount();
        for (IndexColumn indexColumn : indexColumnArray2) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(indexColumn.getSQL());
        }
        statementBuilder.append(')');
        if (bl && this.G && table == this.table) {
            statementBuilder.append(" INDEX ").append(this.N.getSQL());
        }
        if (this.J != 0) {
            statementBuilder.append(" ON DELETE ");
            this.a(statementBuilder, this.J);
        }
        if (this.M != 0) {
            statementBuilder.append(" ON UPDATE ");
            this.a(statementBuilder, this.M);
        }
        return statementBuilder.append(" NOCHECK").toString();
    }

    private String do() {
        StatementBuilder statementBuilder = new StatementBuilder(this.getName());
        statementBuilder.append(": ").append(this.table.getSQL()).append(" FOREIGN KEY(");
        for (IndexColumn indexColumn : this.F) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(indexColumn.getSQL());
        }
        statementBuilder.append(") REFERENCES ").append(this.E.getSQL()).append('(');
        statementBuilder.resetCount();
        for (IndexColumn indexColumn : this.C) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(indexColumn.getSQL());
        }
        return statementBuilder.append(')').toString();
    }

    public String getCreateSQLWithoutIndexes() {
        return this.getCreateSQLForCopy(this.table, this.E, this.getSQL(), false);
    }

    public String getCreateSQL() {
        return this.getCreateSQLForCopy(this.table, this.getSQL());
    }

    public void setColumns(IndexColumn[] indexColumnArray) {
        this.F = indexColumnArray;
    }

    public IndexColumn[] getColumns() {
        return this.F;
    }

    public void setRefColumns(IndexColumn[] indexColumnArray) {
        this.C = indexColumnArray;
    }

    public IndexColumn[] getRefColumns() {
        return this.C;
    }

    public void setRefTable(Table table) {
        this.E = table;
        if (table.isTemporary()) {
            this.setTemporary(true);
        }
    }

    public void setIndex(Index index, boolean bl) {
        this.I = index;
        this.H = bl;
    }

    public void setRefIndex(Index index, boolean bl) {
        this.N = index;
        this.G = bl;
    }

    public void removeChildrenAndResources(Session session) {
        this.table.removeConstraint(this);
        this.E.removeConstraint(this);
        if (this.H) {
            this.table.removeIndexOrTransferOwnership(session, this.I);
        }
        if (this.G) {
            this.E.removeIndexOrTransferOwnership(session, this.N);
        }
        this.database.removeMeta(session, this.getId());
        this.E = null;
        this.I = null;
        this.N = null;
        this.F = null;
        this.C = null;
        this.L = null;
        this.K = null;
        this.table = null;
        this.invalidate();
    }

    public void checkRow(Session session, Table table, Row row, Row row2) {
        if (!this.database.getReferentialIntegrity()) {
            return;
        }
        if (!this.table.getCheckForeignKeyConstraints() || !this.E.getCheckForeignKeyConstraints()) {
            return;
        }
        if (table == this.table && !this.D) {
            this.if(session, row, row2);
        }
        if (table == this.E) {
            this.a(session, row, row2);
        }
    }

    private void if(Session session, Row row, Row row2) {
        int n2;
        int n3;
        int n4;
        Object object;
        if (row2 == null) {
            return;
        }
        boolean bl = row != null;
        for (IndexColumn indexColumn : this.F) {
            int n5 = indexColumn.column.getColumnId();
            object = row2.getValue(n5);
            if (object == ValueNull.INSTANCE) {
                return;
            }
            if (!bl || this.database.areEqual((Value)object, row.getValue(n5))) continue;
            bl = false;
        }
        if (bl) {
            return;
        }
        if (this.E == this.table) {
            boolean bl2 = true;
            n4 = this.F.length;
            for (n3 = 0; n3 < n4; ++n3) {
                int n6 = this.F[n3].column.getColumnId();
                Value value = row2.getValue(n6);
                object = this.C[n3].column;
                n2 = ((Column)object).getColumnId();
                Value value2 = row2.getValue(n2);
                if (this.database.areEqual(value2, value)) continue;
                bl2 = false;
                break;
            }
            if (bl2) {
                return;
            }
        }
        Row row3 = this.E.getTemplateRow();
        n4 = this.F.length;
        for (n3 = 0; n3 < n4; ++n3) {
            int n7 = this.F[n3].column.getColumnId();
            Value value = row2.getValue(n7);
            object = this.C[n3].column;
            n2 = ((Column)object).getColumnId();
            row3.setValue(n2, ((Column)object).convert(value));
        }
        if (!this.a(session, this.N, row3, null)) {
            throw DbException.get(23002, this.do());
        }
    }

    private boolean a(Session session, Index index, SearchRow searchRow, Row row) {
        Table table = index.getTable();
        table.lock(session, false, false);
        Cursor cursor = index.find(session, searchRow, searchRow);
        while (cursor.next()) {
            SearchRow searchRow2 = cursor.getSearchRow();
            if (row != null && searchRow2.getKey() == row.getKey()) continue;
            Column[] columnArray = index.getColumns();
            boolean bl = true;
            int n2 = Math.min(this.F.length, columnArray.length);
            for (int i2 = 0; i2 < n2; ++i2) {
                Value value;
                int n3 = columnArray[i2].getColumnId();
                Value value2 = searchRow.getValue(n3);
                if (table.compareTypeSave(value2, value = searchRow2.getValue(n3)) == 0) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return true;
        }
        return false;
    }

    private boolean a(Row row, Row row2) {
        return this.N.compareRows(row, row2) == 0;
    }

    private void if(Session session, Row row) {
        Row row2;
        SearchRow searchRow = this.table.getTemplateSimpleRow(false);
        int n2 = this.F.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Column column = this.F[i2].column;
            Column column2 = this.C[i2].column;
            int n3 = column2.getColumnId();
            Value value = column.convert(row.getValue(n3));
            if (value == ValueNull.INSTANCE) {
                return;
            }
            searchRow.setValue(column.getColumnId(), value);
        }
        Row row3 = row2 = this.E == this.table ? row : null;
        if (this.a(session, this.I, searchRow, row2)) {
            throw DbException.get(23003, this.do());
        }
    }

    private void a(Session session, Row row, Row row2) {
        if (row == null) {
            return;
        }
        if (row2 != null && this.a(row, row2)) {
            return;
        }
        if (row2 == null) {
            if (this.J == 0) {
                this.if(session, row);
            } else {
                int n2 = this.J == 1 ? 0 : this.F.length;
                Prepared prepared = this.if(session);
                this.a(prepared, n2, row);
                this.a(prepared);
            }
        } else if (this.M == 0) {
            this.if(session, row);
        } else {
            Prepared prepared = this.a(session);
            if (this.M == 1) {
                ArrayList arrayList = prepared.getParameters();
                int n3 = this.F.length;
                for (int i2 = 0; i2 < n3; ++i2) {
                    Parameter parameter = (Parameter)arrayList.get(i2);
                    Column column = this.C[i2].column;
                    parameter.setValue(row2.getValue(column.getColumnId()));
                }
            }
            this.a(prepared, this.F.length, row);
            this.a(prepared);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(Prepared prepared) {
        try {
            this.D = true;
            prepared.update();
        }
        finally {
            this.D = false;
        }
    }

    private void a(Prepared prepared, int n2, Row row) {
        int n3 = this.C.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = this.C[i2].column.getColumnId();
            Value value = row.getValue(n4);
            ArrayList arrayList = prepared.getParameters();
            Parameter parameter = (Parameter)arrayList.get(n2 + i2);
            parameter.setValue(value);
        }
    }

    public int getDeleteAction() {
        return this.J;
    }

    public void setDeleteAction(int n2) {
        if (n2 == this.J && this.L == null) {
            return;
        }
        if (this.J != 0) {
            throw DbException.get(90045, "ON DELETE");
        }
        this.J = n2;
        this.for();
    }

    private void for() {
        if (this.J == 0) {
            return;
        }
        StatementBuilder statementBuilder = new StatementBuilder();
        if (this.J == 1) {
            statementBuilder.append("DELETE FROM ").append(this.table.getSQL());
        } else {
            this.if(statementBuilder);
        }
        this.a(statementBuilder);
        this.L = statementBuilder.toString();
    }

    private Prepared a(Session session) {
        return this.a(session, this.K, this.M);
    }

    private Prepared if(Session session) {
        return this.a(session, this.L, this.J);
    }

    public int getUpdateAction() {
        return this.M;
    }

    public void setUpdateAction(int n2) {
        if (n2 == this.M && this.K == null) {
            return;
        }
        if (this.M != 0) {
            throw DbException.get(90045, "ON UPDATE");
        }
        this.M = n2;
        this.int();
    }

    private void int() {
        if (this.M == 0) {
            return;
        }
        StatementBuilder statementBuilder = new StatementBuilder();
        this.if(statementBuilder);
        this.a(statementBuilder);
        this.K = statementBuilder.toString();
    }

    public void rebuild() {
        this.int();
        this.for();
    }

    private Prepared a(Session session, String string, int n2) {
        Prepared prepared = session.prepare(string);
        if (n2 != 1) {
            ArrayList arrayList = prepared.getParameters();
            int n3 = this.F.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                Value value;
                Column column = this.F[i2].column;
                Parameter parameter = (Parameter)arrayList.get(i2);
                if (n2 == 3) {
                    value = ValueNull.INSTANCE;
                } else {
                    Expression expression = column.getDefaultExpression();
                    if (expression == null) {
                        throw DbException.get(90056, column.getName());
                    }
                    value = expression.getValue(session);
                }
                parameter.setValue(value);
            }
        }
        return prepared;
    }

    private void if(StatementBuilder statementBuilder) {
        statementBuilder.append("UPDATE ").append(this.table.getSQL()).append(" SET ");
        statementBuilder.resetCount();
        for (IndexColumn indexColumn : this.F) {
            statementBuilder.appendExceptFirst(" , ");
            statementBuilder.append(Parser.quoteIdentifier(indexColumn.column.getName())).append("=?");
        }
    }

    private void a(StatementBuilder statementBuilder) {
        statementBuilder.append(" WHERE ");
        statementBuilder.resetCount();
        for (IndexColumn indexColumn : this.F) {
            statementBuilder.appendExceptFirst(" AND ");
            statementBuilder.append(Parser.quoteIdentifier(indexColumn.column.getName())).append("=?");
        }
    }

    public Table getRefTable() {
        return this.E;
    }

    public boolean usesIndex(Index index) {
        return index == this.I || index == this.N;
    }

    public void setIndexOwner(Index index) {
        if (this.I == index) {
            this.H = true;
        } else if (this.N == index) {
            this.G = true;
        } else {
            DbException.throwInternalError();
        }
    }

    public boolean containsColumn(Column column) {
        for (IndexColumn indexColumn : this.F) {
            if (indexColumn.column != column) continue;
            return true;
        }
        for (IndexColumn indexColumn : this.C) {
            if (indexColumn.column != column) continue;
            return true;
        }
        return false;
    }

    public boolean isBefore() {
        return false;
    }

    public void checkExistingData(Session session) {
        if (session.getDatabase().isStarting()) {
            return;
        }
        StatementBuilder statementBuilder = new StatementBuilder("SELECT 1 FROM (SELECT ");
        for (IndexColumn indexColumn : this.F) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(indexColumn.getSQL());
        }
        statementBuilder.append(" FROM ").append(this.table.getSQL()).append(" WHERE ");
        statementBuilder.resetCount();
        for (IndexColumn indexColumn : this.F) {
            statementBuilder.appendExceptFirst(" AND ");
            statementBuilder.append(indexColumn.getSQL()).append(" IS NOT NULL ");
        }
        statementBuilder.append(" ORDER BY ");
        statementBuilder.resetCount();
        for (IndexColumn indexColumn : this.F) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(indexColumn.getSQL());
        }
        statementBuilder.append(") C WHERE NOT EXISTS(SELECT 1 FROM ").append(this.E.getSQL()).append(" P WHERE ");
        statementBuilder.resetCount();
        int n2 = 0;
        for (IndexColumn indexColumn : this.F) {
            statementBuilder.appendExceptFirst(" AND ");
            statementBuilder.append("C.").append(indexColumn.getSQL()).append('=').append("P.").append(this.C[n2++].getSQL());
        }
        statementBuilder.append(')');
        String string = statementBuilder.toString();
        ResultInterface resultInterface = session.prepare(string).query(1);
        if (resultInterface.next()) {
            throw DbException.get(23002, this.do());
        }
    }

    public Index getUniqueIndex() {
        return this.N;
    }
}

