/*
 * Decompiled with CFR 0.152.
 */
package org.h2.constraint;

import org.h2.command.Parser;
import org.h2.constraint.Constraint;
import org.h2.engine.Session;
import org.h2.index.Index;
import org.h2.result.Row;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ConstraintUnique
extends Constraint {
    private Index P;
    private boolean R;
    private IndexColumn[] Q;
    private boolean O;

    public ConstraintUnique(Schema schema, int n2, String string, Table table, boolean bl) {
        super(schema, n2, string, table);
        this.O = bl;
    }

    public String getConstraintType() {
        return this.O ? "PRIMARY KEY" : "UNIQUE";
    }

    public String getCreateSQLForCopy(Table table, String string) {
        return this.a(table, string, true);
    }

    private String a(Table table, String string, boolean bl) {
        StatementBuilder statementBuilder = new StatementBuilder("ALTER TABLE ");
        statementBuilder.append(table.getSQL()).append(" ADD CONSTRAINT ");
        if (table.isHidden()) {
            statementBuilder.append("IF NOT EXISTS ");
        }
        statementBuilder.append(string);
        if (this.comment != null) {
            statementBuilder.append(" COMMENT ").append(StringUtils.quoteStringSQL(this.comment));
        }
        statementBuilder.append(' ').append(this.new()).append('(');
        for (IndexColumn indexColumn : this.Q) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(Parser.quoteIdentifier(indexColumn.column.getName()));
        }
        statementBuilder.append(')');
        if (bl && this.R && table == this.table) {
            statementBuilder.append(" INDEX ").append(this.P.getSQL());
        }
        return statementBuilder.toString();
    }

    private String new() {
        if (this.O) {
            return "PRIMARY KEY";
        }
        return "UNIQUE";
    }

    public String getCreateSQLWithoutIndexes() {
        return this.a(this.table, this.getSQL(), false);
    }

    public String getCreateSQL() {
        return this.getCreateSQLForCopy(this.table, this.getSQL());
    }

    public void setColumns(IndexColumn[] indexColumnArray) {
        this.Q = indexColumnArray;
    }

    public IndexColumn[] getColumns() {
        return this.Q;
    }

    public void setIndex(Index index, boolean bl) {
        this.P = index;
        this.R = bl;
    }

    public void removeChildrenAndResources(Session session) {
        this.table.removeConstraint(this);
        if (this.R) {
            this.table.removeIndexOrTransferOwnership(session, this.P);
        }
        this.database.removeMeta(session, this.getId());
        this.P = null;
        this.Q = null;
        this.table = null;
        this.invalidate();
    }

    public void checkRow(Session session, Table table, Row row, Row row2) {
    }

    public boolean usesIndex(Index index) {
        return index == this.P;
    }

    public void setIndexOwner(Index index) {
        this.R = true;
    }

    public boolean containsColumn(Column column) {
        for (IndexColumn indexColumn : this.Q) {
            if (indexColumn.column != column) continue;
            return true;
        }
        return false;
    }

    public boolean isBefore() {
        return true;
    }

    public void checkExistingData(Session session) {
    }

    public Index getUniqueIndex() {
        return this.P;
    }

    public void rebuild() {
    }
}

