/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.h2.api.DatabaseEventListener;
import org.h2.command.ddl.CreateTableData;
import org.h2.command.dml.SetTypes;
import org.h2.constant.DbSettings;
import org.h2.constant.SysProperties;
import org.h2.constraint.Constraint;
import org.h2.engine.Comment;
import org.h2.engine.ConnectionInfo;
import org.h2.engine.DatabaseCloser;
import org.h2.engine.DbObject;
import org.h2.engine.DbObjectBase;
import org.h2.engine.Engine;
import org.h2.engine.MetaRecord;
import org.h2.engine.Mode;
import org.h2.engine.Role;
import org.h2.engine.Session;
import org.h2.engine.Setting;
import org.h2.engine.User;
import org.h2.engine.UserAggregate;
import org.h2.engine.UserDataType;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.DbException;
import org.h2.message.Trace;
import org.h2.message.TraceSystem;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.schema.SchemaObjectBase;
import org.h2.schema.Sequence;
import org.h2.schema.TriggerObject;
import org.h2.store.DataHandler;
import org.h2.store.FileLock;
import org.h2.store.FileStore;
import org.h2.store.LobStorage;
import org.h2.store.PageStore;
import org.h2.store.WriterThread;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.MetaTable;
import org.h2.table.Table;
import org.h2.table.TableLinkConnection;
import org.h2.table.TableView;
import org.h2.tools.DeleteDbFiles;
import org.h2.tools.Server;
import org.h2.util.BitField;
import org.h2.util.IOUtils;
import org.h2.util.MathUtils;
import org.h2.util.NetUtils;
import org.h2.util.New;
import org.h2.util.SmallLRUCache;
import org.h2.util.SourceCompiler;
import org.h2.util.StringUtils;
import org.h2.util.TempFileDeleter;
import org.h2.util.Utils;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueInt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Database
implements DataHandler {
    private static int fb;
    private static final String eq = "DBA";
    private final boolean eF;
    private final String et;
    private final String eu;
    private final String fa;
    private final String eD;
    private final byte[] fn;
    private final HashMap ek = New.hashMap();
    private final HashMap ff = New.hashMap();
    private final HashMap ft = New.hashMap();
    private final HashMap eA = New.hashMap();
    private final HashMap fD = New.hashMap();
    private final HashMap eU = New.hashMap();
    private final HashMap e1 = New.hashMap();
    private final HashMap e9 = New.hashMap();
    private final Set fC = Collections.synchronizedSet(new HashSet());
    private Session eM;
    private final BitField fq = new BitField();
    private final Object eh = new Object();
    private Schema em;
    private Schema eZ;
    private int el;
    private int e6;
    private User eC;
    private Session fx;
    private Table eG;
    private Index e5;
    private FileLock fk;
    private WriterThread ez;
    private boolean fB;
    private TraceSystem eB;
    private Trace eP;
    private int fc;
    private Role fw;
    private long eE;
    private long fA;
    private CompareMode eJ;
    private String eT = "''";
    private boolean fz;
    private boolean fs;
    private int eV = 500;
    private DatabaseEventListener eN;
    private int eR = 10000;
    private int fj = 50000;
    private int fh = 3;
    private int eo;
    private int e8 = 2;
    private int eL = fb;
    private int ei;
    private DatabaseCloser fv;
    private volatile boolean e3;
    private boolean e4;
    private boolean e2;
    private String eI;
    private boolean ep = true;
    private String fy;
    private String es;
    private boolean fi = true;
    private boolean fo;
    private DatabaseCloser fp;
    private Mode e7 = Mode.getInstance("REGULAR");
    private boolean er;
    private int eH = 100000;
    private SmallLRUCache en;
    private boolean ev;
    private Server ex;
    private HashMap ej;
    private TempFileDeleter eQ = TempFileDeleter.getInstance();
    private PageStore eg;
    private Properties fr;
    private volatile long eW;
    private volatile boolean eO;
    private volatile int e0;
    private volatile boolean eS;
    private final Object eY = new Object();
    private int fm;
    private int ey;
    private SourceCompiler fe;
    private volatile boolean ew;
    private boolean fl;
    private LobStorage fu;
    private int eX = 2048;
    private int fg = 0;
    private final DbSettings fd;
    private final int eK;

    public Database(ConnectionInfo connectionInfo, String string) {
        String string2;
        String string3 = connectionInfo.getName();
        this.fd = connectionInfo.getDbSettings();
        this.eK = this.fd.reconnectCheckDelay;
        this.eJ = CompareMode.getInstance(null, 0);
        this.eF = connectionInfo.isPersistent();
        this.fn = connectionInfo.getFilePasswordHash();
        this.et = string3;
        this.eu = this.u();
        this.eo = SysProperties.LOB_IN_DATABASE ? 128 : 4096;
        this.eD = string;
        String string4 = connectionInfo.getProperty("FILE_LOCK", null);
        this.es = connectionInfo.getProperty("ACCESS_MODE_DATA", "rw").toLowerCase();
        this.ev = connectionInfo.getProperty("AUTO_SERVER", false);
        this.fm = connectionInfo.getProperty("CACHE_SIZE", 16384);
        this.eX = connectionInfo.getProperty("PAGE_SIZE", 2048);
        if ("r".equals(this.es)) {
            this.fz = true;
        }
        this.fc = FileLock.getFileLockMethod(string4);
        this.fa = connectionInfo.getURL();
        String string5 = connectionInfo.removeProperty("DATABASE_EVENT_LISTENER", null);
        if (string5 != null) {
            string5 = StringUtils.trim(string5, true, true, "'");
            this.setEventListenerClass(string5);
        }
        if ((string2 = connectionInfo.removeProperty("MODE", null)) != null) {
            this.e7 = Mode.getInstance(string2);
        }
        this.fo = connectionInfo.getProperty("MVCC", false);
        boolean bl = this.fd.dbCloseOnExit;
        int n2 = connectionInfo.getIntProperty(10, 1);
        int n3 = connectionInfo.getIntProperty(9, 0);
        this.fy = StringUtils.toUpperEnglish(connectionInfo.removeProperty("CACHE_TYPE", "LRU"));
        this.a(n2, n3, bl);
    }

    private void a(int n2, int n3, boolean bl) {
        try {
            this.a(n2, n3);
            if (bl) {
                try {
                    this.fp = new DatabaseCloser(this, 0, true);
                    Runtime.getRuntime().addShutdownHook(this.fp);
                }
                catch (IllegalStateException illegalStateException) {
                }
                catch (SecurityException securityException) {}
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof OutOfMemoryError) {
                throwable.fillInStackTrace();
            }
            if (this.eB != null) {
                SQLException sQLException;
                if (throwable instanceof SQLException && (sQLException = (SQLException)throwable).getErrorCode() != 90020) {
                    this.eP.error(throwable, "opening {0}", this.et);
                }
                this.eB.close();
            }
            this.if(false);
            throw DbException.convert(throwable);
        }
    }

    public static void setInitialPowerOffCount(int n2) {
        fb = n2;
    }

    public void setPowerOffCount(int n2) {
        if (this.eL == -1) {
            return;
        }
        this.eL = n2;
    }

    public boolean areEqual(Value value, Value value2) {
        return value.compareTo(value2, this.eJ) == 0;
    }

    public int compare(Value value, Value value2) {
        return value.compareTo(value2, this.eJ);
    }

    public int compareTypeSave(Value value, Value value2) {
        return value.compareTypeSave(value2, this.eJ);
    }

    public long getModificationDataId() {
        return this.eE;
    }

    synchronized boolean reconnectModified(boolean bl) {
        if (this.fz || this.fk == null || this.fc != 3) {
            return true;
        }
        try {
            Object object;
            if (bl == this.eO) {
                long l2 = System.currentTimeMillis();
                if (l2 > this.eW) {
                    if (bl) {
                        String string = this.eg == null ? null : "" + this.eg.getWriteCountTotal();
                        this.fk.setProperty("logPos", string);
                        this.fk.save();
                    }
                    this.eW = l2 + (long)this.eK;
                }
                return true;
            }
            Properties properties = this.fk.load();
            if (bl) {
                if (properties.getProperty("changePending") != null) {
                    return false;
                }
                this.eP.debug("wait before writing");
                Thread.sleep((int)((double)this.eK * 1.1));
                object = this.fk.load();
                if (!((Properties)object).equals(properties)) {
                    return false;
                }
            }
            object = this.eg == null ? null : "" + this.eg.getWriteCountTotal();
            this.fk.setProperty("logPos", (String)object);
            if (bl) {
                this.fk.setProperty("changePending", "true-" + Math.random());
            } else {
                this.fk.setProperty("changePending", null);
            }
            this.eW = System.currentTimeMillis() + (long)(2 * this.eK);
            properties = this.fk.save();
            if (bl) {
                this.eP.debug("wait before writing again");
                Thread.sleep((int)((double)this.eK * 1.1));
                Properties properties2 = this.fk.load();
                if (!properties2.equals(properties)) {
                    return false;
                }
            } else {
                Thread.sleep(1L);
            }
            this.fr = properties;
            this.eO = bl;
            this.eW = System.currentTimeMillis() + (long)this.eK;
            return true;
        }
        catch (Exception exception) {
            this.eP.error(exception, "pending {0}", bl);
            return false;
        }
    }

    public long getNextModificationDataId() {
        return ++this.eE;
    }

    public long getModificationMetaId() {
        return this.fA;
    }

    public long getNextModificationMetaId() {
        ++this.eE;
        return this.fA++;
    }

    public int getPowerOffCount() {
        return this.eL;
    }

    public void checkPowerOff() {
        if (this.eL == 0) {
            return;
        }
        if (this.eL > 1) {
            --this.eL;
            return;
        }
        if (this.eL != -1) {
            try {
                this.eL = -1;
                this.q();
                if (this.eg != null) {
                    try {
                        this.eg.close();
                    }
                    catch (DbException dbException) {
                        // empty catch block
                    }
                    this.eg = null;
                }
                if (this.fk != null) {
                    this.r();
                    if (this.fc != 3) {
                        this.fk.unlock();
                    }
                    this.fk = null;
                }
                if (this.eB != null) {
                    this.eB.close();
                }
            }
            catch (DbException dbException) {
                TraceSystem.traceThrowable(dbException);
            }
        }
        Engine.getInstance().close(this.et);
        throw DbException.get(90098);
    }

    public static boolean exists(String string) {
        return IOUtils.exists(string + ".h2.db");
    }

    public Trace getTrace(String string) {
        return this.eB.getTrace(string);
    }

    public FileStore openFile(String string, String string2, boolean bl) {
        if (bl && !IOUtils.exists(string)) {
            throw DbException.get(90124, string);
        }
        FileStore fileStore = FileStore.open(this, string, string2, this.eD, this.fn);
        try {
            fileStore.init();
        }
        catch (DbException dbException) {
            fileStore.closeSilently();
            throw dbException;
        }
        return fileStore;
    }

    public boolean validateFilePasswordHash(String string, byte[] byArray) {
        if (!StringUtils.equals(string, this.eD)) {
            return false;
        }
        return Utils.compareSecure(byArray, this.fn);
    }

    private String u() {
        String string = this.et;
        if (string.endsWith(":")) {
            string = null;
        }
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/\\:,;");
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
            }
        }
        if (string == null || string.length() == 0) {
            string = "unnamed";
        }
        return this.fd.databaseToUpper ? StringUtils.toUpperEnglish(string) : string;
    }

    private synchronized void a(int n2, int n3) {
        Object object;
        Object object2;
        IndexColumn[] indexColumnArray;
        boolean bl;
        Object object3;
        Object object4;
        if (this.eF) {
            object4 = this.et + ".data.db";
            boolean bl2 = IOUtils.exists((String)object4);
            object3 = this.et + ".h2.db";
            bl = IOUtils.exists((String)object3);
            if (bl2 && !bl) {
                throw DbException.get(90048, "Old database: " + (String)object4 + " - please convert the database to a SQL script and re-create it.");
            }
            if (bl && IOUtils.isReadOnly((String)object3)) {
                this.fz |= IOUtils.isReadOnly((String)object3);
            }
            this.eB = this.fz ? new TraceSystem(null) : new TraceSystem(this.et + ".trace.db");
            this.eB.setLevelFile(n2);
            this.eB.setLevelSystemOut(n3);
            this.eP = this.eB.getTrace("database");
            this.eP.info("opening {0} (build {1})", this.et, 147);
            if (this.ev && (this.fz || this.fc == 0 || this.fc == 3 || this.fc == 4)) {
                throw DbException.getUnsupportedException("autoServerMode && (readOnly || fileLockMethod == NO || fileLockMethod == SERIALIZED)");
            }
            indexColumnArray = this.et + ".lock.db";
            if (this.fz && IOUtils.exists((String)indexColumnArray)) {
                throw DbException.get(90020, "Lock file exists: " + (String)indexColumnArray);
            }
            if (!this.fz && this.fc != 0 && this.fc != 4) {
                this.fk = new FileLock(this.eB, (String)indexColumnArray, 1000);
                this.fk.lock(this.fc);
                if (this.ev) {
                    this.for(this.fk.getUniqueId());
                }
            }
            while (this.isReconnectNeeded() && !this.beforeWriting()) {
            }
            this.p();
            this.fB = true;
            this.getPageStore();
            this.fB = false;
            this.ez = WriterThread.create(this, this.eV);
        } else {
            this.eB = new TraceSystem(null);
            this.eP = this.eB.getTrace("database");
        }
        this.eC = new User(this, 0, eq, true);
        this.em = new Schema(this, 0, "PUBLIC", this.eC, true);
        this.eZ = new Schema(this, -1, "INFORMATION_SCHEMA", this.eC, true);
        this.eA.put(this.em.getName(), this.em);
        this.eA.put(this.eZ.getName(), this.eZ);
        this.fw = new Role(this, 0, "PUBLIC", true);
        this.ek.put("PUBLIC", this.fw);
        this.eC.setAdmin(true);
        this.fx = new Session(this, this.eC, ++this.el);
        object4 = new CreateTableData();
        ArrayList arrayList = ((CreateTableData)object4).columns;
        object3 = new Column("ID", 4);
        ((Column)object3).setNullable(false);
        arrayList.add(object3);
        arrayList.add(new Column("HEAD", 4));
        arrayList.add(new Column("TYPE", 4));
        arrayList.add(new Column("SQL", 13));
        bl = true;
        if (this.eg != null) {
            bl = this.eg.isNew();
        }
        ((CreateTableData)object4).tableName = "SYS";
        ((CreateTableData)object4).id = 0;
        ((CreateTableData)object4).temporary = false;
        ((CreateTableData)object4).persistData = this.eF;
        ((CreateTableData)object4).persistIndexes = this.eF;
        ((CreateTableData)object4).create = bl;
        ((CreateTableData)object4).isHidden = true;
        ((CreateTableData)object4).session = this.fx;
        this.eG = this.em.createTable((CreateTableData)object4);
        indexColumnArray = IndexColumn.wrap(new Column[]{object3});
        this.e5 = this.eG.addIndex(this.fx, "SYS_ID", 0, indexColumnArray, IndexType.createPrimaryKey(false, false), true, null);
        this.fq.set(0);
        this.fB = true;
        Cursor cursor = this.e5.find(this.fx, null, null);
        ArrayList arrayList2 = New.arrayList();
        while (cursor.next()) {
            object2 = new MetaRecord(cursor.get());
            this.fq.set(((MetaRecord)object2).getId());
            arrayList2.add(object2);
        }
        Collections.sort(arrayList2);
        object2 = arrayList2.iterator();
        while (object2.hasNext()) {
            object = (MetaRecord)object2.next();
            ((MetaRecord)object).execute(this, this.fx, this.eN);
        }
        this.a(this.fx);
        this.fB = false;
        if (!this.fz && this.ft.get(object2 = SetTypes.getTypeName(34)) == null) {
            object = new Setting(this, this.allocateObjectId(), (String)object2);
            ((Setting)object).setIntValue(147);
            this.addDatabaseObject(this.fx, (DbObject)object);
        }
        this.fx.commit(true);
        this.eP.info("opened {0}", this.et);
        this.afterWriting();
    }

    private void for(String string) {
        try {
            this.ex = Server.createTcpServer("-tcpPort", "0", "-tcpAllowOthers", "-tcpDaemon", "-key", string, this.et);
            this.ex.start();
        }
        catch (SQLException sQLException) {
            throw DbException.convert(sQLException);
        }
        String string2 = NetUtils.getLocalAddress() + ":" + this.ex.getPort();
        this.fk.setProperty("server", string2);
        this.fk.save();
    }

    private void r() {
        if (this.ex != null) {
            Server server = this.ex;
            this.ex = null;
            server.stop();
        }
    }

    private void a(Session session) {
        TableView tableView;
        boolean bl;
        do {
            bl = false;
            for (Table table : this.getAllTablesAndViews(false)) {
                if (!(table instanceof TableView) || !(tableView = (TableView)table).isInvalid()) continue;
                try {
                    tableView.recompile(session);
                }
                catch (DbException dbException) {
                    // empty catch block
                }
                if (tableView.isInvalid()) continue;
                bl = true;
            }
        } while (bl);
        for (Table table : this.getAllTablesAndViews(false)) {
            if (!(table instanceof TableView) || (tableView = (TableView)table).isInvalid()) continue;
            try {
                tableView.recompile(this.fx);
            }
            catch (DbException dbException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void t() {
        if (this.ew) {
            return;
        }
        Schema schema = this.eZ;
        synchronized (schema) {
            if (!this.ew) {
                int n2 = MetaTable.getMetaTableTypeCount();
                for (int i2 = 0; i2 < n2; ++i2) {
                    MetaTable metaTable = new MetaTable(this.eZ, -1 - i2, i2);
                    this.eZ.add(metaTable);
                }
                this.ew = true;
            }
        }
    }

    private synchronized void a(Session session, DbObject dbObject) {
        int n2 = dbObject.getId();
        if (n2 > 0 && !this.fB && !dbObject.isTemporary()) {
            Row row = this.eG.getTemplateRow();
            MetaRecord metaRecord = new MetaRecord(dbObject);
            metaRecord.setRecord(row);
            this.fq.set(n2);
            this.eG.lock(session, true, true);
            this.eG.addRow(session, row);
            if (this.isMultiVersion()) {
                session.log(this.eG, (short)0, row);
            }
        }
    }

    public synchronized void removeMeta(Session session, int n2) {
        if (n2 > 0 && !this.fB) {
            SearchRow searchRow = this.eG.getTemplateSimpleRow(false);
            searchRow.setValue(0, ValueInt.get(n2));
            boolean bl = this.eG.isLockedExclusivelyBy(session);
            this.eG.lock(session, true, true);
            Cursor cursor = this.e5.find(session, searchRow, searchRow);
            if (cursor.next()) {
                Row row = cursor.get();
                this.eG.removeRow(session, row);
                if (this.isMultiVersion()) {
                    session.log(this.eG, (short)1, row);
                }
                this.fq.clear(n2);
                if (SysProperties.CHECK) {
                    this.a(session, n2);
                }
            } else if (!bl) {
                this.eG.unlock(session);
                session.unlock(this.eG);
            }
        }
    }

    private HashMap a(int n2) {
        HashMap hashMap;
        switch (n2) {
            case 2: {
                hashMap = this.ff;
                break;
            }
            case 6: {
                hashMap = this.ft;
                break;
            }
            case 7: {
                hashMap = this.ek;
                break;
            }
            case 8: {
                hashMap = this.fD;
                break;
            }
            case 10: {
                hashMap = this.eA;
                break;
            }
            case 12: {
                hashMap = this.eU;
                break;
            }
            case 13: {
                hashMap = this.e9;
                break;
            }
            case 14: {
                hashMap = this.e1;
                break;
            }
            default: {
                throw DbException.throwInternalError("type=" + n2);
            }
        }
        return hashMap;
    }

    public synchronized void addSchemaObject(Session session, SchemaObject schemaObject) {
        int n2 = schemaObject.getId();
        if (n2 > 0 && !this.fB) {
            this.checkWritingAllowed();
        }
        schemaObject.getSchema().add(schemaObject);
        this.a(session, schemaObject);
    }

    public synchronized void addDatabaseObject(Session session, DbObject dbObject) {
        Object object;
        int n2 = dbObject.getId();
        if (n2 > 0 && !this.fB) {
            this.checkWritingAllowed();
        }
        HashMap hashMap = this.a(dbObject.getType());
        if (dbObject.getType() == 2 && ((User)(object = (User)dbObject)).isAdmin() && this.eC.getName().equals(eq)) {
            this.eC.rename(((DbObjectBase)object).getName());
        }
        object = dbObject.getName();
        if (SysProperties.CHECK && hashMap.get(object) != null) {
            DbException.throwInternalError("object already exists");
        }
        this.a(session, dbObject);
        hashMap.put(object, dbObject);
    }

    public UserAggregate findAggregate(String string) {
        return (UserAggregate)this.e1.get(string);
    }

    public Comment findComment(DbObject dbObject) {
        if (dbObject.getType() == 13) {
            return null;
        }
        String string = Comment.getKey(dbObject);
        return (Comment)this.e9.get(string);
    }

    public Role findRole(String string) {
        return (Role)this.ek.get(string);
    }

    public Schema findSchema(String string) {
        Schema schema = (Schema)this.eA.get(string);
        if (schema == this.eZ) {
            this.t();
        }
        return schema;
    }

    public Setting findSetting(String string) {
        return (Setting)this.ft.get(string);
    }

    public User findUser(String string) {
        return (User)this.ff.get(string);
    }

    public UserDataType findUserDataType(String string) {
        return (UserDataType)this.eU.get(string);
    }

    public User getUser(String string) {
        User user = this.findUser(string);
        if (user == null) {
            throw DbException.get(90032, string);
        }
        return user;
    }

    public synchronized Session createSession(User user) {
        if (this.eM != null) {
            throw DbException.get(90135);
        }
        Session session = new Session(this, user, ++this.el);
        this.fC.add(session);
        this.eP.info("connecting session #{0} to {1}", session.getId(), this.et);
        if (this.fv != null) {
            this.fv.reset();
            this.fv = null;
        }
        return session;
    }

    public synchronized void removeSession(Session session) {
        if (session != null) {
            if (this.eM == session) {
                this.eM = null;
            }
            this.fC.remove(session);
            if (session != this.fx) {
                this.eP.info("disconnecting session #{0}", session.getId());
            }
        }
        if (this.fC.size() == 0 && session != this.fx) {
            if (this.ei == 0) {
                this.close(false);
            } else {
                if (this.ei < 0) {
                    return;
                }
                this.fv = new DatabaseCloser(this, this.ei * 1000, false);
                this.fv.setName("H2 Close Delay " + this.getShortName());
                this.fv.setDaemon(true);
                this.fv.start();
            }
        }
        if (session != this.fx && session != null) {
            this.eP.info("disconnected session #{0}", session.getId());
        }
    }

    private synchronized void if(Session session) {
        Session[] sessionArray = new Session[this.fC.size()];
        this.fC.toArray(sessionArray);
        for (Session session2 : sessionArray) {
            if (session2 == session) continue;
            try {
                session2.rollback();
                session2.close();
            }
            catch (DbException dbException) {
                this.eP.error(dbException, "disconnecting session #{0}", session2.getId());
            }
        }
    }

    synchronized void close(boolean bl) {
        if (this.e3) {
            return;
        }
        if (this.fc == 3 && !this.eO) {
            try {
                this.if(false);
            }
            catch (DbException dbException) {
                // empty catch block
            }
            this.eB.close();
            Engine.getInstance().close(this.et);
            return;
        }
        this.e3 = true;
        this.r();
        if (this.fC.size() > 0) {
            if (!bl) {
                return;
            }
            this.eP.info("closing {0} from shutdown hook", this.et);
            this.if(null);
        }
        this.eP.info("closing {0}", this.et);
        if (this.eN != null) {
            this.e3 = false;
            Iterator iterator = this.eN;
            this.eN = null;
            iterator.closingDatabase();
            if (this.fC.size() > 0) {
                return;
            }
            this.e3 = true;
        }
        try {
            if (this.fx != null) {
                SchemaObjectBase schemaObjectBase;
                if (this.eL != -1) {
                    for (Object object : this.getAllTablesAndViews(false)) {
                        if (((Table)object).isGlobalTemporary()) {
                            ((Table)object).removeChildrenAndResources(this.fx);
                            continue;
                        }
                        ((Table)object).close(this.fx);
                    }
                    for (Object object : this.getAllSchemaObjects(3)) {
                        schemaObjectBase = (Sequence)object;
                        ((Sequence)schemaObjectBase).close();
                    }
                }
                for (Object object : this.getAllSchemaObjects(4)) {
                    schemaObjectBase = (TriggerObject)object;
                    try {
                        ((TriggerObject)schemaObjectBase).close();
                    }
                    catch (SQLException sQLException) {
                        this.eP.error(sQLException, "close");
                    }
                }
                if (this.eL != -1) {
                    this.eG.close(this.fx);
                    this.fx.commit(true);
                }
            }
        }
        catch (DbException dbException) {
            this.eP.error(dbException, "close");
        }
        if (this.eF) {
            boolean bl2;
            boolean bl3 = bl2 = this.eZ.findTableOrView(this.fx, "LOB_DATA") != null;
            if (bl2) {
                try {
                    this.getLobStorage();
                    this.fu.removeAllForTable(-1);
                }
                catch (DbException dbException) {
                    this.eP.error(dbException, "close");
                }
            }
        }
        this.eQ.deleteAll();
        try {
            this.if(true);
        }
        catch (DbException dbException) {
            this.eP.error(dbException, "close");
        }
        this.eP.info("closed");
        this.eB.close();
        if (this.fp != null) {
            this.fp.reset();
            try {
                Runtime.getRuntime().removeShutdownHook(this.fp);
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            this.fp = null;
        }
        Engine.getInstance().close(this.et);
        if (this.e2 && this.eF) {
            this.e2 = false;
            try {
                Object object;
                String string = IOUtils.getParent(this.et);
                object = IOUtils.getFileName(this.et);
                DeleteDbFiles.execute(string, (String)object, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void q() {
        if (this.ez != null) {
            this.ez.stopThread();
            this.ez = null;
        }
    }

    private synchronized void if(boolean bl) {
        this.q();
        if (this.eg != null && bl) {
            try {
                this.eg.checkpoint();
                if (!this.fz) {
                    this.eg.compact(this.ey);
                }
            }
            catch (DbException dbException) {
                if (dbException.getErrorCode() != 90098 && SysProperties.CHECK2) {
                    dbException.printStackTrace();
                }
                this.eP.error(dbException, "close");
            }
            catch (Throwable throwable) {
                if (SysProperties.CHECK2) {
                    throwable.printStackTrace();
                }
                this.eP.error(throwable, "close");
            }
        }
        this.reconnectModified(false);
        this.v();
        if (this.eF && this.fk == null && this.fc != 0 && this.fc != 4) {
            return;
        }
        if (this.eF) {
            this.p();
        }
        if (this.fx != null) {
            this.fx.close();
            this.fx = null;
        }
        if (this.fk != null) {
            if (this.fc == 3) {
                try {
                    Thread.sleep((int)((double)this.eK * 1.1));
                }
                catch (InterruptedException interruptedException) {
                    this.eP.error(interruptedException, "close");
                }
            }
            this.fk.unlock();
            this.fk = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void v() {
        try {
            Database database = this;
            synchronized (database) {
                if (this.eg != null) {
                    this.eg.close();
                    this.eg = null;
                }
            }
        }
        catch (DbException dbException) {
            this.eP.error(dbException, "close");
        }
    }

    private void a(Session session, int n2) {
        SearchRow searchRow = this.eG.getTemplateSimpleRow(false);
        searchRow.setValue(0, ValueInt.get(n2));
        Cursor cursor = this.e5.find(session, searchRow, searchRow);
        if (cursor.next()) {
            DbException.throwInternalError();
        }
    }

    public synchronized int allocateObjectId() {
        int n2 = this.fq.nextClearBit(0);
        this.fq.set(n2);
        return n2;
    }

    public ArrayList getAllAggregates() {
        return New.arrayList(this.e1.values());
    }

    public ArrayList getAllComments() {
        return New.arrayList(this.e9.values());
    }

    public int getAllowLiterals() {
        if (this.fB) {
            return 2;
        }
        return this.e8;
    }

    public ArrayList getAllRights() {
        return New.arrayList(this.fD.values());
    }

    public ArrayList getAllRoles() {
        return New.arrayList(this.ek.values());
    }

    public ArrayList getAllSchemaObjects() {
        this.t();
        ArrayList arrayList = New.arrayList();
        for (Schema schema : this.eA.values()) {
            arrayList.addAll(schema.getAll());
        }
        return arrayList;
    }

    public ArrayList getAllSchemaObjects(int n2) {
        if (n2 == 0) {
            this.t();
        }
        ArrayList arrayList = New.arrayList();
        for (Schema schema : this.eA.values()) {
            arrayList.addAll(schema.getAll(n2));
        }
        return arrayList;
    }

    public ArrayList getAllTablesAndViews(boolean bl) {
        if (bl) {
            this.t();
        }
        ArrayList arrayList = New.arrayList();
        for (Schema schema : this.eA.values()) {
            arrayList.addAll(schema.getAllTablesAndViews());
        }
        return arrayList;
    }

    public ArrayList getAllSchemas() {
        this.t();
        return New.arrayList(this.eA.values());
    }

    public ArrayList getAllSettings() {
        return New.arrayList(this.ft.values());
    }

    public ArrayList getAllUserDataTypes() {
        return New.arrayList(this.eU.values());
    }

    public ArrayList getAllUsers() {
        return New.arrayList(this.ff.values());
    }

    public String getCacheType() {
        return this.fy;
    }

    public String getCluster() {
        return this.eT;
    }

    public CompareMode getCompareMode() {
        return this.eJ;
    }

    public String getDatabasePath() {
        if (this.eF) {
            return IOUtils.getAbsolutePath(this.et);
        }
        return null;
    }

    public String getShortName() {
        return this.eu;
    }

    public String getName() {
        return this.et;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session[] getSessions(boolean bl) {
        ArrayList arrayList;
        Object object = this.fC;
        synchronized (object) {
            arrayList = New.arrayList(this.fC);
        }
        object = this.fx;
        if (bl && object != null) {
            arrayList.add(object);
        }
        Session[] sessionArray = new Session[arrayList.size()];
        arrayList.toArray(sessionArray);
        return sessionArray;
    }

    public synchronized void update(Session session, DbObject dbObject) {
        int n2 = dbObject.getId();
        this.removeMeta(session, n2);
        this.a(session, dbObject);
    }

    public synchronized void renameSchemaObject(Session session, SchemaObject schemaObject, String string) {
        this.checkWritingAllowed();
        schemaObject.getSchema().rename(schemaObject, string);
        this.if(session, schemaObject);
    }

    private synchronized void if(Session session, DbObject dbObject) {
        ArrayList arrayList = dbObject.getChildren();
        Comment comment = this.findComment(dbObject);
        if (comment != null) {
            DbException.throwInternalError();
        }
        this.update(session, dbObject);
        if (arrayList != null) {
            for (DbObject dbObject2 : arrayList) {
                if (dbObject2.getCreateSQL() == null) continue;
                this.update(session, dbObject2);
            }
        }
    }

    public synchronized void renameDatabaseObject(Session session, DbObject dbObject, String string) {
        this.checkWritingAllowed();
        int n2 = dbObject.getType();
        HashMap hashMap = this.a(n2);
        if (SysProperties.CHECK) {
            if (!hashMap.containsKey(dbObject.getName())) {
                DbException.throwInternalError("not found: " + dbObject.getName());
            }
            if (dbObject.getName().equals(string) || hashMap.containsKey(string)) {
                DbException.throwInternalError("object already exists: " + string);
            }
        }
        dbObject.checkRename();
        int n3 = dbObject.getId();
        this.removeMeta(session, n3);
        hashMap.remove(dbObject.getName());
        dbObject.rename(string);
        hashMap.put(string, dbObject);
        this.if(session, dbObject);
    }

    public String createTempFile() {
        try {
            boolean bl = this.fz;
            String string = this.et;
            if (!this.eF) {
                string = "memFS:" + string;
            }
            return IOUtils.createTempFile(string, ".temp.db", true, bl);
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, this.et);
        }
    }

    private void p() {
        String[] stringArray;
        String string = IOUtils.getParent(this.et);
        for (String string2 : stringArray = IOUtils.listFiles(string)) {
            if (!string2.endsWith(".temp.db") || !IOUtils.fileStartsWith(string2, this.et)) continue;
            IOUtils.tryDelete(string2);
        }
    }

    public Schema getSchema(String string) {
        Schema schema = this.findSchema(string);
        if (schema == null) {
            throw DbException.get(90079, string);
        }
        return schema;
    }

    public synchronized void removeDatabaseObject(Session session, DbObject dbObject) {
        Comment comment;
        this.checkWritingAllowed();
        String string = dbObject.getName();
        int n2 = dbObject.getType();
        HashMap hashMap = this.a(n2);
        if (SysProperties.CHECK && !hashMap.containsKey(string)) {
            DbException.throwInternalError("not found: " + string);
        }
        if ((comment = this.findComment(dbObject)) != null) {
            this.removeDatabaseObject(session, comment);
        }
        int n3 = dbObject.getId();
        dbObject.removeChildrenAndResources(session);
        hashMap.remove(string);
        this.removeMeta(session, n3);
    }

    public Table getDependentTable(SchemaObject schemaObject, Table table) {
        switch (schemaObject.getType()) {
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 13: {
                return null;
            }
        }
        HashSet hashSet = New.hashSet();
        for (Table table2 : this.getAllTablesAndViews(false)) {
            if (table == table2) continue;
            hashSet.clear();
            table2.addDependencies(hashSet);
            if (!hashSet.contains(schemaObject)) continue;
            return table2;
        }
        return null;
    }

    public synchronized void removeSchemaObject(Session session, SchemaObject schemaObject) {
        Table table;
        DbObject dbObject;
        int n2 = schemaObject.getType();
        if (n2 == 0) {
            dbObject = (Table)schemaObject;
            if (dbObject.isTemporary() && !dbObject.isGlobalTemporary()) {
                session.removeLocalTempTable((Table)dbObject);
                return;
            }
        } else if (n2 == 1) {
            dbObject = (Index)schemaObject;
            table = dbObject.getTable();
            if (table.isTemporary() && !table.isGlobalTemporary()) {
                session.removeLocalTempTableIndex((Index)dbObject);
                return;
            }
        } else if (n2 == 5 && (table = ((Constraint)(dbObject = (Constraint)schemaObject)).getTable()).isTemporary() && !table.isGlobalTemporary()) {
            session.removeLocalTempTableConstraint((Constraint)dbObject);
            return;
        }
        this.checkWritingAllowed();
        dbObject = this.findComment(schemaObject);
        if (dbObject != null) {
            this.removeDatabaseObject(session, dbObject);
        }
        schemaObject.getSchema().remove(schemaObject);
        int n3 = schemaObject.getId();
        if (!this.fB) {
            Table table2 = this.getDependentTable(schemaObject, null);
            if (table2 != null) {
                schemaObject.getSchema().add(schemaObject);
                throw DbException.get(90107, schemaObject.getSQL(), table2.getSQL());
            }
            schemaObject.removeChildrenAndResources(session);
        }
        this.removeMeta(session, n3);
    }

    public boolean isPersistent() {
        return this.eF;
    }

    public TraceSystem getTraceSystem() {
        return this.eB;
    }

    public synchronized void setCacheSize(int n2) {
        if (this.fB) {
            int n3 = MathUtils.convertLongToInt(Utils.getMemoryMax()) / 2;
            n2 = Math.min(n2, n3);
        }
        this.fm = n2;
        if (this.eg != null) {
            this.eg.getCache().setMaxMemory(n2);
        }
    }

    public synchronized void setMasterUser(User user) {
        this.addDatabaseObject(this.fx, user);
        this.fx.commit(true);
    }

    public Role getPublicRole() {
        return this.fw;
    }

    public synchronized String getTempTableName(Session session) {
        String string;
        while (this.em.findTableOrView(session, string = "TEMP_TABLE_" + session.getId() + "_" + this.e6++) != null) {
        }
        return string;
    }

    public void setCompareMode(CompareMode compareMode) {
        this.eJ = compareMode;
    }

    public void setCluster(String string) {
        this.eT = string;
    }

    public void checkWritingAllowed() {
        if (this.fz) {
            throw DbException.get(90097);
        }
        if (this.fs) {
            throw DbException.get(90100);
        }
        if (this.fc == 3 && !this.eO) {
            throw DbException.get(90097);
        }
    }

    public boolean isReadOnly() {
        return this.fz;
    }

    public void setWriteDelay(int n2) {
        this.eV = n2;
        if (this.ez != null) {
            this.ez.setWriteDelay(n2);
            this.fl = this.eV < 5;
        }
    }

    public boolean getFlushOnEachCommit() {
        return this.fl;
    }

    public ArrayList getInDoubtTransactions() {
        return this.eg == null ? null : this.eg.getInDoubtTransactions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareCommit(Session session, String string) {
        if (this.fz) {
            return;
        }
        Database database = this;
        synchronized (database) {
            this.eg.prepareCommit(session, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Session session) {
        if (this.fz) {
            return;
        }
        Database database = this;
        synchronized (database) {
            if (this.eg != null) {
                this.eg.commit(session);
            }
            session.setAllCommitted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Database database = this;
        synchronized (database) {
            if (this.fz || this.eg == null) {
                return;
            }
            this.eg.flushLog();
        }
    }

    public void setEventListener(DatabaseEventListener databaseEventListener) {
        this.eN = databaseEventListener;
    }

    public void setEventListenerClass(String string) {
        if (string == null || string.length() == 0) {
            this.eN = null;
        } else {
            try {
                this.eN = (DatabaseEventListener)Utils.loadUserClass(string).newInstance();
                String string2 = this.fa;
                if (this.eD != null) {
                    string2 = string2 + ";CIPHER=" + this.eD;
                }
                this.eN.init(string2);
            }
            catch (Throwable throwable) {
                throw DbException.get(90099, throwable, string, throwable.toString());
            }
        }
    }

    public synchronized void freeUpDiskSpace() {
        if (this.eN != null) {
            this.eN.diskSpaceIsLow();
        }
    }

    public void setProgress(int n2, String string, int n3, int n4) {
        if (this.eN != null) {
            try {
                this.eN.setProgress(n2, string, n3, n4);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void exceptionThrown(SQLException sQLException, String string) {
        if (this.eN != null) {
            try {
                this.eN.exceptionThrown(sQLException, string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync() {
        Database database = this;
        synchronized (database) {
            if (this.fz || this.eg == null) {
                return;
            }
            this.eg.sync();
        }
    }

    public int getMaxMemoryRows() {
        return this.eR;
    }

    public void setMaxMemoryRows(int n2) {
        this.eR = n2;
    }

    public void setMaxMemoryUndo(int n2) {
        this.fj = n2;
    }

    public int getMaxMemoryUndo() {
        return this.fj;
    }

    public void setLockMode(int n2) {
        switch (n2) {
            case 0: {
                if (!this.er) break;
                throw DbException.get(90133, "LOCK_MODE=0 & MULTI_THREADED");
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw DbException.getInvalidValueException("lock mode", n2);
            }
        }
        this.fh = n2;
    }

    public int getLockMode() {
        return this.fh;
    }

    public synchronized void setCloseDelay(int n2) {
        this.ei = n2;
    }

    public Session getSystemSession() {
        return this.fx;
    }

    public boolean isClosing() {
        return this.e3;
    }

    public void setMaxLengthInplaceLob(int n2) {
        this.eo = n2;
    }

    public int getMaxLengthInplaceLob() {
        return this.eF ? this.eo : Integer.MAX_VALUE;
    }

    public void setIgnoreCase(boolean bl) {
        this.e4 = bl;
    }

    public boolean getIgnoreCase() {
        if (this.fB) {
            return false;
        }
        return this.e4;
    }

    public synchronized void setDeleteFilesOnDisconnect(boolean bl) {
        this.e2 = bl;
    }

    public String getLobCompressionAlgorithm(int n2) {
        return this.eI;
    }

    public void setLobCompressionAlgorithm(String string) {
        this.eI = string;
    }

    public synchronized void setMaxLogSize(long l2) {
        if (this.eg != null) {
            this.eg.setMaxLogSize(l2);
        }
    }

    public void setAllowLiterals(int n2) {
        this.e8 = n2;
    }

    public boolean getOptimizeReuseResults() {
        return this.ep;
    }

    public void setOptimizeReuseResults(boolean bl) {
        this.ep = bl;
    }

    public Object getLobSyncObject() {
        return this.eh;
    }

    public int getSessionCount() {
        return this.fC.size();
    }

    public void setReferentialIntegrity(boolean bl) {
        this.fi = bl;
    }

    public boolean getReferentialIntegrity() {
        return this.fi;
    }

    public boolean isStarting() {
        return this.fB;
    }

    public boolean isMultiVersion() {
        return this.fo;
    }

    public void opened() {
        if (this.eN != null) {
            this.eN.opened();
        }
        if (this.ez != null) {
            this.ez.startThread();
        }
    }

    public void setMode(Mode mode) {
        this.e7 = mode;
    }

    public Mode getMode() {
        return this.e7;
    }

    public boolean isMultiThreaded() {
        return this.er;
    }

    public void setMultiThreaded(boolean bl) {
        if (bl && this.fo && this.er != bl) {
            throw DbException.get(90133, "MVCC & MULTI_THREADED");
        }
        this.er = bl;
    }

    public void setMaxOperationMemory(int n2) {
        this.eH = n2;
    }

    public int getMaxOperationMemory() {
        return this.eH;
    }

    public Session getExclusiveSession() {
        return this.eM;
    }

    public void setExclusiveSession(Session session, boolean bl) {
        this.eM = session;
        if (bl) {
            this.if(session);
        }
    }

    public SmallLRUCache getLobFileListCache() {
        if (this.en == null) {
            this.en = SmallLRUCache.newInstance(128);
        }
        return this.en;
    }

    public boolean isSysTableLocked() {
        return this.eG == null || this.eG.isLockedExclusively();
    }

    public TableLinkConnection getLinkConnection(String string, String string2, String string3, String string4) {
        if (this.ej == null) {
            this.ej = New.hashMap();
        }
        return TableLinkConnection.open(this.ej, string, string2, string3, string4, this.fd.shareLinkedConnections);
    }

    public String toString() {
        return this.eu + ":" + super.toString();
    }

    public void shutdownImmediately() {
        this.setPowerOffCount(1);
        try {
            this.checkPowerOff();
        }
        catch (DbException dbException) {
            // empty catch block
        }
        this.v();
    }

    public TempFileDeleter getTempFileDeleter() {
        return this.eQ;
    }

    public PageStore getPageStore() {
        if (this.eg == null) {
            this.eg = new PageStore(this, this.et + ".h2.db", this.es, this.fm);
            if (this.eX != 2048) {
                this.eg.setPageSize(this.eX);
            }
            if (!this.fz && this.fc == 4) {
                this.eg.setLockFile(true);
            }
            this.eg.open();
        }
        return this.eg;
    }

    public Table getFirstUserTable() {
        for (Table table : this.getAllTablesAndViews(false)) {
            if (table.getCreateSQL() == null || table.isHidden()) continue;
            return table;
        }
        return null;
    }

    public boolean isReconnectNeeded() {
        if (this.fc != 3) {
            return false;
        }
        if (this.eO) {
            return false;
        }
        long l2 = System.currentTimeMillis();
        if (l2 < this.eW) {
            return false;
        }
        this.eW = l2 + (long)this.eK;
        if (this.fk == null) {
            this.fk = new FileLock(this.eB, this.et + ".lock.db", 1000);
        }
        try {
            Properties properties;
            Properties properties2 = properties = this.fk.load();
            while (true) {
                if (properties.equals(this.fr)) {
                    return false;
                }
                if (properties.getProperty("changePending", null) == null) break;
                if (System.currentTimeMillis() > l2 + (long)(this.eK * 10) && properties2.equals(properties)) {
                    this.fk.setProperty("changePending", null);
                    this.fk.save();
                    break;
                }
                this.eP.debug("delay (change pending)");
                Thread.sleep(this.eK);
                properties = this.fk.load();
            }
            this.fr = properties;
        }
        catch (Exception exception) {
            this.eP.error(exception, "readOnly {0}", this.fz);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkpointIfRequired() {
        if (this.fc != 3 || this.fz || !this.eO || this.e3) {
            return;
        }
        long l2 = System.currentTimeMillis();
        if (l2 > this.eW + (long)this.eK) {
            if (SysProperties.CHECK && this.e0 < 0) {
                DbException.throwInternalError();
            }
            Object object = this.eY;
            synchronized (object) {
                if (this.e0 > 0) {
                    return;
                }
                this.eS = true;
            }
            object = this;
            synchronized (object) {
                this.eP.debug("checkpoint start");
                this.s();
                this.checkpoint();
                this.reconnectModified(false);
                this.eP.debug("checkpoint end");
            }
            object = this.eY;
            synchronized (object) {
                this.eS = false;
            }
        }
    }

    public boolean isFileLockSerialized() {
        return this.fc == 3;
    }

    private void s() {
        for (SchemaObject schemaObject : this.getAllSchemaObjects(3)) {
            Sequence sequence = (Sequence)schemaObject;
            sequence.flushWithoutMargin();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkpoint() {
        if (this.eF) {
            Database database = this;
            synchronized (database) {
                if (this.eg != null) {
                    this.eg.checkpoint();
                }
            }
        }
        this.getTempFileDeleter().deleteUnused();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean beforeWriting() {
        if (this.fc != 3) {
            return true;
        }
        while (this.eS) {
            try {
                Thread.sleep(10 + (int)(Math.random() * 10.0));
            }
            catch (Exception exception) {}
        }
        Object object = this.eY;
        synchronized (object) {
            if (this.reconnectModified(true)) {
                ++this.e0;
                if (SysProperties.CHECK && this.e0 > 20) {
                    throw DbException.throwInternalError();
                }
                return true;
            }
        }
        this.eW = System.currentTimeMillis() - 1L;
        this.fr = null;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterWriting() {
        if (this.fc != 3) {
            return;
        }
        Object object = this.eY;
        synchronized (object) {
            --this.e0;
        }
        if (SysProperties.CHECK && this.e0 < 0) {
            throw DbException.throwInternalError();
        }
    }

    public void setReadOnly(boolean bl) {
        this.fz = bl;
    }

    public void setCompactMode(int n2) {
        this.ey = n2;
    }

    public SourceCompiler getCompiler() {
        if (this.fe == null) {
            this.fe = new SourceCompiler();
        }
        return this.fe;
    }

    public LobStorage getLobStorage() {
        if (this.fu == null) {
            this.fu = new LobStorage(this);
        }
        return this.fu;
    }

    public Connection getLobConnection() {
        String string = "jdbc:default:connection";
        JdbcConnection jdbcConnection = new JdbcConnection(this.fx, this.eC.getName(), string);
        jdbcConnection.setTraceLevel(0);
        return jdbcConnection;
    }

    public void setLogMode(int n2) {
        if (n2 < 0 || n2 > 2) {
            throw DbException.getInvalidValueException("LOG", n2);
        }
        if (this.eg != null) {
            if (n2 != 2 || this.eg.getLogMode() != 2) {
                this.eP.error(null, "log {0}", n2);
            }
            this.eg.setLogMode(n2);
        }
    }

    public int getLogMode() {
        if (this.eg != null) {
            return this.eg.getLogMode();
        }
        return 0;
    }

    public int getDefaultTableType() {
        return this.fg;
    }

    public void setDefaultTableType(int n2) {
        this.fg = n2;
    }

    public void setMultiVersion(boolean bl) {
        this.fo = bl;
    }

    public DbSettings getSettings() {
        return this.fd;
    }
}

