/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.util.HashMap;
import org.h2.command.CommandInterface;
import org.h2.command.Parser;
import org.h2.constant.DbSettings;
import org.h2.constant.SysProperties;
import org.h2.engine.ConnectionInfo;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.engine.SessionFactory;
import org.h2.engine.User;
import org.h2.message.DbException;
import org.h2.store.FileLock;
import org.h2.util.MathUtils;
import org.h2.util.New;
import org.h2.util.StringUtils;
import org.h2.util.Utils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Engine
implements SessionFactory {
    private static final Engine do = new Engine();
    private final HashMap if = New.hashMap();
    private volatile long for = SysProperties.DELAY_WRONG_PASSWORD_MIN;
    private boolean a;

    public static Engine getInstance() {
        return do;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Session a(ConnectionInfo connectionInfo, boolean bl, String string) {
        String string2 = connectionInfo.getName();
        boolean bl2 = connectionInfo.getProperty("OPEN_NEW", false);
        Database database = bl2 || connectionInfo.isUnnamedInMemory() ? null : (Database)this.if.get(string2);
        User user = null;
        boolean bl3 = false;
        if (database == null) {
            if (bl && !Database.exists(string2)) {
                throw DbException.get(90013, string2);
            }
            database = new Database(connectionInfo, string);
            bl3 = true;
            if (database.getAllUsers().size() == 0) {
                user = new User(database, database.allocateObjectId(), connectionInfo.getUserName(), false);
                user.setAdmin(true);
                user.setUserPasswordHash(connectionInfo.getUserPasswordHash());
                database.setMasterUser(user);
            }
            if (!connectionInfo.isUnnamedInMemory()) {
                this.if.put(string2, database);
            }
        }
        Database database2 = database;
        synchronized (database2) {
            if (bl3) {
                database.opened();
            }
            if (database.isClosing()) {
                return null;
            }
            if (user == null) {
                if (database.validateFilePasswordHash(string, connectionInfo.getFilePasswordHash()) && (user = database.findUser(connectionInfo.getUserName())) != null && !user.validateUserPasswordHash(connectionInfo.getUserPasswordHash())) {
                    user = null;
                }
                if (bl3 && (user == null || !user.isAdmin())) {
                    database.setEventListener(null);
                }
            }
            if (user == null) {
                database.removeSession(null);
                throw DbException.get(8004);
            }
            this.a(connectionInfo, database);
            Session session = database.createSession(user);
            if (connectionInfo.getProperty("JMX", false)) {
                try {
                    Utils.callStaticMethod("org.h2.jmx.DatabaseInfo.registerMBean", connectionInfo, database);
                }
                catch (Exception exception) {
                    database.removeSession(session);
                    throw DbException.get(50100, exception, "JMX");
                }
                this.a = true;
            }
            return session;
        }
    }

    public Session createSession(ConnectionInfo connectionInfo) {
        return do.a(connectionInfo);
    }

    private Session a(ConnectionInfo connectionInfo) {
        try {
            ConnectionInfo connectionInfo2 = null;
            String string = connectionInfo.getProperty("FILE_LOCK", null);
            int n2 = FileLock.getFileLockMethod(string);
            if (n2 == 3) {
                connectionInfo.setProperty("OPEN_NEW", "TRUE");
                try {
                    connectionInfo2 = (ConnectionInfo)connectionInfo.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    throw DbException.convert(cloneNotSupportedException);
                }
            }
            Session session = this.if(connectionInfo);
            this.a(true);
            if (connectionInfo2 != null) {
                session.setConnectionInfo(connectionInfo2);
            }
            return session;
        }
        catch (DbException dbException) {
            if (dbException.getErrorCode() == 8004) {
                this.a(false);
            }
            throw dbException;
        }
    }

    private synchronized Session if(ConnectionInfo connectionInfo) {
        Session session;
        block9: {
            boolean bl = connectionInfo.removeProperty("IFEXISTS", false);
            boolean bl2 = connectionInfo.removeProperty("IGNORE_UNKNOWN_SETTINGS", false);
            String string = connectionInfo.removeProperty("CIPHER", null);
            String string2 = connectionInfo.removeProperty("INIT", null);
            while ((session = this.a(connectionInfo, bl, string)) == null) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
            session.setAllowLiterals(true);
            DbSettings dbSettings = DbSettings.getInstance(null);
            for (String string3 : connectionInfo.getKeys()) {
                if (dbSettings.containsKey(string3)) continue;
                String string4 = connectionInfo.getProperty(string3);
                try {
                    CommandInterface commandInterface = session.prepareCommand("SET " + Parser.quoteIdentifier(string3) + " " + string4, Integer.MAX_VALUE);
                    commandInterface.executeUpdate();
                }
                catch (DbException dbException) {
                    if (bl2) continue;
                    session.close();
                    throw dbException;
                }
            }
            if (string2 != null) {
                try {
                    CommandInterface commandInterface = session.prepareCommand(string2, Integer.MAX_VALUE);
                    commandInterface.executeUpdate();
                }
                catch (DbException dbException) {
                    if (bl2) break block9;
                    session.close();
                    throw dbException;
                }
            }
        }
        session.setAllowLiterals(false);
        session.commit(true);
        return session;
    }

    private void a(ConnectionInfo connectionInfo, Database database) {
        String string = connectionInfo.getProperty(13, null);
        if ("''".equals(string)) {
            return;
        }
        String string2 = database.getCluster();
        if (!("''".equals(string2) || "TRUE".equals(string) || StringUtils.equals(string, string2))) {
            if (string2.equals("''")) {
                throw DbException.get(90093);
            }
            throw DbException.get(90094, string2);
        }
    }

    public void close(String string) {
        if (this.a) {
            try {
                Utils.callStaticMethod("org.h2.jmx.DatabaseInfo.unregisterMBean", string);
            }
            catch (Exception exception) {
                throw DbException.get(50100, exception, "JMX");
            }
        }
        this.if.remove(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(boolean bl) {
        int n2 = SysProperties.DELAY_WRONG_PASSWORD_MIN;
        if (bl) {
            long l2 = this.for;
            if (l2 > (long)n2 && l2 > 0L) {
                Engine engine = do;
                synchronized (engine) {
                    l2 = MathUtils.secureRandomInt((int)l2);
                    try {
                        Thread.sleep(l2);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.for = n2;
                }
            }
        } else {
            Engine engine = do;
            synchronized (engine) {
                long l3 = this.for;
                int n3 = SysProperties.DELAY_WRONG_PASSWORD_MAX;
                if (n3 <= 0) {
                    n3 = Integer.MAX_VALUE;
                }
                this.for += this.for;
                if (this.for > (long)n3 || this.for < 0L) {
                    this.for = n3;
                }
                if (n2 > 0) {
                    l3 += Math.abs(MathUtils.secureRandomLong() % 100L);
                    try {
                        Thread.sleep(l3);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                throw DbException.get(8004);
            }
        }
    }
}

