/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import org.h2.command.Parser;
import org.h2.constant.SysProperties;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObjectBase;
import org.h2.table.Table;
import org.h2.util.New;
import org.h2.util.SourceCompiler;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FunctionAlias
extends SchemaObjectBase {
    private String bV;
    private String bU;
    private String bY;
    private JavaMethod[] bX;
    private boolean bW;

    private FunctionAlias(Schema schema, int n2, String string) {
        this.initSchemaObjectBase(schema, n2, string, "function");
    }

    public static FunctionAlias newInstance(Schema schema, int n2, String string, String string2, boolean bl) {
        FunctionAlias functionAlias = new FunctionAlias(schema, n2, string);
        int n3 = string2.indexOf(40);
        int n4 = string2.lastIndexOf(46, n3 < 0 ? string2.length() : n3);
        if (n4 < 0) {
            throw DbException.get(42000, string2);
        }
        functionAlias.bV = string2.substring(0, n4);
        functionAlias.bU = string2.substring(n4 + 1);
        functionAlias.a(bl);
        return functionAlias;
    }

    public static FunctionAlias newInstanceFromSource(Schema schema, int n2, String string, String string2, boolean bl) {
        FunctionAlias functionAlias = new FunctionAlias(schema, n2, string);
        functionAlias.bY = string2;
        functionAlias.a(bl);
        return functionAlias;
    }

    private void a(boolean bl) {
        block2: {
            try {
                this.goto();
            }
            catch (DbException dbException) {
                if (bl) break block2;
                throw dbException;
            }
        }
    }

    private synchronized void goto() {
        if (this.bX != null) {
            return;
        }
        if (this.bY != null) {
            this.void();
        } else {
            this.long();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void void() {
        SourceCompiler sourceCompiler;
        SourceCompiler sourceCompiler2 = sourceCompiler = this.database.getCompiler();
        synchronized (sourceCompiler2) {
            String string = "org.h2.dynamic." + this.getName();
            sourceCompiler.setSource(string, this.bY);
            try {
                Method method = sourceCompiler.getMethod(string);
                JavaMethod javaMethod = new JavaMethod(method, 0);
                this.bX = new JavaMethod[]{javaMethod};
            }
            catch (DbException dbException) {
                throw dbException;
            }
            catch (Exception exception) {
                throw DbException.get(42000, exception, this.bY);
            }
        }
    }

    private void long() {
        Class clazz = Utils.loadUserClass(this.bV);
        Method[] methodArray = clazz.getMethods();
        ArrayList arrayList = New.arrayList();
        int n2 = methodArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Method method = methodArray[i2];
            if (!Modifier.isStatic(method.getModifiers()) || !method.getName().equals(this.bU) && !this.a(method).equals(this.bU)) continue;
            JavaMethod javaMethod = new JavaMethod(method, i2);
            for (JavaMethod javaMethod2 : arrayList) {
                if (javaMethod2.getParameterCount() != javaMethod.getParameterCount()) continue;
                throw DbException.get(90073, javaMethod2.toString(), javaMethod.toString());
            }
            arrayList.add(javaMethod);
        }
        if (arrayList.size() == 0) {
            throw DbException.get(90139, this.bU + " (" + this.bV + ")");
        }
        this.bX = new JavaMethod[arrayList.size()];
        arrayList.toArray(this.bX);
        Arrays.sort(this.bX);
    }

    private String a(Method method) {
        StatementBuilder statementBuilder = new StatementBuilder(method.getName());
        statementBuilder.append('(');
        for (Class<?> clazz : method.getParameterTypes()) {
            statementBuilder.appendExceptFirst(",");
            if (clazz.isArray()) {
                statementBuilder.append(clazz.getComponentType().getName()).append("[]");
                continue;
            }
            statementBuilder.append(clazz.getName());
        }
        return statementBuilder.append(')').toString();
    }

    public String getCreateSQLForCopy(Table table, String string) {
        throw DbException.throwInternalError();
    }

    public String getDropSQL() {
        return "DROP ALIAS IF EXISTS " + this.getSQL();
    }

    public String getSQL() {
        if (this.database.getSettings().functionsInSchema || !this.getSchema().getName().equals("PUBLIC")) {
            return super.getSQL();
        }
        return Parser.quoteIdentifier(this.getName());
    }

    public String getCreateSQL() {
        StringBuilder stringBuilder = new StringBuilder("CREATE FORCE ALIAS ");
        stringBuilder.append(this.getSQL());
        if (this.bW) {
            stringBuilder.append(" DETERMINISTIC");
        }
        if (this.bY != null) {
            stringBuilder.append(" AS ").append(StringUtils.quoteStringSQL(this.bY));
        } else {
            stringBuilder.append(" FOR ").append(Parser.quoteIdentifier(this.bV + "." + this.bU));
        }
        return stringBuilder.toString();
    }

    public int getType() {
        return 9;
    }

    public synchronized void removeChildrenAndResources(Session session) {
        this.database.removeMeta(session, this.getId());
        this.bV = null;
        this.bU = null;
        this.bX = null;
        this.invalidate();
    }

    public void checkRename() {
        throw DbException.getUnsupportedException("RENAME");
    }

    public JavaMethod findJavaMethod(Expression[] expressionArray) {
        this.goto();
        int n2 = expressionArray.length;
        for (JavaMethod javaMethod : this.bX) {
            int n3 = javaMethod.getParameterCount();
            if (n3 != n2 && (!javaMethod.isVarArgs() || n3 > n2 + 1)) continue;
            return javaMethod;
        }
        throw DbException.get(90087, this.bU + " (" + this.bV + ", parameter count: " + n2 + ")");
    }

    public String getJavaClassName() {
        return this.bV;
    }

    public String getJavaMethodName() {
        return this.bU;
    }

    public JavaMethod[] getJavaMethods() {
        this.goto();
        return this.bX;
    }

    public void setDeterministic(boolean bl) {
        this.bW = bl;
    }

    public boolean isDeterministic() {
        return this.bW;
    }

    public String getSource() {
        return this.bY;
    }

    static boolean isVarArgs(Method method) {
        if ("1.5".compareTo(SysProperties.JAVA_SPECIFICATION_VERSION) > 0) {
            return false;
        }
        try {
            Method method2 = method.getClass().getMethod("isVarArgs", new Class[0]);
            Boolean bl = (Boolean)method2.invoke((Object)method, new Object[0]);
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class JavaMethod
    implements Comparable {
        private final int try;
        private final Method new;
        private final int a;
        private boolean if;
        private boolean int;
        private Class for;
        private int do;

        JavaMethod(Method method, int n2) {
            Class<?> clazz;
            this.new = method;
            this.try = n2;
            Class<?>[] classArray = method.getParameterTypes();
            this.do = classArray.length;
            if (this.do > 0 && Connection.class.isAssignableFrom(clazz = classArray[0])) {
                this.if = true;
                --this.do;
            }
            if (this.do > 0 && (clazz = classArray[classArray.length - 1]).isArray() && FunctionAlias.isVarArgs(method)) {
                this.int = true;
                this.for = clazz.getComponentType();
            }
            clazz = method.getReturnType();
            this.a = DataType.getTypeFromClass(clazz);
        }

        public String toString() {
            return this.new.toString();
        }

        public boolean hasConnectionParam() {
            return this.if;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Value getValue(Session session, Expression[] expressionArray, boolean bl) {
            Class<?> clazz;
            int n2;
            Class<?>[] classArray = this.new.getParameterTypes();
            Object[] objectArray = new Object[classArray.length];
            int n3 = 0;
            if (this.if && objectArray.length > 0) {
                objectArray[n3++] = session.createConnection(bl);
            }
            Object object = null;
            if (this.int) {
                n2 = expressionArray.length - objectArray.length + 1 + (this.if ? 1 : 0);
                objectArray[objectArray.length - 1] = object = Array.newInstance(this.for, n2);
            }
            n2 = 0;
            int n4 = expressionArray.length;
            while (n2 < n4) {
                boolean bl2 = this.int && n3 >= classArray.length - 1;
                clazz = bl2 ? this.for : classArray[n3];
                int n5 = DataType.getTypeFromClass(clazz);
                Object[] objectArray2 = expressionArray[n2].getValue(session);
                Object object2 = (objectArray2 = objectArray2.convertTo(n5)).getObject();
                if (object2 == null) {
                    if (clazz.isPrimitive()) {
                        if (!bl) return ValueNull.INSTANCE;
                        object2 = DataType.getDefaultForPrimitiveType(clazz);
                    }
                } else if (!clazz.isAssignableFrom(object2.getClass()) && !clazz.isPrimitive()) {
                    object2 = DataType.convertTo(session, session.createConnection(false), (Value)objectArray2, clazz);
                }
                if (bl2) {
                    Array.set(object, n3 - objectArray.length + 1, object2);
                } else {
                    objectArray[n3] = object2;
                }
                ++n2;
                ++n3;
            }
            n2 = session.getAutoCommit() ? 1 : 0;
            Value value = session.getScopeIdentity();
            try {
                Object object3;
                session.setAutoCommit(false);
                try {
                    object3 = this.new.invoke(null, objectArray);
                    if (object3 == null) {
                        clazz = ValueNull.INSTANCE;
                        return clazz;
                    }
                }
                catch (InvocationTargetException invocationTargetException) {
                    StatementBuilder statementBuilder = new StatementBuilder(this.new.getName());
                    statementBuilder.append('(');
                    for (Object object4 : objectArray) {
                        statementBuilder.appendExceptFirst(", ");
                        statementBuilder.append(object4 == null ? "null" : object4.toString());
                    }
                    statementBuilder.append(')');
                    throw DbException.convertInvocation(invocationTargetException, statementBuilder.toString());
                }
                catch (Exception exception) {
                    throw DbException.convert(exception);
                }
                clazz = DataType.convertToValue(session, object3, this.a);
                Value value2 = ((Value)((Object)clazz)).convertTo(this.a);
                return value2;
            }
            finally {
                session.setScopeIdentity(value);
                session.setAutoCommit(n2 != 0);
            }
        }

        public Class[] getColumnClasses() {
            return this.new.getParameterTypes();
        }

        public int getDataType() {
            return this.a;
        }

        public int getParameterCount() {
            return this.do;
        }

        public boolean isVarArgs() {
            return this.int;
        }

        public int compareTo(JavaMethod javaMethod) {
            if (this.int != javaMethod.int) {
                return this.int ? 1 : -1;
            }
            if (this.do != javaMethod.do) {
                return this.do - javaMethod.do;
            }
            if (this.if != javaMethod.if) {
                return this.if ? 1 : -1;
            }
            return this.try - javaMethod.try;
        }
    }
}

