/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.sql.SQLException;
import org.h2.api.DatabaseEventListener;
import org.h2.command.Prepared;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.result.SearchRow;
import org.h2.value.ValueInt;
import org.h2.value.ValueString;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MetaRecord
implements Comparable {
    private int do;
    private int a;
    private String if;

    public MetaRecord(SearchRow searchRow) {
        this.do = searchRow.getValue(0).getInt();
        this.a = searchRow.getValue(2).getInt();
        this.if = searchRow.getValue(3).getString();
    }

    MetaRecord(DbObject dbObject) {
        this.do = dbObject.getId();
        this.a = dbObject.getType();
        this.if = dbObject.getCreateSQL();
    }

    void setRecord(SearchRow searchRow) {
        searchRow.setValue(0, ValueInt.get(this.do));
        searchRow.setValue(1, ValueInt.get(0));
        searchRow.setValue(2, ValueInt.get(this.a));
        searchRow.setValue(3, ValueString.get(this.if));
    }

    void execute(Database database, Session session, DatabaseEventListener databaseEventListener) {
        try {
            Prepared prepared = session.prepare(this.if);
            prepared.setObjectId(this.do);
            prepared.update();
        }
        catch (DbException dbException) {
            DbException dbException2 = dbException.addSQL(this.if);
            SQLException sQLException = dbException2.getSQLException();
            database.getTrace("database").error(sQLException, this.if);
            if (databaseEventListener != null) {
                databaseEventListener.exceptionThrown(sQLException, this.if);
            }
            throw dbException2;
        }
    }

    public int getId() {
        return this.do;
    }

    public int getObjectType() {
        return this.a;
    }

    public String getSQL() {
        return this.if;
    }

    public int compareTo(MetaRecord metaRecord) {
        int n2;
        int n3 = this.a(this.getObjectType());
        if (n3 != (n2 = this.a(metaRecord.getObjectType()))) {
            return n3 - n2;
        }
        return this.getId() - metaRecord.getId();
    }

    private int a(int n2) {
        switch (n2) {
            case 6: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 10: {
                return 2;
            }
            case 9: {
                return 3;
            }
            case 12: {
                return 4;
            }
            case 3: {
                return 5;
            }
            case 11: {
                return 6;
            }
            case 0: {
                return 7;
            }
            case 1: {
                return 8;
            }
            case 5: {
                return 9;
            }
            case 4: {
                return 10;
            }
            case 7: {
                return 11;
            }
            case 8: {
                return 12;
            }
            case 14: {
                return 13;
            }
            case 13: {
                return 14;
            }
        }
        throw DbException.throwInternalError("type=" + n2);
    }
}

