/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.util.HashMap;
import org.h2.engine.Database;
import org.h2.engine.DbObjectBase;
import org.h2.engine.Right;
import org.h2.engine.Role;
import org.h2.table.Table;
import org.h2.util.New;

public abstract class RightOwner
extends DbObjectBase {
    private HashMap s;
    private HashMap t;

    protected RightOwner(Database database, int n2, String string, String string2) {
        this.initDbObjectBase(database, n2, string, string2);
    }

    public boolean isRoleGranted(Role role) {
        if (role == this) {
            return true;
        }
        if (this.s != null) {
            for (Role role2 : this.s.keySet()) {
                if (role2 == role) {
                    return true;
                }
                if (!role2.isRoleGranted(role)) continue;
                return true;
            }
        }
        return false;
    }

    boolean isRightGrantedRecursive(Table table, int n2) {
        Right right;
        if (this.t != null && (right = (Right)this.t.get(table)) != null && (right.getRightMask() & n2) == n2) {
            return true;
        }
        if (this.s != null) {
            for (Role role : this.s.keySet()) {
                if (!role.isRightGrantedRecursive(table, n2)) continue;
                return true;
            }
        }
        return false;
    }

    public void grantRight(Table table, Right right) {
        if (this.t == null) {
            this.t = New.hashMap();
        }
        this.t.put(table, right);
    }

    public void revokeRight(Table table) {
        if (this.t == null) {
            return;
        }
        this.t.remove(table);
        if (this.t.size() == 0) {
            this.t = null;
        }
    }

    public void grantRole(Role role, Right right) {
        if (this.s == null) {
            this.s = New.hashMap();
        }
        this.s.put(role, right);
    }

    public void revokeRole(Role role) {
        if (this.s == null) {
            return;
        }
        Right right = (Right)this.s.get(role);
        if (right == null) {
            return;
        }
        this.s.remove(role);
        if (this.s.size() == 0) {
            this.s = null;
        }
    }

    public Right getRightForTable(Table table) {
        if (this.t == null) {
            return null;
        }
        return (Right)this.t.get(table);
    }

    public Right getRightForRole(Role role) {
        if (this.s == null) {
            return null;
        }
        return (Right)this.s.get(role);
    }
}

