/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import org.h2.command.Command;
import org.h2.command.CommandInterface;
import org.h2.command.Parser;
import org.h2.command.Prepared;
import org.h2.command.dml.SetTypes;
import org.h2.constant.SysProperties;
import org.h2.constraint.Constraint;
import org.h2.engine.ConnectionInfo;
import org.h2.engine.Database;
import org.h2.engine.Engine;
import org.h2.engine.Procedure;
import org.h2.engine.SessionInterface;
import org.h2.engine.SessionWithState;
import org.h2.engine.Setting;
import org.h2.engine.UndoLog;
import org.h2.engine.UndoLogRecord;
import org.h2.engine.User;
import org.h2.index.Index;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.DbException;
import org.h2.message.Trace;
import org.h2.message.TraceSystem;
import org.h2.result.ResultInterface;
import org.h2.result.Row;
import org.h2.schema.Schema;
import org.h2.store.DataHandler;
import org.h2.store.InDoubtTransaction;
import org.h2.table.Table;
import org.h2.util.New;
import org.h2.util.SmallLRUCache;
import org.h2.value.Value;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueString;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Session
extends SessionWithState {
    public static final int LOG_WRITTEN = -1;
    private static final String gs = "_";
    private static int fG;
    private final int gn = fG++;
    private Database go;
    private ConnectionInfo gj;
    private User gc;
    private int gh;
    private ArrayList f3 = New.arrayList();
    private UndoLog fM;
    private boolean fP = true;
    private Random f9;
    private int gd;
    private Value fQ = ValueLong.get(0L);
    private Value fJ = ValueLong.get(0L);
    private int gp = -1;
    private int fW = -1;
    private HashMap f2;
    private Exception gq = new Exception();
    private HashMap f8;
    private HashMap fV;
    private HashMap fS;
    private int gg;
    private long fF;
    private Command gb;
    private boolean ge;
    private String gi;
    private String[] fU;
    private Trace f6;
    private HashMap f4;
    private int f0;
    private HashMap fR;
    private boolean fI = true;
    private boolean fN = true;
    private boolean gf;
    private String f1;
    private volatile long fO;
    private boolean gm;
    private long f5 = System.currentTimeMillis();
    private long f7;
    private HashMap fX;
    private HashSet fZ;
    private int gl;
    private boolean fL;
    private Table fK;
    private int fH;
    private int gk;
    private int fY;
    private final int fT;
    private SmallLRUCache gr;
    private Connection ga = null;

    public Session(Database database, User user, int n2) {
        this.go = database;
        this.gl = database.getSettings().maxQueryTimeout;
        this.fT = database.getSettings().queryCacheSize;
        this.fM = new UndoLog(this);
        this.gc = user;
        this.gh = n2;
        Setting setting = database.findSetting(SetTypes.getTypeName(6));
        this.gd = setting == null ? 2000 : setting.getIntValue();
        this.gi = "PUBLIC";
    }

    public boolean setCommitOrRollbackDisabled(boolean bl) {
        boolean bl2 = this.fL;
        this.fL = bl;
        return bl2;
    }

    private void w() {
        if (this.fX == null) {
            this.fX = New.hashMap();
        }
    }

    public void setWrapperConnection(Connection connection) {
        this.ga = connection;
    }

    public Connection getWrapperConnection() {
        return this.ga;
    }

    public void clearWrapperConnection() {
        this.ga = null;
    }

    public void setVariable(String string, Value value) {
        Value value2;
        this.w();
        ++this.fH;
        if (value == ValueNull.INSTANCE) {
            value2 = (Value)this.fX.remove(string);
        } else {
            value = value.link(this.go, -1);
            value2 = this.fX.put(string, value);
        }
        if (value2 != null) {
            value2.unlink();
            value2.close();
        }
    }

    public Value getVariable(String string) {
        this.w();
        Value value = (Value)this.fX.get(string);
        return value == null ? ValueNull.INSTANCE : value;
    }

    public String[] getVariableNames() {
        if (this.fX == null) {
            return new String[0];
        }
        String[] stringArray = new String[this.fX.size()];
        this.fX.keySet().toArray(stringArray);
        return stringArray;
    }

    public Table findLocalTempTable(String string) {
        if (this.f8 == null) {
            return null;
        }
        return (Table)this.f8.get(string);
    }

    public ArrayList getLocalTempTables() {
        if (this.f8 == null) {
            return New.arrayList();
        }
        return New.arrayList(this.f8.values());
    }

    public void addLocalTempTable(Table table) {
        if (this.f8 == null) {
            this.f8 = New.hashMap();
        }
        if (this.f8.get(table.getName()) != null) {
            throw DbException.get(42101, table.getSQL());
        }
        ++this.fH;
        this.f8.put(table.getName(), table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocalTempTable(Table table) {
        ++this.fH;
        this.f8.remove(table.getName());
        Database database = this.go;
        synchronized (database) {
            table.removeChildrenAndResources(this);
        }
    }

    public Index findLocalTempTableIndex(String string) {
        if (this.fV == null) {
            return null;
        }
        return (Index)this.fV.get(string);
    }

    public HashMap getLocalTempTableIndexes() {
        if (this.fV == null) {
            return New.hashMap();
        }
        return this.fV;
    }

    public void addLocalTempTableIndex(Index index) {
        if (this.fV == null) {
            this.fV = New.hashMap();
        }
        if (this.fV.get(index.getName()) != null) {
            throw DbException.get(42111, index.getSQL());
        }
        this.fV.put(index.getName(), index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocalTempTableIndex(Index index) {
        if (this.fV != null) {
            this.fV.remove(index.getName());
            Database database = this.go;
            synchronized (database) {
                index.removeChildrenAndResources(this);
            }
        }
    }

    public Constraint findLocalTempTableConstraint(String string) {
        if (this.fS == null) {
            return null;
        }
        return (Constraint)this.fS.get(string);
    }

    public HashMap getLocalTempTableConstraints() {
        if (this.fS == null) {
            return New.hashMap();
        }
        return this.fS;
    }

    public void addLocalTempTableConstraint(Constraint constraint) {
        String string;
        if (this.fS == null) {
            this.fS = New.hashMap();
        }
        if (this.fS.get(string = constraint.getName()) != null) {
            throw DbException.get(90045, constraint.getSQL());
        }
        this.fS.put(string, constraint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocalTempTableConstraint(Constraint constraint) {
        if (this.fS != null) {
            this.fS.remove(constraint.getName());
            Database database = this.go;
            synchronized (database) {
                constraint.removeChildrenAndResources(this);
            }
        }
    }

    protected void finalize() {
        if (!SysProperties.runFinalize) {
            return;
        }
        if (!this.gm) {
            throw new RuntimeException("Not closed", this.gq);
        }
    }

    public boolean getAutoCommit() {
        return this.fP;
    }

    public User getUser() {
        return this.gc;
    }

    public void setAutoCommit(boolean bl) {
        this.fP = bl;
    }

    public int getLockTimeout() {
        return this.gd;
    }

    public void setLockTimeout(int n2) {
        this.gd = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandInterface prepareCommand(String string, int n2) {
        Database database = this.go;
        synchronized (database) {
            return this.prepareLocal(string);
        }
    }

    public Prepared prepare(String string) {
        return this.prepare(string, false);
    }

    public Prepared prepare(String string, boolean bl) {
        Parser parser = new Parser(this);
        parser.setRightsChecked(bl);
        return parser.prepare(string);
    }

    public Command prepareLocal(String string) {
        Command command;
        if (this.gm) {
            throw DbException.get(90067, "session closed");
        }
        if (this.fT > 0) {
            if (this.gr == null) {
                this.gr = SmallLRUCache.newInstance(this.fT);
            } else {
                command = (Command)this.gr.get(string);
                if (command != null) {
                    return command;
                }
            }
        }
        Parser parser = new Parser(this);
        command = parser.prepareCommand(string);
        if (this.gr != null && command.isCacheable()) {
            this.gr.put(string, command);
        }
        return command;
    }

    public Database getDatabase() {
        return this.go;
    }

    public int getPowerOffCount() {
        return this.go.getPowerOffCount();
    }

    public void setPowerOffCount(int n2) {
        this.go.setPowerOffCount(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(boolean bl) {
        this.y();
        this.f1 = null;
        if (this.z()) {
            this.go.commit(this);
        }
        if (this.fM.size() > 0) {
            if (this.go.isMultiVersion()) {
                ArrayList arrayList = New.arrayList();
                Object object = this.go;
                synchronized (object) {
                    while (this.fM.size() > 0) {
                        UndoLogRecord undoLogRecord = this.fM.getLast();
                        undoLogRecord.commit();
                        arrayList.add(undoLogRecord.getRow());
                        this.fM.removeLast(false);
                    }
                    int n2 = arrayList.size();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        Row row = (Row)arrayList.get(i2);
                        row.commit();
                    }
                }
            }
            this.fM.clear();
        }
        if (!bl) {
            this.do(false);
            if (this.gf) {
                this.fP = true;
                this.gf = false;
            }
        }
        if (this.f4 != null && this.f4.size() > 0) {
            this.go.flush();
            for (Object object : this.f4.values()) {
                ((Value)object).unlink();
            }
            this.f4 = null;
        }
        this.x();
    }

    private void y() {
        if (this.fL && this.f3.size() > 0) {
            throw DbException.get(90058);
        }
    }

    public void rollback() {
        this.y();
        this.f1 = null;
        boolean bl = false;
        if (this.fM.size() > 0) {
            this.rollbackTo(0, false);
            bl = true;
        }
        if (this.f3.size() > 0 || bl) {
            this.go.commit(this);
        }
        this.do(false);
        this.x();
        if (this.gf) {
            this.fP = true;
            this.gf = false;
        }
    }

    public void rollbackTo(int n2, boolean bl) {
        String[] stringArray;
        while (this.fM.size() > n2) {
            stringArray = this.fM.getLast();
            stringArray.undo(this);
            this.fM.removeLast(bl);
        }
        if (this.f2 != null) {
            stringArray = new String[this.f2.size()];
            this.f2.keySet().toArray(stringArray);
            for (String string : stringArray) {
                Integer n3 = (Integer)this.f2.get(string);
                if (n3 <= n2) continue;
                this.f2.remove(string);
            }
        }
    }

    public int getLogId() {
        return this.fM.size();
    }

    public int getId() {
        return this.gh;
    }

    public void cancel() {
        this.fO = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (!this.gm) {
            try {
                this.go.checkPowerOff();
                this.do(true);
                this.fM.clear();
                this.go.removeSession(this);
            }
            finally {
                this.gm = true;
            }
        }
    }

    public void addLock(Table table) {
        if (SysProperties.CHECK && this.f3.indexOf(table) >= 0) {
            DbException.throwInternalError();
        }
        this.f3.add(table);
    }

    public void log(Table table, short s, Row row) {
        if (this.fI) {
            int n2;
            UndoLogRecord undoLogRecord = new UndoLogRecord(table, s, row);
            if (SysProperties.CHECK && (n2 = this.go.getLockMode()) != 0 && !this.go.isMultiVersion()) {
                String string = undoLogRecord.getTable().getTableType();
                if (this.f3.indexOf(undoLogRecord.getTable()) < 0 && !"TABLE LINK".equals(string) && !"EXTERNAL".equals(string)) {
                    DbException.throwInternalError();
                }
            }
            this.fM.add(undoLogRecord);
        } else {
            ArrayList arrayList = table.getIndexes();
            int n3 = arrayList.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                Index index = (Index)arrayList.get(i2);
                index.commit(s, row);
            }
            row.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockReadLocks() {
        if (this.go.isMultiVersion()) {
            return;
        }
        for (int i2 = 0; i2 < this.f3.size(); ++i2) {
            Table table = (Table)this.f3.get(i2);
            if (table.isLockedExclusively()) continue;
            Database database = this.go;
            synchronized (database) {
                table.unlock(this);
                this.f3.remove(i2);
            }
            --i2;
        }
    }

    public void unlock(Table table) {
        this.f3.remove(table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void x() {
        if (SysProperties.CHECK && this.fM.size() > 0) {
            DbException.throwInternalError();
        }
        if (this.f3.size() > 0) {
            Database database = this.go;
            synchronized (database) {
                int n2 = this.f3.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    Table table = (Table)this.f3.get(i2);
                    table.unlock(this);
                }
                this.f3.clear();
            }
        }
        this.f2 = null;
        if (this.gk != this.fH) {
            this.sessionStateChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void do(boolean bl) {
        if (this.f8 != null && this.f8.size() > 0) {
            Database database = this.go;
            synchronized (database) {
                for (Table table : New.arrayList(this.f8.values())) {
                    if (bl || table.getOnCommitDrop()) {
                        ++this.fH;
                        table.setModified();
                        this.f8.remove(table.getName());
                        table.removeChildrenAndResources(this);
                        continue;
                    }
                    if (!table.getOnCommitTruncate()) continue;
                    table.truncate(this);
                }
            }
        }
    }

    public Random getRandom() {
        if (this.f9 == null) {
            this.f9 = new Random();
        }
        return this.f9;
    }

    public Trace getTrace() {
        if (this.f6 != null && !this.gm) {
            return this.f6;
        }
        String string = "jdbc[" + this.gh + "]";
        if (this.gm) {
            return new TraceSystem(null).getTrace(string);
        }
        this.f6 = this.go.getTrace(string);
        return this.f6;
    }

    public void setLastIdentity(Value value) {
        this.fJ = value;
        this.fQ = value;
    }

    public Value getLastIdentity() {
        return this.fQ;
    }

    public void addLogPos(int n2, int n3) {
        if (this.gp == -1) {
            this.gp = n2;
            this.fW = n3;
        }
    }

    public int getFirstUncommittedLog() {
        return this.gp;
    }

    public void setAllCommitted() {
        this.gp = -1;
        this.fW = -1;
    }

    private boolean z() {
        return this.gp != -1;
    }

    public void addSavepoint(String string) {
        if (this.f2 == null) {
            this.f2 = New.hashMap();
        }
        this.f2.put(string, this.getLogId());
    }

    public void rollbackToSavepoint(String string) {
        this.y();
        if (this.f2 == null) {
            throw DbException.get(90063, string);
        }
        Integer n2 = (Integer)this.f2.get(string);
        if (n2 == null) {
            throw DbException.get(90063, string);
        }
        int n3 = n2;
        this.rollbackTo(n3, false);
    }

    public void prepareCommit(String string) {
        if (this.z()) {
            this.go.prepareCommit(this, string);
        }
        this.f1 = string;
    }

    public void setPreparedTransaction(String string, boolean bl) {
        if (this.f1 != null && this.f1.equals(string)) {
            if (bl) {
                this.commit(false);
            } else {
                this.rollback();
            }
        } else {
            ArrayList arrayList = this.go.getInDoubtTransactions();
            int n2 = bl ? 1 : 2;
            boolean bl2 = false;
            if (arrayList != null) {
                for (InDoubtTransaction inDoubtTransaction : arrayList) {
                    if (!inDoubtTransaction.getTransaction().equals(string)) continue;
                    inDoubtTransaction.setState(n2);
                    bl2 = true;
                    break;
                }
            }
            if (!bl2) {
                throw DbException.get(90129, string);
            }
        }
    }

    public boolean isClosed() {
        return this.gm;
    }

    public void setThrottle(int n2) {
        this.gg = n2;
    }

    public void throttle() {
        if (this.f7 == 0L) {
            this.f7 = System.currentTimeMillis();
        }
        if (this.gg == 0) {
            return;
        }
        long l2 = System.currentTimeMillis();
        if (this.fF + 50L > l2) {
            return;
        }
        this.fF = l2 + (long)this.gg;
        try {
            Thread.sleep(this.gg);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setCurrentCommand(Command command) {
        this.gb = command;
        if (this.gl > 0 && command != null) {
            long l2;
            this.f7 = l2 = System.currentTimeMillis();
            this.fO = l2 + (long)this.gl;
        }
    }

    public void checkCanceled() {
        this.throttle();
        if (this.fO == 0L) {
            return;
        }
        long l2 = System.currentTimeMillis();
        if (l2 >= this.fO) {
            this.fO = 0L;
            throw DbException.get(90051);
        }
    }

    public long getCancel() {
        return this.fO;
    }

    public Command getCurrentCommand() {
        return this.gb;
    }

    public long getCurrentCommandStart() {
        return this.f7;
    }

    public boolean getAllowLiterals() {
        return this.ge;
    }

    public void setAllowLiterals(boolean bl) {
        this.ge = bl;
    }

    public void setCurrentSchema(Schema schema) {
        ++this.fH;
        this.gi = schema.getName();
    }

    public String getCurrentSchemaName() {
        return this.gi;
    }

    public JdbcConnection createConnection(boolean bl) {
        String string = bl ? "jdbc:columnlist:connection" : "jdbc:default:connection";
        return new JdbcConnection(this, this.getUser().getName(), string);
    }

    public DataHandler getDataHandler() {
        return this.go;
    }

    public void unlinkAtCommit(Value value) {
        if (SysProperties.CHECK && !value.isLinked()) {
            DbException.throwInternalError();
        }
        if (this.f4 == null) {
            this.f4 = New.hashMap();
        }
        this.f4.put(value.toString(), value);
    }

    public void unlinkAtCommitStop(Value value) {
        if (this.f4 != null) {
            this.f4.remove(value.toString());
        }
    }

    public String getNextSystemIdentifier(String string) {
        String string2;
        while (string.indexOf(string2 = gs + this.f0++) >= 0) {
        }
        return string2;
    }

    public void addProcedure(Procedure procedure) {
        if (this.fR == null) {
            this.fR = New.hashMap();
        }
        this.fR.put(procedure.getName(), procedure);
    }

    public void removeProcedure(String string) {
        if (this.fR != null) {
            this.fR.remove(string);
        }
    }

    public Procedure getProcedure(String string) {
        if (this.fR == null) {
            return null;
        }
        return (Procedure)this.fR.get(string);
    }

    public void setSchemaSearchPath(String[] stringArray) {
        ++this.fH;
        this.fU = stringArray;
    }

    public String[] getSchemaSearchPath() {
        return this.fU;
    }

    public int hashCode() {
        return this.gn;
    }

    public String toString() {
        return "#" + this.gn + " (user: " + this.gc.getName() + ")";
    }

    public void setUndoLogEnabled(boolean bl) {
        this.fI = bl;
    }

    public void setRedoLogBinary(boolean bl) {
        this.fN = bl;
    }

    public boolean isUndoLogEnabled() {
        return this.fI;
    }

    public void begin() {
        this.gf = true;
        this.fP = false;
    }

    public long getSessionStart() {
        return this.f5;
    }

    public Table[] getLocks() {
        ArrayList arrayList = New.arrayList();
        for (int i2 = 0; i2 < this.f3.size(); ++i2) {
            try {
                arrayList.add(this.f3.get(i2));
                continue;
            }
            catch (Exception exception) {
                break;
            }
        }
        Table[] tableArray = new Table[arrayList.size()];
        arrayList.toArray(tableArray);
        return tableArray;
    }

    public void waitIfExclusiveModeEnabled() {
        Session session;
        while ((session = this.go.getExclusiveSession()) != null && session != this) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void addTemporaryResult(ResultInterface resultInterface) {
        if (!resultInterface.needToClose()) {
            return;
        }
        if (this.fZ == null) {
            this.fZ = New.hashSet();
        }
        if (this.fZ.size() < 100) {
            this.fZ.add(resultInterface);
        }
    }

    public void closeTemporaryResults() {
        if (this.fZ != null) {
            for (ResultInterface resultInterface : this.fZ) {
                resultInterface.close();
            }
            this.fZ = null;
        }
    }

    public void setQueryTimeout(int n2) {
        int n3 = this.go.getSettings().maxQueryTimeout;
        if (n3 != 0 && (n3 < n2 || n2 == 0)) {
            n2 = n3;
        }
        this.gl = n2;
        this.fO = 0L;
    }

    public int getQueryTimeout() {
        return this.gl;
    }

    public void setWaitForLock(Table table) {
        this.fK = table;
    }

    public Table getWaitForLock() {
        return this.fK;
    }

    public int getModificationId() {
        return this.fH;
    }

    public boolean isReconnectNeeded(boolean bl) {
        block2: {
            do {
                boolean bl2;
                if (bl2 = this.go.isReconnectNeeded()) {
                    return true;
                }
                if (!bl) break block2;
            } while (!this.go.beforeWriting());
            return false;
        }
        return false;
    }

    public void afterWriting() {
        this.go.afterWriting();
    }

    public SessionInterface reconnect(boolean bl) {
        this.readSessionState();
        this.close();
        Session session = Engine.getInstance().createSession(this.gj);
        session.sessionState = this.sessionState;
        session.recreateSessionState();
        if (bl) {
            while (!session.go.beforeWriting()) {
            }
        }
        return session;
    }

    public void setConnectionInfo(ConnectionInfo connectionInfo) {
        this.gj = connectionInfo;
    }

    public Value getTransactionId() {
        if (this.fM.size() == 0 || !this.go.isPersistent()) {
            return ValueNull.INSTANCE;
        }
        return ValueString.get(this.gp + "-" + this.fW + "-" + this.gh);
    }

    public int nextObjectId() {
        return this.fY++;
    }

    public void setScopeIdentity(Value value) {
        this.fJ = value;
    }

    public Value getScopeIdentity() {
        return this.fJ;
    }

    public boolean isRedoLogBinaryEnabled() {
        return this.fN;
    }
}

