/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.io.IOException;
import java.net.Socket;
import java.sql.Connection;
import java.util.ArrayList;
import org.h2.api.DatabaseEventListener;
import org.h2.command.CommandInterface;
import org.h2.command.CommandRemote;
import org.h2.constant.SysProperties;
import org.h2.engine.ConnectionInfo;
import org.h2.engine.SessionFactory;
import org.h2.engine.SessionInterface;
import org.h2.engine.SessionWithState;
import org.h2.jdbc.JdbcSQLException;
import org.h2.message.DbException;
import org.h2.message.Trace;
import org.h2.message.TraceSystem;
import org.h2.store.DataHandler;
import org.h2.store.FileStore;
import org.h2.store.LobStorage;
import org.h2.util.IOUtils;
import org.h2.util.MathUtils;
import org.h2.util.NetUtils;
import org.h2.util.New;
import org.h2.util.SmallLRUCache;
import org.h2.util.StringUtils;
import org.h2.util.TempFileDeleter;
import org.h2.util.Utils;
import org.h2.value.Transfer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SessionRemote
extends SessionWithState
implements DataHandler {
    public static final int SESSION_PREPARE = 0;
    public static final int SESSION_CLOSE = 1;
    public static final int COMMAND_EXECUTE_QUERY = 2;
    public static final int COMMAND_EXECUTE_UPDATE = 3;
    public static final int COMMAND_CLOSE = 4;
    public static final int RESULT_FETCH_ROWS = 5;
    public static final int RESULT_RESET = 6;
    public static final int RESULT_CLOSE = 7;
    public static final int COMMAND_COMMIT = 8;
    public static final int CHANGE_ID = 9;
    public static final int COMMAND_GET_META_DATA = 10;
    public static final int SESSION_PREPARE_READ_PARAMS = 11;
    public static final int SESSION_SET_ID = 12;
    public static final int SESSION_CANCEL_STATEMENT = 13;
    public static final int SESSION_CHECK_KEY = 14;
    public static final int SESSION_SET_AUTOCOMMIT = 15;
    public static final int STATUS_ERROR = 0;
    public static final int STATUS_OK = 1;
    public static final int STATUS_CLOSED = 2;
    public static final int STATUS_OK_STATE_CHANGED = 3;
    private static SessionFactory gN;
    private TraceSystem gt;
    private Trace gD;
    private ArrayList gK = New.arrayList();
    private int gu;
    private boolean gz = true;
    private CommandInterface gH;
    private CommandInterface gA;
    private ConnectionInfo gJ;
    private String gC;
    private String gw;
    private byte[] gB;
    private Object gy = new Object();
    private String gI;
    private int gx;
    private boolean gL;
    private int gE;
    private SessionInterface gF;
    private DatabaseEventListener gv;
    private LobStorage gM;
    private boolean gG;

    public SessionRemote(ConnectionInfo connectionInfo) {
        this.gJ = connectionInfo;
    }

    private Transfer a(ConnectionInfo connectionInfo, String string, String string2) throws IOException {
        Socket socket = NetUtils.createSocket(string2, 9092, connectionInfo.isSSL());
        Transfer transfer = new Transfer(this);
        transfer.setSocket(socket);
        transfer.setSSL(connectionInfo.isSSL());
        transfer.init();
        transfer.writeInt(6);
        transfer.writeInt(8);
        transfer.writeString(string);
        transfer.writeString(connectionInfo.getOriginalURL());
        transfer.writeString(connectionInfo.getUserName());
        transfer.writeBytes(connectionInfo.getUserPasswordHash());
        transfer.writeBytes(connectionInfo.getFilePasswordHash());
        String[] stringArray = connectionInfo.getKeys();
        transfer.writeInt(stringArray.length);
        for (String string3 : stringArray) {
            transfer.writeString(string3).writeString(connectionInfo.getProperty(string3));
        }
        try {
            this.done(transfer);
            this.gx = transfer.readInt();
            transfer.setVersion(this.gx);
            transfer.writeInt(12);
            transfer.writeString(this.gI);
            this.done(transfer);
        }
        catch (DbException dbException) {
            transfer.close();
            throw dbException;
        }
        this.gz = true;
        return transfer;
    }

    public void cancel() {
    }

    public void cancelStatement(int n2) {
        for (Transfer transfer : this.gK) {
            try {
                Transfer transfer2 = transfer.openNewConnection();
                transfer2.init();
                transfer2.writeInt(this.gx);
                transfer2.writeInt(this.gx);
                transfer2.writeString(null);
                transfer2.writeString(null);
                transfer2.writeString(this.gI);
                transfer2.writeInt(13);
                transfer2.writeInt(n2);
                transfer2.close();
            }
            catch (IOException iOException) {
                this.gD.debug(iOException, "could not cancel statement");
            }
        }
    }

    private void int(String string) {
        if (this.gz && this.gK.size() > 1) {
            this.for(false);
            CommandInterface commandInterface = this.prepareCommand("SET CLUSTER " + string, Integer.MAX_VALUE);
            commandInterface.executeUpdate();
            this.gz = true;
            this.gG = true;
        }
    }

    public boolean getAutoCommit() {
        return this.gz;
    }

    public void setAutoCommit(boolean bl) {
        if (!this.gG) {
            this.for(bl);
        }
        this.gz = bl;
    }

    public void setAutoCommitFromServer(boolean bl) {
        if (this.gG) {
            if (bl) {
                this.for(false);
                this.gz = true;
            }
        } else {
            this.gz = bl;
        }
    }

    private void for(boolean bl) {
        if (this.gx >= 8) {
            int n2 = 0;
            for (int i2 = 0; i2 < this.gK.size(); ++i2) {
                Transfer transfer = (Transfer)this.gK.get(i2);
                try {
                    this.traceOperation("SESSION_SET_AUTOCOMMIT", bl ? 1 : 0);
                    transfer.writeInt(15).writeBoolean(bl);
                    this.done(transfer);
                    continue;
                }
                catch (IOException iOException) {
                    this.removeServer(iOException, i2--, ++n2);
                }
            }
        } else if (bl) {
            if (this.gH == null) {
                this.gH = this.prepareCommand("SET AUTOCOMMIT FALSE", Integer.MAX_VALUE);
            }
            this.gH.executeUpdate();
        } else {
            if (this.gA == null) {
                this.gA = this.prepareCommand("SET AUTOCOMMIT TRUE", Integer.MAX_VALUE);
            }
            this.gA.executeUpdate();
        }
    }

    public void autoCommitIfCluster() {
        if (this.gz && this.gK != null && this.gK.size() > 1) {
            int n2 = 0;
            for (int i2 = 0; i2 < this.gK.size(); ++i2) {
                Transfer transfer = (Transfer)this.gK.get(i2);
                try {
                    this.traceOperation("COMMAND_COMMIT", 0);
                    transfer.writeInt(8);
                    this.done(transfer);
                    continue;
                }
                catch (IOException iOException) {
                    this.removeServer(iOException, i2--, ++n2);
                }
            }
        }
    }

    private String new(String string) {
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append('/');
        for (int i2 = 0; i2 < this.gC.length(); ++i2) {
            char c2 = this.gC.charAt(i2);
            if (Character.isLetterOrDigit(c2)) {
                stringBuilder.append(c2);
                continue;
            }
            stringBuilder.append('_');
        }
        return stringBuilder.toString();
    }

    public int getPowerOffCount() {
        return 0;
    }

    public void setPowerOffCount(int n2) {
        throw DbException.getUnsupportedException("remote");
    }

    public SessionInterface createSession(ConnectionInfo connectionInfo) {
        return new SessionRemote(connectionInfo).int(false);
    }

    private SessionInterface int(boolean bl) {
        ConnectionInfo connectionInfo = this.gJ;
        if (connectionInfo.isRemote()) {
            this.a(connectionInfo);
            return this;
        }
        boolean bl2 = Boolean.valueOf(connectionInfo.getProperty("AUTO_SERVER", "false"));
        ConnectionInfo connectionInfo2 = null;
        try {
            if (bl2) {
                connectionInfo2 = (ConnectionInfo)connectionInfo.clone();
                this.gJ = (ConnectionInfo)connectionInfo.clone();
            }
            if (bl) {
                connectionInfo.setProperty("OPEN_NEW", "true");
            }
            if (gN == null) {
                gN = (SessionFactory)Class.forName("org.h2.engine.Engine").newInstance();
            }
            return gN.createSession(connectionInfo);
        }
        catch (Exception exception) {
            String string;
            DbException dbException = DbException.convert(exception);
            if (dbException.getErrorCode() == 90020 && bl2 && (string = ((JdbcSQLException)dbException.getSQLException()).getSQL()) != null) {
                connectionInfo2.setServerKey(string);
                connectionInfo2.removeProperty("OPEN_NEW", null);
                this.a(connectionInfo2);
                return this;
            }
            throw dbException;
        }
    }

    private void a(ConnectionInfo connectionInfo) {
        String[] stringArray;
        String string;
        int n2;
        String string2 = connectionInfo.getName();
        if (string2.startsWith("//")) {
            string2 = string2.substring("//".length());
        }
        if ((n2 = string2.indexOf(47)) < 0) {
            throw connectionInfo.getFormatException();
        }
        this.gC = string2.substring(n2 + 1);
        String string3 = string2.substring(0, n2);
        this.gt = new TraceSystem(null);
        String string4 = connectionInfo.getProperty(10, null);
        if (string4 != null) {
            int n3 = Integer.parseInt(string4);
            String string5 = this.new(SysProperties.CLIENT_TRACE_DIRECTORY);
            try {
                String string6 = IOUtils.createTempFile(string5, ".trace.db", false, false);
                this.gt.setFileName(string6);
                this.gt.setLevelFile(n3);
            }
            catch (IOException iOException) {
                throw DbException.convertIOException(iOException, string5);
            }
        }
        if ((string = connectionInfo.getProperty(9, null)) != null) {
            int n4 = Integer.parseInt(string);
            this.gt.setLevelSystemOut(n4);
        }
        this.gD = this.gt.getTrace("jdbc");
        String string7 = null;
        if (string3.indexOf(44) >= 0) {
            string7 = StringUtils.quoteStringSQL(string3);
            connectionInfo.setProperty("CLUSTER", "TRUE");
        }
        this.gL = Boolean.valueOf(connectionInfo.getProperty("AUTO_RECONNECT", "false"));
        boolean bl = Boolean.valueOf(connectionInfo.getProperty("AUTO_SERVER", "false"));
        if (bl && string7 != null) {
            throw DbException.getUnsupportedException("autoServer && serverList != null");
        }
        this.gL |= bl;
        if (this.gL && (stringArray = connectionInfo.getProperty("DATABASE_EVENT_LISTENER")) != null) {
            stringArray = StringUtils.trim((String)stringArray, true, true, "'");
            try {
                this.gv = (DatabaseEventListener)Utils.loadUserClass((String)stringArray).newInstance();
            }
            catch (Throwable throwable) {
                throw DbException.convert(throwable);
            }
        }
        this.gw = connectionInfo.getProperty("CIPHER");
        if (this.gw != null) {
            this.gB = MathUtils.secureRandomBytes(32);
        }
        stringArray = StringUtils.arraySplit(string3, ',', true);
        int n5 = stringArray.length;
        this.gK.clear();
        this.gI = StringUtils.convertBytesToString(MathUtils.secureRandomBytes(32));
        boolean bl2 = false;
        try {
            for (int i2 = 0; i2 < n5; ++i2) {
                try {
                    Transfer transfer = this.a(connectionInfo, this.gC, stringArray[i2]);
                    this.gK.add(transfer);
                    continue;
                }
                catch (IOException iOException) {
                    if (n5 == 1) {
                        throw DbException.get(90067, iOException, iOException.getMessage());
                    }
                    bl2 = true;
                }
            }
            this.checkClosed();
            if (bl2) {
                this.A();
            }
            this.int(string7);
        }
        catch (DbException dbException) {
            this.gt.close();
            throw dbException;
        }
    }

    private void A() {
        CommandInterface commandInterface = this.prepareCommand("SET CLUSTER ''", Integer.MAX_VALUE);
        commandInterface.executeUpdate();
    }

    public void removeServer(IOException iOException, int n2, int n3) {
        this.gK.remove(n2);
        if (this.gK.size() == 0 && this.autoReconnect(n3)) {
            return;
        }
        this.checkClosed();
        this.A();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandInterface prepareCommand(String string, int n2) {
        SessionRemote sessionRemote = this;
        synchronized (sessionRemote) {
            this.checkClosed();
            return new CommandRemote(this, this.gK, string, n2);
        }
    }

    public boolean autoReconnect(int n2) {
        if (!this.isClosed()) {
            return false;
        }
        if (!this.gL) {
            return false;
        }
        if (!this.gG && !this.gz) {
            return false;
        }
        if (n2 > SysProperties.MAX_RECONNECT) {
            return false;
        }
        ++this.gE;
        while (true) {
            try {
                this.gF = this.int(false);
            }
            catch (DbException dbException) {
                if (dbException.getErrorCode() != 90135) {
                    throw dbException;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {}
                continue;
            }
            break;
        }
        if (this.gF == this) {
            this.gF = null;
        } else {
            this.int(true);
        }
        this.recreateSessionState();
        if (this.gv != null) {
            this.gv.setProgress(4, this.gC, n2, SysProperties.MAX_RECONNECT);
        }
        return true;
    }

    public void checkClosed() {
        if (this.isClosed()) {
            throw DbException.get(90067, "session closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.gK != null) {
            SessionRemote sessionRemote = this;
            synchronized (sessionRemote) {
                for (Transfer transfer : this.gK) {
                    try {
                        this.traceOperation("SESSION_CLOSE", 0);
                        transfer.writeInt(1);
                        this.done(transfer);
                        transfer.close();
                    }
                    catch (Exception exception) {
                        this.gD.error(exception, "close");
                    }
                }
            }
            this.gK = null;
        }
        this.gt.close();
        if (this.gF != null) {
            this.gF.close();
            this.gF = null;
        }
    }

    public Trace getTrace() {
        return this.gt.getTrace("jdbc");
    }

    public int getNextId() {
        return this.gu++;
    }

    public int getCurrentId() {
        return this.gu;
    }

    public void done(Transfer transfer) throws IOException {
        transfer.flush();
        int n2 = transfer.readInt();
        if (n2 == 0) {
            String string = transfer.readString();
            String string2 = transfer.readString();
            String string3 = transfer.readString();
            int n3 = transfer.readInt();
            String string4 = transfer.readString();
            JdbcSQLException jdbcSQLException = new JdbcSQLException(string2, string3, string, n3, null, string4);
            if (n3 == 90067) {
                IOException iOException = new IOException(jdbcSQLException.toString());
                iOException.initCause(jdbcSQLException);
                throw iOException;
            }
            throw DbException.convert(jdbcSQLException);
        }
        if (n2 == 2) {
            this.gK = null;
        } else if (n2 == 3) {
            this.sessionStateChanged = true;
        } else if (n2 != 1) {
            throw DbException.get(90067, "unexpected status " + n2);
        }
    }

    public boolean isClustered() {
        return this.gK.size() > 1;
    }

    public boolean isClosed() {
        return this.gK == null || this.gK.size() == 0;
    }

    public void traceOperation(String string, int n2) {
        if (this.gD.isDebugEnabled()) {
            this.gD.debug("{0} {1}", string, n2);
        }
    }

    public void checkPowerOff() {
    }

    public void checkWritingAllowed() {
    }

    public void freeUpDiskSpace() {
    }

    public String getDatabasePath() {
        return "";
    }

    public String getLobCompressionAlgorithm(int n2) {
        return null;
    }

    public int getMaxLengthInplaceLob() {
        return SysProperties.LOB_CLIENT_MAX_SIZE_MEMORY;
    }

    public FileStore openFile(String string, String string2, boolean bl) {
        if (bl && !IOUtils.exists(string)) {
            throw DbException.get(90124, string);
        }
        FileStore fileStore = this.gw == null ? FileStore.open(this, string, string2) : FileStore.open(this, string, string2, this.gw, this.gB, 0);
        fileStore.setCheckedWriting(false);
        try {
            fileStore.init();
        }
        catch (DbException dbException) {
            fileStore.closeSilently();
            throw dbException;
        }
        return fileStore;
    }

    public DataHandler getDataHandler() {
        return this;
    }

    public Object getLobSyncObject() {
        return this.gy;
    }

    public SmallLRUCache getLobFileListCache() {
        return null;
    }

    public int getClientVersion() {
        return this.gx;
    }

    public int getLastReconnect() {
        return this.gE;
    }

    public TempFileDeleter getTempFileDeleter() {
        return TempFileDeleter.getInstance();
    }

    public boolean isReconnectNeeded(boolean bl) {
        return false;
    }

    public SessionInterface reconnect(boolean bl) {
        return this;
    }

    public void afterWriting() {
    }

    public LobStorage getLobStorage() {
        if (this.gM == null) {
            this.gM = new LobStorage(this);
        }
        return this.gM;
    }

    public Connection getLobConnection() {
        return null;
    }
}

