/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import org.h2.constant.SysProperties;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.engine.UndoLog;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.store.Data;
import org.h2.store.FileStore;
import org.h2.table.Table;
import org.h2.value.Value;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class UndoLogRecord {
    public static final short INSERT = 0;
    public static final short DELETE = 1;
    private static final int int = 0;
    private static final int for = 1;
    private static final int if = 2;
    private Table try;
    private Row byte;
    private short do;
    private short a;
    private int new;

    public UndoLogRecord(Table table, short s, Row row) {
        this.try = table;
        this.byte = row;
        this.do = s;
        this.a = 0;
    }

    boolean isStored() {
        return this.a == 1;
    }

    boolean canStore() {
        return this.try.getUniqueIndex() != null;
    }

    public void undo(Session session) {
        Database database = session.getDatabase();
        switch (this.do) {
            case 0: {
                if (this.a == 2) {
                    this.a = 0;
                }
                if (database.getLockMode() == 0 && this.byte.isDeleted()) {
                    return;
                }
                try {
                    this.byte.setDeleted(false);
                    this.try.removeRow(session, this.byte);
                    this.try.fireAfterRow(session, this.byte, null, true);
                    break;
                }
                catch (DbException dbException) {
                    if (session.getDatabase().getLockMode() == 0 && dbException.getErrorCode() == 90112) break;
                    throw dbException;
                }
            }
            case 1: {
                try {
                    this.try.addRow(session, this.byte);
                    this.try.fireAfterRow(session, null, this.byte, true);
                    this.byte.commit();
                    break;
                }
                catch (DbException dbException) {
                    if (session.getDatabase().getLockMode() == 0 && dbException.getSQLException().getErrorCode() == 23001) break;
                    throw dbException;
                }
            }
            default: {
                DbException.throwInternalError("op=" + this.do);
            }
        }
    }

    void append(Data data, UndoLog undoLog) {
        int n2 = data.length();
        data.writeInt(0);
        data.writeInt(this.do);
        data.writeByte(this.byte.isDeleted() ? (byte)1 : 0);
        data.writeInt(undoLog.getTableId(this.try));
        data.writeLong(this.byte.getKey());
        data.writeInt(this.byte.getSessionId());
        int n3 = this.byte.getColumnCount();
        data.writeInt(n3);
        for (int i2 = 0; i2 < n3; ++i2) {
            Value value = this.byte.getValue(i2);
            data.checkCapacity(data.getValueLen(value));
            data.writeValue(value);
        }
        data.fillAligned();
        data.setInt(n2, (data.length() - n2) / 16);
    }

    void save(Data data, FileStore fileStore, UndoLog undoLog) {
        data.reset();
        this.append(data, undoLog);
        this.new = (int)(fileStore.getFilePointer() / 16L);
        fileStore.write(data.getBytes(), 0, data.length());
        this.byte = null;
        this.a = 1;
    }

    static UndoLogRecord loadFromBuffer(Data data, UndoLog undoLog) {
        UndoLogRecord undoLogRecord = new UndoLogRecord(null, 0, null);
        int n2 = data.length();
        int n3 = data.readInt() * 16;
        undoLogRecord.a(data, undoLog);
        data.setPos(n2 + n3);
        return undoLogRecord;
    }

    void load(Data data, FileStore fileStore, UndoLog undoLog) {
        int n2 = 16;
        undoLog.seek(this.new);
        data.reset();
        fileStore.readFully(data.getBytes(), 0, n2);
        int n3 = data.readInt() * 16;
        data.checkCapacity(n3);
        if (n3 - n2 > 0) {
            fileStore.readFully(data.getBytes(), n2, n3 - n2);
        }
        short s = this.do;
        this.a(data, undoLog);
        if (SysProperties.CHECK && this.do != s) {
            DbException.throwInternalError("operation=" + this.do + " op=" + s);
        }
    }

    private void a(Data data, UndoLog undoLog) {
        this.do = (short)data.readInt();
        boolean bl = data.readByte() == 1;
        this.try = undoLog.getTable(data.readInt());
        long l2 = data.readLong();
        int n2 = data.readInt();
        int n3 = data.readInt();
        Value[] valueArray = new Value[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            valueArray[i2] = data.readValue();
        }
        this.byte = new Row(valueArray, -1);
        this.byte.setKey(l2);
        this.byte.setDeleted(bl);
        this.byte.setSessionId(n2);
        this.a = (short)2;
    }

    public Table getTable() {
        return this.try;
    }

    public long getFilePos() {
        return this.new;
    }

    public void commit() {
        this.try.commit(this.do, this.byte);
    }

    public Row getRow() {
        return this.byte;
    }

    void invalidatePos() {
        if (this.a == 0) {
            this.a = (short)2;
        }
    }
}

