/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.util.ArrayList;
import java.util.Arrays;
import org.h2.engine.Database;
import org.h2.engine.DbObjectBase;
import org.h2.engine.Right;
import org.h2.engine.RightOwner;
import org.h2.engine.Role;
import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.security.SHA256;
import org.h2.table.MetaTable;
import org.h2.table.RangeTable;
import org.h2.table.Table;
import org.h2.table.TableView;
import org.h2.util.MathUtils;
import org.h2.util.New;
import org.h2.util.StringUtils;
import org.h2.util.Utils;

public class User
extends RightOwner {
    private final boolean w;
    private byte[] x;
    private byte[] v;
    private boolean u;

    public User(Database database, int n2, String string, boolean bl) {
        super(database, n2, string, "user");
        this.w = bl;
    }

    public void setAdmin(boolean bl) {
        this.u = bl;
    }

    public boolean isAdmin() {
        return this.u;
    }

    public void setSaltAndHash(byte[] byArray, byte[] byArray2) {
        this.x = byArray;
        this.v = byArray2;
    }

    public void setUserPasswordHash(byte[] byArray) {
        if (byArray != null) {
            if (byArray.length == 0) {
                this.v = byArray;
                this.x = byArray;
            } else {
                this.x = new byte[8];
                MathUtils.randomBytes(this.x);
                SHA256 sHA256 = new SHA256();
                this.v = sHA256.getHashWithSalt(byArray, this.x);
            }
        }
    }

    public String getCreateSQLForCopy(Table table, String string) {
        throw DbException.throwInternalError();
    }

    public String getCreateSQL() {
        return this.getCreateSQL(true);
    }

    public String getDropSQL() {
        return null;
    }

    public void checkRight(Table table, int n2) {
        if (!this.hasRight(table, n2)) {
            throw DbException.get(90096, table.getSQL());
        }
    }

    public boolean hasRight(Table table, int n2) {
        TableView tableView;
        if (n2 != 1 && !this.w) {
            table.checkWritingAllowed();
        }
        if (this.u) {
            return true;
        }
        Role role = this.database.getPublicRole();
        if (role.isRightGrantedRecursive(table, n2)) {
            return true;
        }
        if (table instanceof MetaTable || table instanceof RangeTable) {
            return true;
        }
        String string = table.getTableType();
        if ("VIEW".equals(string) ? (tableView = (TableView)table).getOwner() == this : string == null) {
            return true;
        }
        if (table.isTemporary() && !table.isGlobalTemporary()) {
            return true;
        }
        return this.isRightGrantedRecursive(table, n2);
    }

    public String getCreateSQL(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder("CREATE USER IF NOT EXISTS ");
        stringBuilder.append(this.getSQL());
        if (this.comment != null) {
            stringBuilder.append(" COMMENT ").append(StringUtils.quoteStringSQL(this.comment));
        }
        if (bl) {
            stringBuilder.append(" SALT '").append(StringUtils.convertBytesToString(this.x)).append("' HASH '").append(StringUtils.convertBytesToString(this.v)).append('\'');
        } else {
            stringBuilder.append(" PASSWORD ''");
        }
        if (this.u) {
            stringBuilder.append(" ADMIN");
        }
        return stringBuilder.toString();
    }

    public boolean validateUserPasswordHash(byte[] byArray) {
        if (byArray.length == 0 && this.v.length == 0) {
            return true;
        }
        SHA256 sHA256 = new SHA256();
        if (byArray.length == 0) {
            byArray = sHA256.getKeyPasswordHash(this.getName(), new char[0]);
        }
        byte[] byArray2 = sHA256.getHashWithSalt(byArray, this.x);
        return Utils.compareSecure(byArray2, this.v);
    }

    public void checkAdmin() {
        if (!this.u) {
            throw DbException.get(90040);
        }
    }

    public int getType() {
        return 2;
    }

    public ArrayList getChildren() {
        ArrayList arrayList = New.arrayList();
        for (DbObjectBase dbObjectBase : this.database.getAllRights()) {
            if (((Right)dbObjectBase).getGrantee() != this) continue;
            arrayList.add(dbObjectBase);
        }
        for (DbObjectBase dbObjectBase : this.database.getAllSchemas()) {
            if (((Schema)dbObjectBase).getOwner() != this) continue;
            arrayList.add(dbObjectBase);
        }
        return arrayList;
    }

    public void removeChildrenAndResources(Session session) {
        for (Right right : this.database.getAllRights()) {
            if (right.getGrantee() != this) continue;
            this.database.removeDatabaseObject(session, right);
        }
        this.database.removeMeta(session, this.getId());
        this.x = null;
        Arrays.fill(this.v, (byte)0);
        this.v = null;
        this.invalidate();
    }

    public void checkRename() {
    }

    public void checkOwnsNoSchemas() {
        for (Schema schema : this.database.getAllSchemas()) {
            if (this != schema.getOwner()) continue;
            throw DbException.get(90107, this.getName(), schema.getName());
        }
    }
}

