/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import org.h2.api.AggregateFunction;
import org.h2.command.Parser;
import org.h2.engine.Database;
import org.h2.engine.DbObjectBase;
import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.table.Table;
import org.h2.util.Utils;

public class UserAggregate
extends DbObjectBase {
    private String n;
    private Class o;

    public UserAggregate(Database database, int n2, String string, String string2, boolean bl) {
        this.initDbObjectBase(database, n2, string, "function");
        this.n = string2;
        if (!bl) {
            this.getInstance();
        }
    }

    public AggregateFunction getInstance() {
        if (this.o == null) {
            this.o = Utils.loadUserClass(this.n);
        }
        try {
            Object t = this.o.newInstance();
            AggregateFunction aggregateFunction = (AggregateFunction)t;
            return aggregateFunction;
        }
        catch (Exception exception) {
            throw DbException.convert(exception);
        }
    }

    public String getCreateSQLForCopy(Table table, String string) {
        throw DbException.throwInternalError();
    }

    public String getDropSQL() {
        return "DROP AGGREGATE IF EXISTS " + this.getSQL();
    }

    public String getCreateSQL() {
        return "CREATE FORCE AGGREGATE " + this.getSQL() + " FOR " + Parser.quoteIdentifier(this.n);
    }

    public int getType() {
        return 14;
    }

    public synchronized void removeChildrenAndResources(Session session) {
        this.database.removeMeta(session, this.getId());
        this.n = null;
        this.o = null;
        this.invalidate();
    }

    public void checkRename() {
        throw DbException.getUnsupportedException("AGGREGATE");
    }

    public String getJavaClassName() {
        return this.n;
    }
}

