/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import org.h2.command.dml.Select;
import org.h2.command.dml.SelectOrderBy;
import org.h2.engine.Session;
import org.h2.expression.AggregateData;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.message.DbException;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.New;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueString;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Aggregate
extends Expression {
    public static final int COUNT_ALL = 0;
    public static final int COUNT = 1;
    public static final int GROUP_CONCAT = 2;
    static final int SUM = 3;
    static final int MIN = 4;
    static final int MAX = 5;
    static final int AVG = 6;
    static final int STDDEV_POP = 7;
    static final int STDDEV_SAMP = 8;
    static final int VAR_POP = 9;
    static final int VAR_SAMP = 10;
    static final int BOOL_OR = 11;
    static final int BOOL_AND = 12;
    static final int SELECTIVITY = 13;
    private static final HashMap L = New.hashMap();
    private final int K;
    private final Select N;
    private final boolean H;
    private Expression M;
    private Expression J;
    private ArrayList I;
    private SortOrder R;
    private int O;
    private int S;
    private long P;
    private int Q;
    private int G;

    public Aggregate(int n2, Expression expression, Select select, boolean bl) {
        this.K = n2;
        this.M = expression;
        this.N = select;
        this.H = bl;
    }

    private static void for(String string, int n2) {
        L.put(string, n2);
    }

    public static int getAggregateType(String string) {
        Integer n2 = (Integer)L.get(string);
        return n2 == null ? -1 : n2;
    }

    public void setOrder(ArrayList arrayList) {
        this.I = arrayList;
    }

    public void setSeparator(Expression expression) {
        this.J = expression;
    }

    private SortOrder a(Session session) {
        int n2 = this.I.size();
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3;
            SelectOrderBy selectOrderBy = (SelectOrderBy)this.I.get(i2);
            nArray[i2] = i2 + 1;
            nArray2[i2] = n3 = selectOrderBy.descending ? 1 : 0;
        }
        return new SortOrder(session.getDatabase(), nArray, nArray2);
    }

    public void updateAggregate(Session session) {
        Value value;
        HashMap hashMap = this.N.getCurrentGroup();
        if (hashMap == null) {
            return;
        }
        int n2 = this.N.getCurrentGroupRowId();
        if (this.G == n2) {
            return;
        }
        this.G = n2;
        AggregateData aggregateData = (AggregateData)hashMap.get(this);
        if (aggregateData == null) {
            aggregateData = new AggregateData(this.K, this.O);
            hashMap.put(this, aggregateData);
        }
        Value value2 = value = this.M == null ? null : this.M.getValue(session);
        if (this.K == 2 && value != ValueNull.INSTANCE) {
            value = value.convertTo(13);
            if (this.I != null) {
                int n3 = this.I.size();
                Value[] valueArray = new Value[1 + n3];
                valueArray[0] = value;
                for (int i2 = 0; i2 < n3; ++i2) {
                    SelectOrderBy selectOrderBy = (SelectOrderBy)this.I.get(i2);
                    valueArray[i2 + 1] = selectOrderBy.expression.getValue(session);
                }
                value = ValueArray.get(valueArray);
            }
        }
        aggregateData.add(session.getDatabase(), this.H, value);
    }

    public Value getValue(Session session) {
        HashMap hashMap;
        if (this.N.isQuickAggregateQuery()) {
            switch (this.K) {
                case 0: {
                    Table table = this.N.getTopTableFilter().getTable();
                    return ValueLong.get(table.getRowCount(session));
                }
                case 4: 
                case 5: {
                    Cursor cursor;
                    SearchRow searchRow;
                    boolean bl = this.K == 4;
                    Index index = this.a(bl);
                    int n2 = index.getIndexColumns()[0].sortType;
                    if ((n2 & 1) != 0) {
                        bl = !bl;
                    }
                    Value value = (searchRow = (cursor = index.findFirstOrLast(session, bl)).getSearchRow()) == null ? ValueNull.INSTANCE : searchRow.getValue(index.getColumns()[0].getColumnId());
                    return value;
                }
            }
            DbException.throwInternalError("type=" + this.K);
        }
        if ((hashMap = this.N.getCurrentGroup()) == null) {
            throw DbException.get(90054, this.getSQL());
        }
        AggregateData aggregateData = (AggregateData)hashMap.get(this);
        if (aggregateData == null) {
            aggregateData = new AggregateData(this.K, this.O);
        }
        Value value = aggregateData.getValue(session.getDatabase(), this.H);
        if (this.K == 2) {
            Object object;
            ArrayList arrayList = aggregateData.getList();
            if (arrayList == null || arrayList.size() == 0) {
                return ValueNull.INSTANCE;
            }
            if (this.I != null) {
                object = this.R;
                Collections.sort(arrayList, new Comparator((SortOrder)object){
                    final /* synthetic */ SortOrder val$sortOrder;
                    {
                        this.val$sortOrder = sortOrder;
                    }

                    public int compare(Value value, Value value2) {
                        Value[] valueArray = ((ValueArray)value).getList();
                        Value[] valueArray2 = ((ValueArray)value2).getList();
                        return this.val$sortOrder.compare(valueArray, valueArray2);
                    }
                });
            }
            object = new StatementBuilder();
            String string = this.J == null ? "," : this.J.getValue(session).getString();
            for (Value value2 : arrayList) {
                String string2 = value2.getType() == 17 ? ((ValueArray)value2).getList()[0].getString() : value2.convertTo(13).getString();
                if (string2 == null) continue;
                if (string != null) {
                    ((StatementBuilder)object).appendExceptFirst(string);
                }
                ((StatementBuilder)object).append(string2);
            }
            value = ValueString.get(((StatementBuilder)object).toString());
        }
        return value;
    }

    public int getType() {
        return this.O;
    }

    public void mapColumns(ColumnResolver columnResolver, int n2) {
        if (this.M != null) {
            this.M.mapColumns(columnResolver, n2);
        }
        if (this.I != null) {
            for (SelectOrderBy selectOrderBy : this.I) {
                selectOrderBy.expression.mapColumns(columnResolver, n2);
            }
        }
        if (this.J != null) {
            this.J.mapColumns(columnResolver, n2);
        }
    }

    public Expression optimize(Session session) {
        if (this.M != null) {
            this.M = this.M.optimize(session);
            this.O = this.M.getType();
            this.S = this.M.getScale();
            this.P = this.M.getPrecision();
            this.Q = this.M.getDisplaySize();
        }
        if (this.I != null) {
            for (SelectOrderBy selectOrderBy : this.I) {
                selectOrderBy.expression = selectOrderBy.expression.optimize(session);
            }
            this.R = this.a(session);
        }
        if (this.J != null) {
            this.J = this.J.optimize(session);
        }
        switch (this.K) {
            case 2: {
                this.O = 13;
                this.S = 0;
                this.P = Integer.MAX_VALUE;
                this.Q = Integer.MAX_VALUE;
                break;
            }
            case 0: 
            case 1: {
                this.O = 5;
                this.S = 0;
                this.P = 19L;
                this.Q = 20;
                break;
            }
            case 13: {
                this.O = 4;
                this.S = 0;
                this.P = 10L;
                this.Q = 11;
                break;
            }
            case 3: {
                if (!DataType.supportsAdd(this.O)) {
                    throw DbException.get(90015, this.getSQL());
                }
                this.O = DataType.getAddProofType(this.O);
                break;
            }
            case 6: {
                if (DataType.supportsAdd(this.O)) break;
                throw DbException.get(90015, this.getSQL());
            }
            case 4: 
            case 5: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                this.O = 7;
                this.P = 17L;
                this.Q = 24;
                this.S = 0;
                break;
            }
            case 11: 
            case 12: {
                this.O = 1;
                this.P = 1L;
                this.Q = 5;
                this.S = 0;
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.K);
            }
        }
        return this;
    }

    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        if (this.M != null) {
            this.M.setEvaluatable(tableFilter, bl);
        }
        if (this.I != null) {
            for (SelectOrderBy selectOrderBy : this.I) {
                selectOrderBy.expression.setEvaluatable(tableFilter, bl);
            }
        }
        if (this.J != null) {
            this.J.setEvaluatable(tableFilter, bl);
        }
    }

    public int getScale() {
        return this.S;
    }

    public long getPrecision() {
        return this.P;
    }

    public int getDisplaySize() {
        return this.Q;
    }

    private String new() {
        StatementBuilder statementBuilder = new StatementBuilder("GROUP_CONCAT(");
        statementBuilder.append(this.M.getSQL());
        if (this.I != null) {
            statementBuilder.append(" ORDER BY ");
            for (SelectOrderBy selectOrderBy : this.I) {
                statementBuilder.appendExceptFirst(", ");
                statementBuilder.append(selectOrderBy.expression.getSQL());
                if (!selectOrderBy.descending) continue;
                statementBuilder.append(" DESC");
            }
        }
        if (this.J != null) {
            statementBuilder.append(" SEPARATOR ").append(this.J.getSQL());
        }
        return statementBuilder.append(')').toString();
    }

    public String getSQL() {
        String string;
        switch (this.K) {
            case 2: {
                return this.new();
            }
            case 0: {
                return "COUNT(*)";
            }
            case 1: {
                string = "COUNT";
                break;
            }
            case 13: {
                string = "SELECTIVITY";
                break;
            }
            case 3: {
                string = "SUM";
                break;
            }
            case 4: {
                string = "MIN";
                break;
            }
            case 5: {
                string = "MAX";
                break;
            }
            case 6: {
                string = "AVG";
                break;
            }
            case 7: {
                string = "STDDEV_POP";
                break;
            }
            case 8: {
                string = "STDDEV_SAMP";
                break;
            }
            case 9: {
                string = "VAR_POP";
                break;
            }
            case 10: {
                string = "VAR_SAMP";
                break;
            }
            case 12: {
                string = "BOOL_AND";
                break;
            }
            case 11: {
                string = "BOOL_OR";
                break;
            }
            default: {
                throw DbException.throwInternalError("type=" + this.K);
            }
        }
        if (this.H) {
            return string + "(DISTINCT " + this.M.getSQL() + ")";
        }
        return string + StringUtils.enclose(this.M.getSQL());
    }

    private Index a(boolean bl) {
        if (this.M instanceof ExpressionColumn) {
            ExpressionColumn expressionColumn = (ExpressionColumn)this.M;
            Column column = expressionColumn.getColumn();
            TableFilter tableFilter = expressionColumn.getTableFilter();
            if (tableFilter != null) {
                Table table = tableFilter.getTable();
                Index index = table.getIndexForColumn(column, bl);
                return index;
            }
        }
        return null;
    }

    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        if (expressionVisitor.getType() == 1) {
            switch (this.K) {
                case 0: {
                    return expressionVisitor.getTable().canGetRowCount();
                }
                case 4: 
                case 5: {
                    boolean bl = this.K == 4;
                    Index index = this.a(bl);
                    return index != null;
                }
            }
            return false;
        }
        if (this.M != null && !this.M.isEverything(expressionVisitor)) {
            return false;
        }
        if (this.J != null && !this.J.isEverything(expressionVisitor)) {
            return false;
        }
        if (this.I != null) {
            int n2 = this.I.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                SelectOrderBy selectOrderBy = (SelectOrderBy)this.I.get(i2);
                if (selectOrderBy.expression.isEverything(expressionVisitor)) continue;
                return false;
            }
        }
        return true;
    }

    public int getCost() {
        return this.M == null ? 1 : this.M.getCost() + 1;
    }

    static {
        Aggregate.for("COUNT", 1);
        Aggregate.for("SUM", 3);
        Aggregate.for("MIN", 4);
        Aggregate.for("MAX", 5);
        Aggregate.for("AVG", 6);
        Aggregate.for("GROUP_CONCAT", 2);
        Aggregate.for("STDDEV_SAMP", 8);
        Aggregate.for("STDDEV", 8);
        Aggregate.for("STDDEV_POP", 7);
        Aggregate.for("STDDEVP", 7);
        Aggregate.for("VAR_POP", 9);
        Aggregate.for("VARP", 9);
        Aggregate.for("VAR_SAMP", 10);
        Aggregate.for("VAR", 10);
        Aggregate.for("VARIANCE", 10);
        Aggregate.for("BOOL_OR", 11);
        Aggregate.for("SOME", 11);
        Aggregate.for("BOOL_AND", 12);
        Aggregate.for("EVERY", 12);
        Aggregate.for("SELECTIVITY", 13);
    }
}

