/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Comparison;
import org.h2.expression.Condition;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.ValueExpression;
import org.h2.index.IndexCondition;
import org.h2.message.DbException;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;
import org.h2.value.ValueString;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CompareLike
extends Condition {
    private static final int aw = 0;
    private static final int at = 1;
    private static final int aq = 2;
    private final CompareMode as;
    private final String ao;
    private Expression an;
    private Expression av;
    private Expression ar;
    private boolean au;
    private char[] aj;
    private String ak;
    private int[] ag;
    private int ap;
    private final boolean ax;
    private Pattern ai;
    private boolean am;
    private boolean ah;
    private boolean al;

    public CompareLike(Database database, Expression expression, Expression expression2, Expression expression3, boolean bl) {
        this(database.getCompareMode(), database.getSettings().defaultEscape, expression, expression2, expression3, bl);
    }

    public CompareLike(CompareMode compareMode, String string, Expression expression, Expression expression2, Expression expression3, boolean bl) {
        this.as = compareMode;
        this.ao = string;
        this.ax = bl;
        this.an = expression;
        this.av = expression2;
        this.ar = expression3;
    }

    private static Character int(String string) {
        return string == null || string.length() == 0 ? null : Character.valueOf(string.charAt(0));
    }

    public String getSQL() {
        String string;
        if (this.ax) {
            string = this.an.getSQL() + " REGEXP " + this.av.getSQL();
        } else {
            string = this.an.getSQL() + " LIKE " + this.av.getSQL();
            if (this.ar != null) {
                string = string + " ESCAPE " + this.ar.getSQL();
            }
        }
        return "(" + string + ")";
    }

    public Expression optimize(Session session) {
        Value value;
        this.an = this.an.optimize(session);
        this.av = this.av.optimize(session);
        if (this.an.getType() == 14) {
            this.am = true;
        }
        if (this.an.isValueSet() && (value = this.an.getValue(session)) == ValueNull.INSTANCE) {
            return ValueExpression.getNull();
        }
        if (this.ar != null) {
            this.ar = this.ar.optimize(session);
        }
        if (this.av.isValueSet() && (this.ar == null || this.ar.isValueSet())) {
            Value value2;
            if (this.an.isValueSet()) {
                return ValueExpression.get(this.getValue(session));
            }
            value = this.av.getValue(session);
            if (value == ValueNull.INSTANCE) {
                return ValueExpression.getNull();
            }
            Value value3 = value2 = this.ar == null ? null : this.ar.getValue(session);
            if (value2 == ValueNull.INSTANCE) {
                return ValueExpression.getNull();
            }
            String string = value.getString();
            this.a(string, this.if(value2));
            if (this.al) {
                return ValueExpression.getNull();
            }
            if ("%".equals(string)) {
                return new Comparison(session, 7, this.an, null).optimize(session);
            }
            if (this.try()) {
                ValueString valueString = ValueString.get(this.ak);
                ValueExpression valueExpression = ValueExpression.get(valueString);
                return new Comparison(session, 0, this.an, valueExpression).optimize(session);
            }
            this.au = true;
        }
        return this;
    }

    private Character if(Value value) {
        Character c2;
        if (value == null) {
            return CompareLike.int(this.ao);
        }
        String string = value.getString();
        if (string == null) {
            c2 = CompareLike.int(this.ao);
        } else if (string.length() == 0) {
            c2 = null;
        } else {
            if (string.length() > 1) {
                throw DbException.get(22025, string);
            }
            c2 = Character.valueOf(string.charAt(0));
        }
        return c2;
    }

    public void createIndexConditions(Session session, TableFilter tableFilter) {
        Value value;
        if (this.ax) {
            return;
        }
        if (!(this.an instanceof ExpressionColumn)) {
            return;
        }
        ExpressionColumn expressionColumn = (ExpressionColumn)this.an;
        if (tableFilter != expressionColumn.getTableFilter()) {
            return;
        }
        if (!this.av.isValueSet()) {
            return;
        }
        if (this.ar != null && !this.ar.isValueSet()) {
            return;
        }
        String string = this.av.getValue(session).getString();
        Value value2 = value = this.ar == null ? null : this.ar.getValue(session);
        if (value == ValueNull.INSTANCE) {
            DbException.throwInternalError();
        }
        this.a(string, this.if(value));
        if (this.al) {
            return;
        }
        if (this.ap <= 0 || this.ag[0] != 0) {
            return;
        }
        int n2 = expressionColumn.getColumn().getType();
        if (n2 != 13 && n2 != 14 && n2 != 21) {
            return;
        }
        int n3 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        while (n3 < this.ap && this.ag[n3] == 0) {
            stringBuilder.append(this.aj[n3++]);
        }
        String string2 = stringBuilder.toString();
        if (n3 == this.ap) {
            tableFilter.addIndexCondition(IndexCondition.get(0, expressionColumn, ValueExpression.get(ValueString.get(string2))));
        } else if (string2.length() > 0) {
            tableFilter.addIndexCondition(IndexCondition.get(1, expressionColumn, ValueExpression.get(ValueString.get(string2))));
            char c2 = string2.charAt(string2.length() - 1);
            for (int i2 = 1; i2 < 2000; ++i2) {
                String string3 = string2.substring(0, string2.length() - 1) + (char)(c2 + i2);
                if (this.as.compareString(string2, string3, this.am) != -1) continue;
                tableFilter.addIndexCondition(IndexCondition.get(4, expressionColumn, ValueExpression.get(ValueString.get(string3))));
                break;
            }
        }
    }

    public Value getValue(Session session) {
        Object object;
        Value value = this.an.getValue(session);
        if (value == ValueNull.INSTANCE) {
            return value;
        }
        if (!this.au) {
            Value value2;
            object = this.av.getValue(session);
            if (object == ValueNull.INSTANCE) {
                return object;
            }
            String string = ((Value)object).getString();
            Value value3 = value2 = this.ar == null ? null : this.ar.getValue(session);
            if (value2 == ValueNull.INSTANCE) {
                return ValueNull.INSTANCE;
            }
            this.a(string, this.if(value2));
        }
        if (this.al) {
            return ValueNull.INSTANCE;
        }
        object = value.getString();
        boolean bl = this.ax ? this.ai.matcher((CharSequence)object).find() : this.a((String)object, 0, 0, ((String)object).length(), this.aj, this.ag);
        return ValueBoolean.get(bl);
    }

    private boolean a(char[] cArray, String string, int n2, int n3) {
        return cArray[n2] == string.charAt(n3) || !this.ah && this.as.equalsChars(this.ak, n2, string, n3, this.am);
    }

    private boolean a(String string, int n2, int n3, int n4, char[] cArray, int[] nArray) {
        while (n2 < this.ap) {
            switch (nArray[n2]) {
                case 0: {
                    if (n3 < n4 && this.a(cArray, string, n2, n3++)) break;
                    return false;
                }
                case 1: {
                    if (n3++ < n4) break;
                    return false;
                }
                case 2: {
                    if (++n2 >= this.ap) {
                        return true;
                    }
                    while (n3 < n4) {
                        if (this.a(cArray, string, n2, n3) && this.a(string, n2, n3, n4, cArray, nArray)) {
                            return true;
                        }
                        ++n3;
                    }
                    return false;
                }
                default: {
                    DbException.throwInternalError();
                }
            }
            ++n2;
        }
        return n3 == n4;
    }

    public boolean test(String string, String string2, char c2) {
        this.a(string, Character.valueOf(c2));
        if (this.al) {
            return false;
        }
        return this.a(string2, 0, 0, string2.length(), this.aj, this.ag);
    }

    private void a(String string, Character c2) {
        int n2;
        if (this.as.getName().equals("OFF") && !this.am) {
            this.ah = true;
        }
        if (this.ax) {
            this.ak = string;
            try {
                this.ai = this.am ? Pattern.compile(string, 2) : Pattern.compile(string);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw DbException.get(22025, patternSyntaxException, string);
            }
            return;
        }
        this.ap = 0;
        if (string == null) {
            this.ag = null;
            this.aj = null;
            return;
        }
        int n3 = string.length();
        this.aj = new char[n3];
        this.ag = new int[n3];
        boolean bl = false;
        for (n2 = 0; n2 < n3; ++n2) {
            int n4;
            char c3 = string.charAt(n2);
            if (c2 != null && c2.charValue() == c3) {
                if (n2 >= n3 - 1) {
                    this.al = true;
                    return;
                }
                c3 = string.charAt(++n2);
                n4 = 0;
                bl = false;
            } else if (c3 == '%') {
                if (bl) continue;
                n4 = 2;
                bl = true;
            } else if (c3 == '_') {
                n4 = 1;
            } else {
                n4 = 0;
                bl = false;
            }
            this.ag[this.ap] = n4;
            this.aj[this.ap++] = c3;
        }
        for (n2 = 0; n2 < this.ap - 1; ++n2) {
            if (this.ag[n2] != 2 || this.ag[n2 + 1] != 1) continue;
            this.ag[n2] = 1;
            this.ag[n2 + 1] = 2;
        }
        this.ak = new String(this.aj, 0, this.ap);
    }

    private boolean try() {
        if (this.ag == null) {
            return false;
        }
        for (int n2 : this.ag) {
            if (n2 == 0) continue;
            return false;
        }
        return true;
    }

    public void mapColumns(ColumnResolver columnResolver, int n2) {
        this.an.mapColumns(columnResolver, n2);
        this.av.mapColumns(columnResolver, n2);
        if (this.ar != null) {
            this.ar.mapColumns(columnResolver, n2);
        }
    }

    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.an.setEvaluatable(tableFilter, bl);
        this.av.setEvaluatable(tableFilter, bl);
        if (this.ar != null) {
            this.ar.setEvaluatable(tableFilter, bl);
        }
    }

    public void updateAggregate(Session session) {
        this.an.updateAggregate(session);
        this.av.updateAggregate(session);
        if (this.ar != null) {
            this.ar.updateAggregate(session);
        }
    }

    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.an.isEverything(expressionVisitor) && this.av.isEverything(expressionVisitor) && (this.ar == null || this.ar.isEverything(expressionVisitor));
    }

    public int getCost() {
        return this.an.getCost() + this.av.getCost() + 3;
    }
}

